/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.types.InitParam;
import com.caucho.config.types.InitProgram;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;

public class FilterConfigImpl
implements FilterConfig {
    private static final L10N L = new L10N(FilterConfigImpl._resin_compat_class_1());
    private String _filterName;
    private String _filterClassName;
    private Class _filterClass;
    private String _displayName;
    private HashMap<String, String> _initParams = new HashMap();
    private InitProgram _init;
    private ServletContext _servletContext;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    public void setFilterName(String name) {
        this._filterName = name;
    }

    public String getFilterName() {
        return this._filterName;
    }

    public void setFilterClass(String filterClassName) throws ConfigException, ClassNotFoundException {
        this._filterClassName = filterClassName;
        this._filterClass = CauchoSystem.loadClass(filterClassName);
        Config.validate(this._filterClass, FilterConfigImpl._resin_compat_class_0());
    }

    public Class getFilterClass() {
        return this._filterClass;
    }

    public String getFilterClassName() {
        return this._filterClassName;
    }

    public void setInitParam(String param, String value) {
        this._initParams.put(param, value);
    }

    public void setInitParam(InitParam initParam) {
        this._initParams.putAll(initParam.getParameters());
    }

    public Map getInitParamMap() {
        return this._initParams;
    }

    public String getInitParameter(String name) {
        return this._initParams.get(name);
    }

    public Enumeration getInitParameterNames() {
        return Collections.enumeration(this._initParams.keySet());
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public void setServletContext(ServletContext app) {
        this._servletContext = app;
    }

    public void setInit(InitProgram init) {
        this._init = init;
    }

    public InitProgram getInit() {
        return this._init;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public void setDescription(String description) {
    }

    public void setIcon(String icon) {
    }

    public String toString() {
        return new CharBuffer().append("FilterConfigImpl[name=").append(this._filterName).append(",class=").append(this._filterClass).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("javax.servlet.Filter");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.server.dispatch.FilterConfigImpl");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

