/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.deploy;

import com.caucho.config.ConfigException;
import com.caucho.config.types.FileSetType;
import com.caucho.config.types.Period;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.Environment;
import com.caucho.log.Log;
import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.deploy.DeployGenerator;
import com.caucho.server.deploy.ExpandDeployController;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.WeakAlarm;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExpandDeployGenerator<E extends ExpandDeployController>
extends DeployGenerator<E>
implements AlarmListener {
    private static final Logger log = Log.open(ExpandDeployGenerator._resin_compat_class_0());
    private static final L10N L = new L10N(ExpandDeployGenerator._resin_compat_class_0());
    private static final long MIN_CRON_INTERVAL = 5000L;
    private Path _path;
    private Path _archiveDirectory;
    private Path _expandDirectory;
    private String _extension = ".jar";
    private String _expandPrefix = "";
    private ArrayList<String> _requireFiles = new ArrayList();
    private TreeSet<String> _controllerNames = new TreeSet();
    private FileSetType _expandCleanupFileSet;
    private Alarm _alarm;
    private long _cronInterval;
    private volatile long _lastCheckTime;
    private volatile boolean _isChecking;
    private long _checkInterval = 1000L;
    private long _digest;
    private volatile boolean _isModified;
    private volatile boolean _isDeploying;
    private final Lifecycle _lifecycle = new Lifecycle();
    private static Class _resin_compat_class_0;

    public ExpandDeployGenerator(DeployContainer<E> container) {
        super(container);
        this._alarm = new WeakAlarm(this);
        this._cronInterval = Environment.getDependencyCheckInterval();
        if (this._cronInterval < 5000L) {
            this._cronInterval = 5000L;
        }
    }

    public Path getPath() {
        return this._path;
    }

    public void setPath(Path path) {
        this._path = path;
    }

    public void setExpandPath(Path path) {
        log.config("Use <expand-directory> instead of <expand-path>.  <expand-path> is deprecated.");
        this.setExpandDirectory(path);
    }

    public void setExpandDirectory(Path path) {
        this._expandDirectory = path;
    }

    public Path getExpandDirectory() {
        if (this._expandDirectory != null) {
            return this._expandDirectory;
        }
        return this._path;
    }

    public void setArchiveDirectory(Path path) {
        this._archiveDirectory = path;
    }

    public Path getArchiveDirectory() {
        if (this._archiveDirectory != null) {
            return this._archiveDirectory;
        }
        return this._path;
    }

    public void setDependencyCheckInterval(Period period) {
        this._cronInterval = period.getPeriod();
        if (this._cronInterval < 0L) {
            this._cronInterval = 4611686018427387000L;
        } else if (this._cronInterval < 5000L) {
            this._cronInterval = 5000L;
        }
    }

    public void setExpandCleanupFileset(FileSetType fileSet) {
        this._expandCleanupFileSet = fileSet;
    }

    public void setExtension(String extension) throws ConfigException {
        if (!extension.startsWith(".")) {
            throw new ConfigException(L.l("deployment extension '{0}' must begin with '.'", extension));
        }
        this._extension = extension;
    }

    public String getExtension() {
        return this._extension;
    }

    public void setExpandPrefix(String prefix) throws ConfigException {
        if (!(prefix.equals("") || prefix.startsWith("_") || prefix.startsWith("."))) {
            throw new ConfigException(L.l("expand-prefix '{0}' must start with '.' or '_'.", prefix));
        }
        this._expandPrefix = prefix;
    }

    public String getExpandPrefix() {
        return this._expandPrefix;
    }

    public void addRequireFile(String file) throws ConfigException {
        this._requireFiles.add(file);
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isModified() {
        ExpandDeployGenerator expandDeployGenerator = this;
        synchronized (expandDeployGenerator) {
            long now = Alarm.getCurrentTime();
            if (now < this._lastCheckTime + this._checkInterval || this._isChecking) {
                return this._isModified;
            }
            this._isChecking = true;
            this._lastCheckTime = Alarm.getCurrentTime();
        }
        try {
            long digest = this.getDigest();
            boolean bl = this._isModified = this._digest != digest;
            return bl;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            this._isChecking = false;
        }
    }

    public void init() throws ConfigException {
        if (!this._lifecycle.toInit()) {
            return;
        }
        if (this.getExpandDirectory() == null) {
            throw new ConfigException(L.l("<expand-directory> must be specified for deployment of archive expansion."));
        }
        if (this.getArchiveDirectory() == null) {
            throw new ConfigException(L.l("<archive-directory> must be specified for deployment of archive expansion."));
        }
    }

    @Override
    public void start() {
        try {
            this.init();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        if (!this._lifecycle.toActive()) {
            return;
        }
        log.finer(new CharBuffer().append(this).append(" starting").toString());
        this.handleAlarm(this._alarm);
    }

    @Override
    protected void fillDeployedKeys(Set<String> keys) {
        if (this.isModified()) {
            try {
                this.deploy();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        for (String name : this._controllerNames) {
            keys.add(name);
        }
    }

    @Override
    public void update() {
        this._lastCheckTime = 0L;
        this.request();
    }

    @Override
    public void request() {
        if (this.isModified()) {
            try {
                this.deploy();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deploy() throws Exception {
        boolean isDeploying = false;
        log.finer(new CharBuffer().append(this).append(" redeploy ").append(this._isDeploying).toString());
        try {
            ArrayList<String> updatedNames = null;
            ExpandDeployGenerator expandDeployGenerator = this;
            synchronized (expandDeployGenerator) {
                block13: {
                    if (!this._isDeploying) break block13;
                    return;
                }
                this._isDeploying = true;
                isDeploying = true;
                TreeSet<String> entryNames = this.findEntryNames();
                this._digest = this.getDigest();
                if (!this._controllerNames.equals(entryNames)) {
                    updatedNames = new ArrayList<String>();
                    for (String name : this._controllerNames) {
                        if (entryNames.contains(name)) continue;
                        updatedNames.add(name);
                    }
                    for (String name : entryNames) {
                        if (this._controllerNames.contains(name)) continue;
                        updatedNames.add(name);
                    }
                    this._controllerNames = entryNames;
                }
            }
            for (int i = 0; updatedNames != null && i < updatedNames.size(); ++i) {
                String name = (String)updatedNames.get(i);
                this.getDeployContainer().update(name);
            }
        }
        finally {
            if (isDeploying) {
                this._isModified = false;
                this._isDeploying = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E generateController(String name) {
        this.request();
        if (!this._controllerNames.contains(name)) {
            return null;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getParentClassLoader());
            E controller = this.createController(name);
            if (controller != null) {
                ((ExpandDeployController)controller).setExpandCleanupFileSet(this._expandCleanupFileSet);
            }
            E e = controller;
            return e;
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    private long getDigest() {
        long archiveDigest = 0L;
        Path archiveDirectory = this.getArchiveDirectory();
        if (archiveDirectory != null) {
            archiveDigest = archiveDirectory.getCrc64();
        }
        long expandDigest = 0L;
        Path expandDirectory = this.getExpandDirectory();
        if (expandDirectory != null) {
            expandDigest = expandDirectory.getCrc64();
        }
        return archiveDigest * 65521L + expandDigest;
    }

    private TreeSet<String> findEntryNames() throws IOException {
        TreeSet<String> entryNames = new TreeSet<String>();
        Path archiveDirectory = this.getArchiveDirectory();
        Path expandDirectory = this.getExpandDirectory();
        if (archiveDirectory == null || expandDirectory == null) {
            return entryNames;
        }
        String[] entryList = archiveDirectory.list();
        for (int i = 0; i < entryList.length; ++i) {
            String archiveName = entryList[i];
            Path archivePath = archiveDirectory.lookup(archiveName);
            String entryName = null;
            if (!archivePath.canRead() || (entryName = this.archiveNameToEntryName(archiveName)) == null) continue;
            entryNames.add(entryName);
        }
        String[] entryExpandList = expandDirectory.list();
        block1: for (int i = 0; i < entryExpandList.length; ++i) {
            String pathName = entryExpandList[i];
            Path rootDirectory = expandDirectory.lookup(pathName);
            String entryName = this.pathNameToEntryName(pathName);
            if (entryName == null || entryName.endsWith(this.getExtension()) || !rootDirectory.isDirectory() || pathName.startsWith(".") || pathName.equalsIgnoreCase("web-inf") || pathName.equalsIgnoreCase("meta-inf")) continue;
            for (int j = 0; j < this._requireFiles.size(); ++j) {
                String file = this._requireFiles.get(j);
                if (!rootDirectory.lookup(file).canRead()) continue block1;
            }
            if (entryNames.contains(entryName)) continue;
            entryNames.add(entryName);
        }
        return entryNames;
    }

    protected String pathNameToEntryName(String name) {
        if (this._expandPrefix == null) {
            return name;
        }
        if (this._expandPrefix.equals("") && (name.startsWith("_") || name.startsWith(".") || name.equalsIgnoreCase("META-INF") || name.equalsIgnoreCase("WEB-INF"))) {
            return null;
        }
        if (name.startsWith(this._expandPrefix)) {
            return name.substring(this._expandPrefix.length());
        }
        return null;
    }

    protected String archiveNameToEntryName(String archiveName) {
        if (!archiveName.endsWith(this._extension)) {
            return null;
        }
        int sublen = archiveName.length() - this._extension.length();
        return this.pathNameToEntryName(archiveName.substring(0, sublen));
    }

    protected abstract E createController(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleAlarm(Alarm alarm) {
        if (!this._lifecycle.isActive()) {
            return;
        }
        try {
            this.request();
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        finally {
            this._alarm.queue(this._cronInterval);
        }
    }

    @Override
    public void stop() {
        this._lifecycle.toStop();
        this._alarm.dequeue();
    }

    @Override
    public void destroy() {
        this.stop();
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        this._lifecycle.toDestroy();
    }

    public boolean equals(Object o) {
        Path deployExpandDirectory;
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        ExpandDeployGenerator deploy = (ExpandDeployGenerator)o;
        Path expandDirectory = this.getExpandDirectory();
        return expandDirectory == (deployExpandDirectory = deploy.getExpandDirectory()) || expandDirectory != null && expandDirectory.equals(deployExpandDirectory);
    }

    public String toString() {
        String name = this.getClass().getName();
        int p = name.lastIndexOf(46);
        if (p > 0) {
            name = name.substring(p + 1);
        }
        return new CharBuffer().append(name).append("[").append(this.getExpandDirectory()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.deploy.ExpandDeployGenerator");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

