/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.deploy;

import com.caucho.log.Log;
import com.caucho.make.Dependency;
import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.deploy.DeployController;
import com.caucho.server.deploy.DeployGenerator;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployListGenerator<E extends DeployController>
extends DeployGenerator<E>
implements Dependency {
    private static final Logger log = Log.open(DeployListGenerator._resin_compat_class_0());
    private static final L10N L = new L10N(DeployListGenerator._resin_compat_class_0());
    private ArrayList<DeployGenerator<E>> _generatorList = new ArrayList();
    private static Class _resin_compat_class_0;

    public DeployListGenerator(DeployContainer container) {
        super(container);
    }

    public void add(DeployGenerator<E> deploy) {
        if (!this._generatorList.contains(deploy)) {
            this._generatorList.add(deploy);
        }
    }

    public void remove(DeployGenerator<E> deploy) {
        this._generatorList.remove(deploy);
    }

    @Override
    public boolean isModified() {
        for (int i = this._generatorList.size() - 1; i >= 0; --i) {
            if (!this._generatorList.get(i).isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void request() {
        for (int i = this._generatorList.size() - 1; i >= 0; --i) {
            this._generatorList.get(i).request();
        }
    }

    @Override
    public void update() {
        for (int i = 0; i < this._generatorList.size(); ++i) {
            this._generatorList.get(i).update();
        }
    }

    @Override
    public void fillDeployedKeys(Set<String> keys) {
        for (int i = 0; i < this._generatorList.size(); ++i) {
            this._generatorList.get(i).fillDeployedKeys(keys);
        }
    }

    @Override
    protected E generateController(String key) {
        for (int i = 0; i < this._generatorList.size(); ++i) {
            E controller = this._generatorList.get(i).generateController(key);
            if (controller == null) continue;
            for (int j = 0; j < this._generatorList.size(); ++j) {
                if (i == j) continue;
                DeployGenerator<E> generator = this._generatorList.get(j);
                controller = this._generatorList.get(j).mergeController(controller, key);
            }
            return controller;
        }
        return null;
    }

    @Override
    protected E mergeController(E controller, String key) {
        for (int i = 0; i < this._generatorList.size(); ++i) {
            controller = this._generatorList.get(i).mergeController(controller, key);
        }
        return controller;
    }

    @Override
    public void start() {
        for (int i = 0; i < this._generatorList.size(); ++i) {
            this._generatorList.get(i).start();
        }
    }

    @Override
    public void stop() {
        for (int i = 0; i < this._generatorList.size(); ++i) {
            this._generatorList.get(i).stop();
        }
    }

    @Override
    public void destroy() {
        ArrayList<DeployGenerator<E>> generatorList = new ArrayList<DeployGenerator<E>>(this._generatorList);
        this._generatorList.clear();
        for (int i = 0; i < generatorList.size(); ++i) {
            try {
                generatorList.get(i).destroy();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    public String toString() {
        return new CharBuffer().append("DeployListGenerator").append(this._generatorList).toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.deploy.DeployListGenerator");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

