/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.deploy;

import com.caucho.bytecode.compat.Box;
import com.caucho.jmx.AdminAttributeCategory;
import com.caucho.jmx.AdminInfo;
import com.caucho.jmx.AdminInfoFactory;
import com.caucho.jmx.AdminOperationInfo;
import com.caucho.jmx.MBeanHandle;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.lifecycle.LifecycleListener;
import com.caucho.server.deploy.DeployController;
import com.caucho.server.deploy.EnvironmentDeployController;
import com.caucho.server.deploy.ExpandDeployController;
import com.caucho.server.deploy.mbean.DeployControllerMBean;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import java.io.Serializable;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeChangeNotification;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployControllerAdmin<C extends EnvironmentDeployController>
implements DeployControllerMBean,
NotificationEmitter,
LifecycleListener,
AdminInfoFactory,
Serializable {
    private final transient C _controller;
    private final transient NotificationBroadcasterSupport _broadcaster;
    private long _sequence = 0L;

    public DeployControllerAdmin(C controller) {
        this._controller = controller;
        this._broadcaster = new NotificationBroadcasterSupport();
        ((DeployController)controller).addLifecycleListener(this);
    }

    @Override
    public AdminInfo getAdminInfo() {
        AdminInfo descriptor = new AdminInfo();
        descriptor.createAdminAttributeInfo("ObjectName").setIgnored(true);
        descriptor.createAdminAttributeInfo("RootDirectory").setCategory(AdminAttributeCategory.CONFIGURATION);
        descriptor.createAdminAttributeInfo("State").setCategory(AdminAttributeCategory.STATISTIC);
        descriptor.createAdminAttributeInfo("StartTime").setCategory(AdminAttributeCategory.STATISTIC);
        descriptor.createAdminOperationInfo("Start").setImpact(1).setEnabled(new AdminOperationInfo.Closure(){

            public Object eval() {
                return Box.boxBoolean(((DeployController)DeployControllerAdmin.this.getController()).isStopped());
            }
        });
        descriptor.createAdminOperationInfo("Restart").setImpact(1).setEnabled(new AdminOperationInfo.Closure(){

            public Object eval() {
                return Box.boxBoolean(((DeployController)DeployControllerAdmin.this.getController()).isActive());
            }
        });
        descriptor.createAdminOperationInfo("Update").setImpact(1);
        return descriptor;
    }

    protected C getController() {
        return this._controller;
    }

    @Override
    public ObjectName getObjectName() {
        return ((EnvironmentDeployController)this._controller).getObjectName();
    }

    @Override
    public String getState() {
        return ((DeployController)this.getController()).getState();
    }

    @Override
    public Date getStartTime() {
        return new Date(((DeployController)this.getController()).getStartTime());
    }

    @Override
    public void start() throws Exception {
        ((DeployController)this.getController()).start();
    }

    @Override
    public void stop() throws Exception {
        ((DeployController)this.getController()).stop();
    }

    @Override
    public void restart() throws Exception {
        ((DeployController)this.getController()).stop();
        ((DeployController)this.getController()).start();
    }

    @Override
    public void update() throws Exception {
        ((DeployController)this.getController()).update();
    }

    public String getRootDirectory() {
        return ((ExpandDeployController)this._controller).getRootDirectory().getNativePath();
    }

    public Object writeReplace() {
        return new MBeanHandle(((EnvironmentDeployController)this.getController()).getObjectName());
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this._broadcaster.addNotificationListener(listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this._broadcaster.removeNotificationListener(listener);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this._broadcaster.removeNotificationListener(listener, filter, handback);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo status = new MBeanNotificationInfo(new String[]{"jmx.attribute.change"}, "status", "status attribute changes");
        return new MBeanNotificationInfo[]{status};
    }

    @Override
    public synchronized void lifecycleEvent(int oldState, int newState) {
        String newValue;
        Logger log = ((DeployController)this._controller).getLog();
        long timestamp = Alarm.getCurrentTime();
        String oldValue = Lifecycle.getStateName(oldState);
        String message = newValue = Lifecycle.getStateName(newState);
        long sequence = this._sequence++;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, new CharBuffer().append(this.toString()).append(" lifecycleEvent `").append(newValue).append("'").toString());
        }
        AttributeChangeNotification notification = new AttributeChangeNotification(this, sequence, timestamp, message, "State", "java.lang.String", oldValue, newValue);
        this._broadcaster.sendNotification(notification);
    }

    public String toString() {
        String name = this.getClass().getName();
        int i = name.lastIndexOf(46) + 1;
        if (i > 0 && i < name.length()) {
            name = name.substring(i);
        }
        return new CharBuffer().append(name).append("[").append(this.getObjectName()).append("]").toString();
    }
}

