/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.deploy;

import com.caucho.config.ConfigException;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.lifecycle.LifecycleListener;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.log.Log;
import com.caucho.make.Dependency;
import com.caucho.server.deploy.DeployControllerStrategy;
import com.caucho.server.deploy.DeployInstance;
import com.caucho.server.deploy.StartAutoRedeployAutoStrategy;
import com.caucho.server.deploy.StartAutoRedeployManualStrategy;
import com.caucho.server.deploy.StartLazyRedeployAutomaticStrategy;
import com.caucho.server.deploy.StartLazyRedeployManualStrategy;
import com.caucho.server.deploy.StartManualRedeployManualStrategy;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.WeakAlarm;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DeployController<I extends DeployInstance>
implements Dependency,
AlarmListener {
    private static final Logger log;
    private static final L10N L;
    public static final String STARTUP_DEFAULT = "default";
    public static final String STARTUP_AUTOMATIC = "automatic";
    public static final String STARTUP_LAZY = "lazy";
    public static final String STARTUP_MANUAL = "manual";
    public static final String REDEPLOY_DEFAULT = "default";
    public static final String REDEPLOY_AUTOMATIC = "automatic";
    public static final String REDEPLOY_LAZY = "lazy";
    public static final String REDEPLOY_MANUAL = "manual";
    private ClassLoader _parentLoader;
    private String _id;
    private String _startupMode = "default";
    private String _redeployMode = "default";
    private DeployControllerStrategy _strategy;
    protected final Lifecycle _lifecycle;
    private Alarm _alarm = new WeakAlarm(this);
    private long _redeployCheckInterval = 60000L;
    private long _startTime;
    private I _deployInstance;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static Class _resin_compat_class_0;

    protected DeployController(String id) {
        this(id, null);
    }

    protected DeployController(String id, ClassLoader parentLoader) {
        this._id = id;
        if (parentLoader == null) {
            parentLoader = Thread.currentThread().getContextClassLoader();
        }
        this._parentLoader = parentLoader;
        this._lifecycle = new Lifecycle(this.getLog(), this.toString());
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this._lifecycle.addListener(listener);
    }

    public final String getId() {
        return this._id;
    }

    public ClassLoader getParentClassLoader() {
        return this._parentLoader;
    }

    public void setStartupMode(String mode) {
        try {
            this._startupMode = DeployController.toStartupCode(mode);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void mergeController(DeployController<I> newController) {
    }

    public void mergeStartupMode(String mode) {
        if (mode == null || "default".equals(mode)) {
            return;
        }
        this._startupMode = mode;
    }

    public String getStartupMode() {
        return this._startupMode;
    }

    public static String toStartupCode(String mode) throws ConfigException {
        if ("automatic".equals(mode)) {
            return "automatic";
        }
        if ("lazy".equals(mode)) {
            return "lazy";
        }
        if ("manual".equals(mode)) {
            return "manual";
        }
        throw new ConfigException(L.l("'{0}' is an unknown startup-mode.  'automatic', 'lazy', and 'manual' are the acceptable values.", mode));
    }

    public void setRedeployMode(String mode) {
        try {
            this._redeployMode = DeployController.toRedeployCode(mode);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void mergeRedeployMode(String mode) {
        if (mode == null || "default".equals(mode)) {
            return;
        }
        this._redeployMode = mode;
    }

    public String getRedeployMode() {
        return this._redeployMode;
    }

    public static String toRedeployCode(String mode) throws ConfigException {
        if ("automatic".equals(mode)) {
            return "automatic";
        }
        if ("lazy".equals(mode)) {
            return "lazy";
        }
        if ("manual".equals(mode)) {
            return "manual";
        }
        throw new ConfigException(L.l("'{0}' is an unknown redeploy-mode.  'automatic', 'lazy', and 'manual' are the acceptable values.", mode));
    }

    public boolean isNameMatch(String name) {
        return this.getId().equals(name);
    }

    public long getStartTime() {
        return this._startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean init() {
        if (!this._lifecycle.toInitializing()) {
            return false;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getParentClassLoader());
            this.initBegin();
            if (this._startupMode == "manual") {
                if (this._redeployMode == "automatic") {
                    throw new IllegalStateException(L.l("startup='manual' and redeploy='automatic' is an unsupported combination."));
                }
                this._strategy = StartManualRedeployManualStrategy.create();
            } else {
                this._strategy = this._startupMode == "lazy" ? (this._redeployMode == "manual" ? StartLazyRedeployManualStrategy.create() : StartLazyRedeployAutomaticStrategy.create()) : (this._redeployMode == "manual" ? StartAutoRedeployManualStrategy.create() : StartAutoRedeployAutoStrategy.create());
            }
            this.initEnd();
            boolean bl = this._lifecycle.toInit();
            return bl;
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    protected void initBegin() {
    }

    protected void initEnd() {
    }

    protected String getMBeanTypeName() {
        String className = this.getDeployInstance().getClass().getName();
        int p = className.lastIndexOf(46);
        if (p > 0) {
            className = className.substring(p + 1);
        }
        return className;
    }

    protected String getMBeanId() {
        String name = this.getId();
        if (name == null || name.equals("")) {
            name = "default";
        }
        return name;
    }

    public String getState() {
        if (this.isDestroyed()) {
            return "destroyed";
        }
        if (this.isStoppedLazy()) {
            return "stopped-lazy";
        }
        if (this.isStopped()) {
            return "stopped";
        }
        if (this.isError()) {
            return "error";
        }
        if (this.isModified()) {
            return "active-modified";
        }
        return "active";
    }

    public boolean isActive() {
        return this._lifecycle.isActive();
    }

    public boolean isStopped() {
        return this._lifecycle.isStopped() || this._lifecycle.isInit();
    }

    public boolean isStoppedLazy() {
        return this._lifecycle.isInit();
    }

    public boolean isActiveIdle() {
        I instance = this.getDeployInstance();
        if (!this._lifecycle.isActive()) {
            return false;
        }
        if (instance == null) {
            return false;
        }
        return instance.isDeployIdle();
    }

    public boolean isError() {
        if (this._lifecycle.isError()) {
            return true;
        }
        I instance = this.getDeployInstance();
        return instance != null && instance.getConfigException() != null;
    }

    public boolean isErrorNow() {
        if (this._lifecycle.isError()) {
            return true;
        }
        I instance = this.getDeployInstance();
        return instance != null && instance.getConfigException() != null;
    }

    @Override
    public boolean isModified() {
        I instance = this.getDeployInstance();
        return instance == null || instance.isModified();
    }

    public boolean isModifiedNow() {
        I instance = this.getDeployInstance();
        return instance == null || instance.isModifiedNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I getDeployInstance() {
        DeployController deployController = this;
        synchronized (deployController) {
            if (this._deployInstance == null) {
                this._deployInstance = this.instantiateDeployInstance();
            }
            return this._deployInstance;
        }
    }

    public void startOnInit() {
        if (!this._lifecycle.isAfterInit()) {
            throw new IllegalStateException(L.l("startOnInit must be called after init (in '{0}')", this._lifecycle.getStateName()));
        }
        this._strategy.startOnInit(this);
    }

    public final void start() {
        this._strategy.start(this);
    }

    public final void stop() {
        this._strategy.stop(this);
    }

    public final void restart() {
        this._strategy.stop(this);
        this._strategy.start(this);
    }

    public final void update() {
        this._strategy.update(this);
    }

    public I request() {
        if (this._lifecycle.isDestroyed()) {
            return null;
        }
        if (this._strategy != null) {
            return this._strategy.request(this);
        }
        return null;
    }

    public I subrequest() {
        if (this._lifecycle.isDestroyed()) {
            return null;
        }
        if (this._strategy != null) {
            return this._strategy.subrequest(this);
        }
        return null;
    }

    I restartImpl() {
        if (!this._lifecycle.isStopped() && !this._lifecycle.isInit()) {
            this.stopImpl();
        }
        return this.startImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected I startImpl() {
        if (!$assertionsDisabled && !this._lifecycle.isAfterInit()) {
            throw new AssertionError();
        }
        if (DynamicClassLoader.isModified(this._parentLoader)) {
            this._deployInstance = null;
            return null;
        }
        I deployInstance = this.getDeployInstance();
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        ClassLoader loader = null;
        boolean isStarting = false;
        try {
            loader = deployInstance.getClassLoader();
            thread.setContextClassLoader(loader);
            isStarting = this._lifecycle.toStarting();
            if (!isStarting) {
                I i = deployInstance;
                return i;
            }
            this.expandArchive();
            this.addManifestClassPath();
            this.configureInstance(deployInstance);
            deployInstance.start();
            this._startTime = Alarm.getCurrentTime();
        }
        catch (ConfigException e) {
            log.severe(e.toString());
            log.log(Level.FINE, e.toString(), e);
            this._lifecycle.toError();
            if (deployInstance != null) {
                deployInstance.setConfigException(e);
            }
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, e.toString(), e);
            this._lifecycle.toError();
            if (deployInstance != null) {
                deployInstance.setConfigException(e);
            }
        }
        finally {
            if (isStarting) {
                this._lifecycle.toActive();
            }
            if (loader instanceof DynamicClassLoader) {
                ((DynamicClassLoader)loader).clearModified();
            }
            if (this._alarm != null) {
                this._alarm.queue(this._redeployCheckInterval);
            }
            thread.setContextClassLoader(oldLoader);
        }
        return deployInstance;
    }

    protected void expandArchive() throws Exception {
    }

    void stopLazyImpl() {
        if (this._lifecycle.isInit()) {
            return;
        }
        this.stopImpl();
        this._lifecycle.toPostInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopImpl() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        I oldInstance = this._deployInstance;
        boolean isStopping = false;
        if (oldInstance != null) {
            thread.setContextClassLoader(oldInstance.getClassLoader());
        }
        try {
            isStopping = this._lifecycle.toStopping();
            if (!isStopping) {
                return;
            }
            DeployController deployController = this;
            synchronized (deployController) {
                oldInstance = this._deployInstance;
                this._deployInstance = null;
            }
            if (oldInstance != null) {
                oldInstance.destroy();
            }
        }
        finally {
            if (isStopping) {
                this._lifecycle.toStop();
            }
            thread.setContextClassLoader(oldLoader);
        }
    }

    protected abstract I instantiateDeployInstance();

    protected void addManifestClassPath() throws IOException {
    }

    protected void configureInstance(I deployInstance) throws Throwable {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleAlarm(Alarm alarm) {
        try {
            this._strategy.alarm(this);
        }
        finally {
            if (!this._lifecycle.isDestroyed()) {
                alarm.queue(this._redeployCheckInterval);
            }
        }
    }

    public boolean isDestroyed() {
        return this._lifecycle.isDestroyed();
    }

    protected boolean destroy() {
        if (this._lifecycle.isAfterInit()) {
            this.stop();
        }
        if (!this._lifecycle.toDestroy()) {
            return false;
        }
        Alarm alarm = this._alarm;
        this._alarm = null;
        if (alarm != null) {
            alarm.dequeue();
        }
        return true;
    }

    protected Logger getLog() {
        return log;
    }

    public String toString() {
        String className = this.getClass().getName();
        int p = className.lastIndexOf(46);
        return new CharBuffer().append(className.substring(p + 1)).append("[").append(this.getId()).append("]").toString();
    }

    static {
        $assertionsDisabled = !DeployController._resin_compat_class_0().desiredAssertionStatus();
        log = Log.open(DeployController._resin_compat_class_0());
        L = new L10N(DeployController._resin_compat_class_0());
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.deploy.DeployController");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

