/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.deploy;

import com.caucho.config.BuilderProgram;
import com.caucho.config.BuilderProgramContainer;
import com.caucho.config.ConfigException;
import com.caucho.config.ObjectAttributeProgram;
import com.caucho.config.types.PathBuilder;
import com.caucho.config.types.RawString;
import com.caucho.server.deploy.DeployController;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployConfig {
    private static final Logger log = Logger.getLogger(DeployConfig._resin_compat_class_0().getName());
    private String _id = "";
    private String _rootDirectory;
    private String _archivePath;
    private String _startupMode;
    private String _redeployMode;
    private BuilderProgramContainer _program = new BuilderProgramContainer();
    private static Class _resin_compat_class_0;

    public void setId(String id) {
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public void setRootDirectory(RawString rootDirectory) {
        this._rootDirectory = rootDirectory.getValue();
    }

    public String getRootDirectory() {
        return this._rootDirectory;
    }

    public void setArchivePath(RawString path) {
        this._archivePath = path.getValue();
    }

    public String getArchivePath() {
        return this._archivePath;
    }

    public void setStartupMode(String mode) throws ConfigException {
        this._startupMode = DeployController.toStartupCode(mode);
    }

    public String getStartupMode() {
        return this._startupMode;
    }

    public void setRedeployMode(String mode) throws ConfigException {
        this._redeployMode = DeployController.toRedeployCode(mode);
    }

    public String getRedeployMode() {
        return this._redeployMode;
    }

    public void addBuilderProgram(BuilderProgram program) {
        this._program.addProgram(program);
    }

    public BuilderProgram getBuilderProgram() {
        return this._program;
    }

    public void addPropertyProgram(String name, Object value) {
        this._program.addProgram(new ObjectAttributeProgram(name, value));
    }

    public Path calculateRootDirectory() {
        return this.calculateRootDirectory(null);
    }

    public Path calculateRootDirectory(Map<String, Object> varMap) {
        try {
            String rawPath = this.getRootDirectory();
            Path rootDir = null;
            if (rawPath != null) {
                rootDir = PathBuilder.lookupPath(rawPath, varMap);
            }
            if (rootDir != null) {
                return rootDir;
            }
            return Vfs.lookup();
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.deploy.DeployConfig");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

