/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.connection;

import com.caucho.log.Log;
import com.caucho.server.connection.AbstractHttpRequest;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.HashMapImpl;
import com.caucho.util.L10N;
import com.caucho.vfs.MultipartStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MultipartForm {
    static final Logger log = Log.open(MultipartForm._resin_compat_class_0());
    static final L10N L = new L10N(MultipartForm._resin_compat_class_0());
    private static Class _resin_compat_class_0;

    MultipartForm() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void parsePostData(HashMapImpl<String, String[]> table, ReadStream rawIs, String boundary, AbstractHttpRequest request, String javaEncoding, long uploadMax) throws IOException {
        ReadStream is;
        MultipartStream ms = new MultipartStream(rawIs, boundary);
        ms.setEncoding(javaEncoding);
        while ((is = ms.openRead()) != null) {
            String attr = (String)ms.getAttribute("content-disposition");
            if (attr == null || !attr.startsWith("form-data")) continue;
            String name = MultipartForm.getAttribute(attr, "name");
            String filename = MultipartForm.getAttribute(attr, "filename");
            if (name == null) continue;
            if (filename != null) {
                String contentType = (String)ms.getAttribute("content-type");
                Path tempDir = CauchoSystem.getWorkPath().lookup("form");
                try {
                    tempDir.mkdirs();
                }
                catch (IOException e) {
                    // empty catch block
                }
                Path tempFile = tempDir.createTempFile("form", ".tmp");
                request.addCloseOnExit(tempFile);
                WriteStream os = tempFile.openWrite();
                TempBuffer tempBuffer = TempBuffer.allocate();
                byte[] buf = tempBuffer.getBuffer();
                int totalLength = 0;
                try {
                    int len;
                    while ((len = is.read(buf, 0, buf.length)) > 0) {
                        os.write(buf, 0, len);
                        totalLength += len;
                    }
                }
                finally {
                    os.close();
                    TempBuffer.free(tempBuffer);
                }
                if (uploadMax > 0L && uploadMax < tempFile.getLength()) {
                    String msg = L.l("multipart form data `{0}' too large", new CharBuffer().append("").append(tempFile.getLength()).toString());
                    request.setAttribute("caucho.multipart.form.error", msg);
                    request.setAttribute("caucho.multipart.form.error.size", new Long(tempFile.getLength()));
                    tempFile.remove();
                    throw new IOException(msg);
                }
                if (tempFile.getLength() != (long)totalLength) {
                    String msg = L.l("multipart form upload failed (possibly due to full disk).");
                    request.setAttribute("caucho.multipart.form.error", msg);
                    request.setAttribute("caucho.multipart.form.error.size", new Long(tempFile.getLength()));
                    tempFile.remove();
                    throw new IOException(msg);
                }
                MultipartForm.addTable(table, name, tempFile.getNativePath());
                MultipartForm.addTable(table, new CharBuffer().append(name).append(".file").toString(), tempFile.getNativePath());
                MultipartForm.addTable(table, new CharBuffer().append(name).append(".filename").toString(), filename);
                MultipartForm.addTable(table, new CharBuffer().append(name).append(".content-type").toString(), contentType);
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine(new CharBuffer().append("mp-file: ").append(name).append("(filename:").append(filename).append(")").toString());
                continue;
            }
            CharBuffer value = new CharBuffer();
            int ch = is.readChar();
            while (ch >= 0) {
                value.append((char)ch);
                ch = is.readChar();
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine(new CharBuffer().append("mp-form: ").append(name).append("=").append((Object)value).toString());
            }
            MultipartForm.addTable(table, name, value.toString());
        }
        if (!ms.isComplete()) {
            throw new IOException("Incomplete form");
        }
    }

    private static void addTable(HashMapImpl<String, String[]> table, String name, String value) {
        String[] oldArray = table.get(name);
        if (oldArray != null) {
            String[] newArray = new String[oldArray.length + 1];
            System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
            newArray[oldArray.length] = value;
            table.put(name, newArray);
        } else {
            table.put(name, new String[]{value});
        }
    }

    private static String getAttribute(String attr, String name) {
        CharBuffer value;
        block8: {
            char ch;
            int i;
            int length;
            block9: {
                block7: {
                    if (attr == null) {
                        return null;
                    }
                    length = attr.length();
                    i = attr.indexOf(name);
                    if (i < 0) {
                        return null;
                    }
                    i += name.length();
                    while (i < length && attr.charAt(i) != '=') {
                        ++i;
                    }
                    ++i;
                    while (i < length && attr.charAt(i) == ' ') {
                        ++i;
                    }
                    value = CharBuffer.allocate();
                    if (i >= length || attr.charAt(i) != '\'') break block7;
                    ++i;
                    while (i < length && attr.charAt(i) != '\'') {
                        value.append(attr.charAt(i));
                        ++i;
                    }
                    break block8;
                }
                if (i >= length || attr.charAt(i) != '\"') break block9;
                ++i;
                while (i < length && attr.charAt(i) != '\"') {
                    value.append(attr.charAt(i));
                    ++i;
                }
                break block8;
            }
            if (i >= length) break block8;
            while (i < length && (ch = attr.charAt(i)) != ' ' && ch != ';') {
                value.append(ch);
                ++i;
            }
        }
        return value.close();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.connection.MultipartForm");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

