/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.server.cluster.Cluster;
import com.caucho.server.cluster.ClusterObject;
import com.caucho.server.cluster.FileBacking;
import com.caucho.server.cluster.Store;
import com.caucho.server.cluster.StoreManager;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.Vfs;
import java.util.logging.Level;

public class FileStore
extends StoreManager {
    protected FileBacking _backing = new FileBacking();

    public void setPath(Path path) {
        this._backing.setPath(path);
    }

    public void addText(String value) {
        this._backing.setPath(Vfs.lookup(value.trim()));
    }

    public Path getPath() {
        return this._backing.getPath();
    }

    public boolean init() throws Exception {
        if (!super.init()) {
            return false;
        }
        Cluster.getLocal();
        String serverId = Cluster.getServerId();
        String tableName = this._backing.serverNameToTableName(serverId);
        this._backing.setTableName(tableName);
        this._backing.init(1);
        return true;
    }

    public boolean start() throws Exception {
        if (!super.start()) {
            return false;
        }
        this._backing.start();
        return true;
    }

    public void clearOldObjects() {
        try {
            this._backing.clearOldObjects(this.getMaxIdleTime());
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    ClusterObject create(Store store, String id) {
        return new ClusterObject((StoreManager)this, store, id);
    }

    public boolean load(ClusterObject clusterObj, Object obj) throws Exception {
        return this._backing.loadSelf(clusterObj, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(ClusterObject obj, TempStream tempStream, long crc, int updateCount) throws Exception {
        if (crc == 0L && updateCount == 0) {
            return;
        }
        ReadStream is = tempStream.openRead(true);
        try {
            this._backing.storeSelf(obj.getUniqueId(), is, tempStream.getLength(), obj.getExpireInterval(), 0, 0);
        }
        finally {
            is.close();
        }
    }

    public void accessImpl(String uniqueId) throws Exception {
        this._backing.updateAccess(uniqueId);
    }

    public void remove(ClusterObject obj) throws Exception {
        this.removeClusterObject(obj.getStoreId(), obj.getObjectId());
        this._backing.remove(obj.getUniqueId());
    }
}

