/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.loader.EnvironmentLocal;
import com.caucho.log.Log;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.cluster.ClusterPort;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterContainer {
    protected static final Logger log = Log.open(ClusterContainer._resin_compat_class_0());
    static final EnvironmentLocal<ClusterContainer> _clusterContainerLocal = new EnvironmentLocal("caucho.cluster.container");
    private ClusterContainer _parent;
    private ArrayList<Cluster> _clusterList = new ArrayList();
    private static Class _resin_compat_class_0;

    private ClusterContainer() {
    }

    public static ClusterContainer create() {
        ClusterContainer container = _clusterContainerLocal.getLevel();
        if (container == null) {
            container = new ClusterContainer();
            ClusterContainer parent = _clusterContainerLocal.get();
            container.setParent(parent);
            _clusterContainerLocal.set(container);
        }
        return container;
    }

    public static ClusterContainer getLocal() {
        return _clusterContainerLocal.get();
    }

    private void setParent(ClusterContainer parent) {
        this._parent = parent;
    }

    private ClusterContainer getParent() {
        return this._parent;
    }

    public void addCluster(Cluster cluster) {
        this._clusterList.add(cluster);
    }

    public ArrayList<Cluster> getClusterList() {
        return this._clusterList;
    }

    public Cluster findCluster(String id) {
        for (int i = 0; i < this._clusterList.size(); ++i) {
            Cluster cluster = this._clusterList.get(i);
            if (!id.equals(cluster.getId())) continue;
            return cluster;
        }
        if (this._parent != null) {
            return this._parent.findCluster(id);
        }
        return null;
    }

    public ArrayList<ClusterPort> getServerPorts(String serverId) {
        ArrayList<ClusterPort> ports = new ArrayList<ClusterPort>();
        for (int i = 0; i < this._clusterList.size(); ++i) {
            Cluster cluster = this._clusterList.get(i);
            ports.addAll(cluster.getServerPorts(serverId));
        }
        return ports;
    }

    public String toString() {
        return "ClusterContainer[]";
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.server.cluster.ClusterContainer");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

