/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.resources;

import com.caucho.config.ConfigException;
import com.caucho.config.types.CronType;
import com.caucho.jca.AbstractResourceAdapter;
import com.caucho.log.Log;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.ThreadPool;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkManager;

public class CronResource
extends AbstractResourceAdapter
implements AlarmListener {
    private static final L10N L = new L10N(CronResource._resin_compat_class_0());
    private static final Logger log = Log.open(CronResource._resin_compat_class_0());
    private ClassLoader _loader = Thread.currentThread().getContextClassLoader();
    private CronType _cron;
    private Runnable _work;
    private WorkManager _workManager;
    private Alarm _alarm;
    private volatile boolean _isActive;
    private static Class _resin_compat_class_0;

    public void setCron(CronType cron) {
        this._cron = cron;
    }

    public void setWork(Runnable work) {
        this._work = work;
    }

    public void init() throws ConfigException {
        if (this._cron == null) {
            throw new ConfigException(L.l("CronResource needs a <cron> interval."));
        }
        if (this._work == null) {
            throw new ConfigException(L.l("CronResource needs a <work> task."));
        }
    }

    public void start(BootstrapContext ctx) {
        this._workManager = ctx.getWorkManager();
        long now = Alarm.getCurrentTime();
        long nextTime = this._cron.nextTime(now);
        this._isActive = true;
        this._alarm = new Alarm("cron-resource", (AlarmListener)this, nextTime - now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAlarm(Alarm alarm) {
        if (!this._isActive) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._loader);
            log.fine(new CharBuffer().append("cron work scheduled: ").append(this._work).toString());
            if (this._work instanceof Work) {
                this._workManager.scheduleWork((Work)this._work);
            } else {
                ThreadPool.schedule(this._work);
            }
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
        long now = Alarm.getCurrentTime();
        long nextTime = this._cron.nextTime(now);
        this._alarm.queue(nextTime - now);
    }

    public void stop() {
        this._isActive = false;
        this._alarm.dequeue();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.resources.CronResource");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

