/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.relaxng.program;

import com.caucho.relaxng.RelaxException;
import com.caucho.relaxng.program.ChoiceItem;
import com.caucho.relaxng.program.EmptyItem;
import com.caucho.relaxng.program.Item;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.xml.QName;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterleaveItem
extends Item {
    protected static final L10N L = new L10N(InterleaveItem._resin_compat_class_0());
    private ArrayList<Item> _items = new ArrayList();
    private static Class _resin_compat_class_0;

    public static Item create(Item left, Item right) {
        InterleaveItem item = new InterleaveItem();
        item.addItem(left);
        item.addItem(right);
        return item.getMin();
    }

    public void addItem(Item item) {
        if (item == null) {
            return;
        }
        if (item instanceof EmptyItem) {
            return;
        }
        if (item instanceof InterleaveItem) {
            InterleaveItem interleave = (InterleaveItem)item;
            for (int i = 0; i < interleave._items.size(); ++i) {
                this.addItem(interleave._items.get(i));
            }
            return;
        }
        this._items.add(item);
    }

    public Item getMin() {
        if (this._items.size() == 0) {
            return null;
        }
        if (this._items.size() == 1) {
            return this._items.get(0);
        }
        return this;
    }

    @Override
    public void firstSet(HashSet<QName> set) {
        for (int i = 0; i < this._items.size(); ++i) {
            this._items.get(i).firstSet(set);
        }
    }

    @Override
    public void requiredFirstSet(HashSet<QName> set) {
        if (this.allowEmpty()) {
            return;
        }
        for (int i = 0; i < this._items.size(); ++i) {
            this._items.get(i).requiredFirstSet(set);
        }
    }

    @Override
    public boolean allowEmpty() {
        for (int i = 0; i < this._items.size(); ++i) {
            if (this._items.get(i).allowEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Item interleaveContinuation(Item cont) {
        InterleaveItem item = new InterleaveItem();
        for (int i = 0; i < this._items.size(); ++i) {
            item.addItem(this._items.get(i).interleaveContinuation(cont));
        }
        return item.getMin();
    }

    @Override
    public Item inElementContinuation(Item cont) {
        InterleaveItem item = new InterleaveItem();
        for (int i = 0; i < this._items.size(); ++i) {
            item.addItem(this._items.get(i).inElementContinuation(cont));
        }
        return item.getMin();
    }

    @Override
    public Item groupContinuation(Item cont) {
        InterleaveItem item = new InterleaveItem();
        for (int i = 0; i < this._items.size(); ++i) {
            item.addItem(this._items.get(i).groupContinuation(cont));
        }
        return item.getMin();
    }

    @Override
    public Iterator<Item> getItemsIterator() {
        if (this._items.size() == 0) {
            return this.emptyItemIterator();
        }
        return this._items.iterator();
    }

    @Override
    public Item startElement(QName name) throws RelaxException {
        InterleaveItem result = null;
        ChoiceItem choice = null;
        for (int i = 0; i < this._items.size(); ++i) {
            Item resultItem;
            Item item = this._items.get(i);
            Item nextItem = item.startElement(name);
            if (nextItem == null) continue;
            if (nextItem == item) {
                resultItem = this;
            } else {
                InterleaveItem rest = new InterleaveItem();
                for (int j = 0; j < this._items.size(); ++j) {
                    if (i == j) continue;
                    rest.addItem(this._items.get(j));
                }
                resultItem = nextItem.interleaveContinuation(rest);
            }
            if (result == null) {
                result = resultItem;
                continue;
            }
            if (choice == null) {
                choice = new ChoiceItem();
                choice.addItem(result);
            }
            choice.addItem(resultItem);
        }
        if (choice != null) {
            return choice.getMin();
        }
        return result;
    }

    @Override
    public boolean allowAttribute(QName name, String value) throws RelaxException {
        for (int i = this._items.size() - 1; i >= 0; --i) {
            if (!this._items.get(i).allowAttribute(name, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void attributeSet(HashSet<QName> set) {
        for (int i = 0; i < this._items.size(); ++i) {
            this._items.get(i).attributeSet(set);
        }
    }

    @Override
    public Item setAttribute(QName name, String value) throws RelaxException {
        if (!this.allowAttribute(name, value)) {
            return this;
        }
        InterleaveItem interleave = new InterleaveItem();
        for (int i = this._items.size() - 1; i >= 0; --i) {
            Item next = this._items.get(i).setAttribute(name, value);
            if (next == null) continue;
            interleave.addItem(next);
        }
        return interleave.getMin();
    }

    @Override
    public Item attributeEnd() {
        InterleaveItem interleave = new InterleaveItem();
        for (int i = this._items.size() - 1; i >= 0; --i) {
            Item next = this._items.get(i).attributeEnd();
            if (next == null) {
                return null;
            }
            interleave.addItem(next);
        }
        if (interleave.equals(this)) {
            return this;
        }
        return interleave.getMin();
    }

    @Override
    public Item text(String string) throws RelaxException {
        InterleaveItem result = null;
        ChoiceItem choice = null;
        for (int i = 0; i < this._items.size(); ++i) {
            Item resultItem;
            Item item = this._items.get(i);
            Item nextItem = item.text(string);
            if (nextItem == null) continue;
            if (nextItem == item) {
                resultItem = this;
            } else {
                InterleaveItem rest = new InterleaveItem();
                for (int j = 0; j < this._items.size(); ++j) {
                    if (i == j) continue;
                    rest.addItem(this._items.get(j));
                }
                resultItem = nextItem.interleaveContinuation(rest);
            }
            if (result == null) {
                result = resultItem;
                continue;
            }
            if (choice == null) {
                choice = new ChoiceItem();
                choice.addItem(result);
            }
            choice.addItem(resultItem);
        }
        if (choice != null) {
            return choice.getMin();
        }
        return result;
    }

    @Override
    public boolean allowsElement(QName name) {
        for (int i = 0; i < this._items.size(); ++i) {
            Item subItem = this._items.get(i);
            if (!subItem.allowsElement(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toSyntaxDescription(int depth) {
        if (this._items.size() == 1) {
            return this._items.get(0).toSyntaxDescription(depth);
        }
        CharBuffer cb = CharBuffer.allocate();
        cb.append("(");
        boolean isSimple = true;
        for (int i = 0; i < this._items.size(); ++i) {
            Item item = this._items.get(i);
            if (!item.isSimpleSyntax()) {
                isSimple = false;
            }
            if (i == 0) {
                if (!isSimple) {
                    cb.append(" ");
                }
            } else if (isSimple) {
                cb.append(" & ");
            } else {
                this.addSyntaxNewline(cb, depth);
                cb.append("& ");
            }
            cb.append(item.toSyntaxDescription(depth + 2));
        }
        cb.append(')');
        return cb.close();
    }

    public int hashCode() {
        int hash = 37;
        for (int i = 0; i < this._items.size(); ++i) {
            hash += this._items.get(i).hashCode();
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InterleaveItem)) {
            return false;
        }
        InterleaveItem interleave = (InterleaveItem)o;
        return this.isSubset(interleave) && interleave.isSubset(this);
    }

    private boolean isSubset(InterleaveItem item) {
        if (this._items.size() != item._items.size()) {
            return false;
        }
        for (int i = 0; i < this._items.size(); ++i) {
            Item subItem = this._items.get(i);
            if (item._items.contains(subItem)) continue;
            return false;
        }
        return true;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.relaxng.program.InterleaveItem");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

