/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.portal.generic;

import com.caucho.portal.generic.Action;
import com.caucho.portal.generic.Constraint;
import com.caucho.portal.generic.InvocationFactory;
import com.caucho.portal.generic.Portal;
import com.caucho.portal.generic.Render;
import com.caucho.portal.generic.Window;
import com.caucho.portal.generic.context.ConnectionContext;
import com.caucho.util.CharBuffer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletSession;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PortletConnection {
    public static final String PORTLET_CONNECTION = "com.caucho.portal.generic.PortletConnection";
    public static final Logger log = Logger.getLogger(PortletConnection._resin_compat_class_0().getName());
    private static int _connectionCount = 10;
    private ConnectionContext _context;
    private String _connectionId;
    private Portal _portal;
    private boolean _connectionFailed;
    private Exception _connectionFailedCause;
    private static Class _resin_compat_class_0;

    public static PortletConnection getConnection(PortletRequest portletRequest) {
        return (PortletConnection)portletRequest.getAttribute(PORTLET_CONNECTION);
    }

    public static Portal getPortal(PortletRequest portletRequest) {
        PortletConnection connection = PortletConnection.getConnection(portletRequest);
        if (connection == null) {
            return null;
        }
        return connection.getPortal();
    }

    public static Action getAction(PortletRequest portletRequest) {
        PortletConnection connection = PortletConnection.getConnection(portletRequest);
        if (connection == null) {
            return null;
        }
        return connection.getCurrentAction();
    }

    public static Render getRender(PortletRequest portletRequest) {
        PortletConnection connection = PortletConnection.getConnection(portletRequest);
        if (connection == null) {
            return null;
        }
        return connection.getCurrentRender();
    }

    protected PortletConnection() {
        int id = _connectionCount++;
        this._connectionId = Integer.toString(id, 36);
        this._context = new ConnectionContext(this);
    }

    public String getId() {
        return this._connectionId;
    }

    public void start(Portal portal, InvocationFactory invocationFactory) {
        if (this._portal != null) {
            throw new IllegalStateException("missing finish()?");
        }
        this._portal = portal;
        this._context.start(invocationFactory);
    }

    public void finish() {
        this._context.finish();
        this._portal = null;
        this._connectionFailedCause = null;
        this._connectionFailed = false;
    }

    public Portal getPortal() {
        return this._portal;
    }

    public void setConnectionFailed() {
        if (!this._connectionFailed) {
            PortletException ex = new PortletException("connection failed");
            this.setConnectionFailed((Exception)((Object)ex));
        }
    }

    public void setConnectionFailed(Exception ex) {
        if (!this._connectionFailed) {
            this._connectionFailed = true;
            this._connectionFailedCause = ex;
            log.log(Level.FINE, ex.toString(), ex);
        }
    }

    public boolean isConnectionFailed() {
        return this._connectionFailed;
    }

    public abstract boolean handleConstraintFailure(Constraint var1, int var2) throws IOException;

    public abstract boolean handleException(Exception var1);

    public abstract boolean canGuaranteeIntegrity();

    public abstract boolean canGuaranteeConfidentiality();

    public abstract void setAttribute(String var1, Object var2);

    public abstract Object getAttribute(String var1);

    public abstract void removeAttribute(String var1);

    public abstract Enumeration getAttributeNames();

    public abstract PortletSession getPortletSession(boolean var1);

    public abstract String getScheme();

    public abstract String getServerName();

    public abstract int getServerPort();

    public abstract String getContextPath();

    public abstract String getAuthType();

    public abstract boolean isSecure();

    public abstract String getRequestedSessionId();

    public abstract boolean isRequestedSessionIdValid();

    public abstract String getRemoteUser();

    public abstract Principal getUserPrincipal();

    public abstract boolean isUserInRole(String var1);

    public abstract String getProperty(String var1);

    public abstract Enumeration getProperties(String var1);

    public abstract Enumeration getPropertyNames();

    public abstract Set<String> getClientContentTypes();

    public abstract Set<Locale> getClientLocales();

    public abstract Set<String> getClientCharacterEncodings();

    public abstract String getSubmitContentType();

    public abstract int getSubmitContentLength();

    public abstract InputStream getSubmitInputStream() throws IOException, IllegalStateException;

    public abstract void setSubmitCharacterEncoding(String var1) throws UnsupportedEncodingException, IllegalStateException;

    public abstract String getSubmitCharacterEncoding();

    public abstract BufferedReader getSubmitReader() throws UnsupportedEncodingException, IOException;

    public abstract String encodeURL(String var1);

    public abstract String resolveURL(String var1);

    public abstract String resolveURL(String var1, boolean var2) throws PortletSecurityException;

    public abstract void sendRedirect(String var1) throws IllegalStateException, IOException;

    public abstract void setProperty(String var1, String var2);

    public abstract void addProperty(String var1, String var2);

    public abstract void setContentType(String var1);

    public abstract String getContentType();

    public abstract void setLocale(Locale var1);

    public abstract Locale getLocale();

    public abstract void setBufferSize(int var1);

    public abstract int getBufferSize();

    public abstract void flushBuffer() throws IOException;

    public abstract void resetBuffer();

    public abstract void reset();

    public abstract boolean isCommitted();

    public abstract OutputStream getOutputStream() throws IOException;

    public abstract String getCharacterEncoding();

    public abstract void setCharacterEncoding(String var1) throws UnsupportedEncodingException;

    public abstract PrintWriter getWriter() throws IOException;

    public Action getAction(Window window, String namespace) throws PortletException, IOException {
        return this._context.getAction(window, namespace);
    }

    public Action getCurrentAction() {
        return this._context.getCurrentAction();
    }

    public Render getRender(Window window, String namespace) throws PortletException, IOException {
        return this._context.getRender(window, namespace);
    }

    public Render getCurrentRender() {
        return this._context.getCurrentRender();
    }

    public void checkForFailure() throws PortletException {
        if (this._connectionFailed) {
            if (this._connectionFailedCause == null) {
                throw new PortletException("connection failed");
            }
            throw new PortletException(new CharBuffer().append("connection failed: ").append(this._connectionFailedCause.toString()).toString(), (Throwable)this._connectionFailedCause);
        }
    }

    protected boolean isPrivate() {
        return this._context.isConnectionPrivate();
    }

    protected int getExpirationCache() {
        return this._context.getConnectionExpirationCache();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName(PORTLET_CONNECTION);
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

