/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.portal.generic;

import com.caucho.portal.generic.HttpUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class HttpPortletRequestDispatcher
implements PortletRequestDispatcher {
    protected static final Logger log = Logger.getLogger(HttpPortletRequestDispatcher._resin_compat_class_0().getName());
    public static final String HTTP_SERVLET_REQUEST = "com.caucho.portal.generic.HttpServletRequest";
    public static final String HTTP_SERVLET_RESPONSE = "com.caucho.portal.generic.HttpServletResponse";
    private RequestDispatcher _dispatcher;
    private Map<String, String[]> _parameterMap;
    private HttpPortletRequestWrapper _wrappedRequest = new HttpPortletRequestWrapper();
    private HttpPortletResponseWrapper _wrappedResponse = new HttpPortletResponseWrapper();
    private static Class _resin_compat_class_0;

    public boolean startWithPath(ServletContext servletContext, String path) {
        this._dispatcher = servletContext.getRequestDispatcher(path);
        if (this._dispatcher == null) {
            return false;
        }
        int paramIndex = path.indexOf(63);
        if (paramIndex != -1) {
            HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
            path = HttpUtil.extractParameters(parameterMap, path, paramIndex);
            this._parameterMap = parameterMap;
        }
        return true;
    }

    public boolean startWithName(ServletContext servletContext, String name) {
        this._dispatcher = servletContext.getNamedDispatcher(name);
        return this._dispatcher != null;
    }

    public void finish() {
        this._dispatcher = null;
        this._parameterMap = null;
    }

    public void include(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        HttpServletRequest httpRequest = (HttpServletRequest)renderRequest.getAttribute(HTTP_SERVLET_REQUEST);
        if (httpRequest == null) {
            throw new PortletException("HttpServletRequest not found in request attribute com.caucho.portal.generic.HttpServletRequest");
        }
        HttpServletResponse httpResponse = (HttpServletResponse)renderRequest.getAttribute(HTTP_SERVLET_RESPONSE);
        if (httpResponse == null) {
            throw new PortletException("HttpServletResponse not found in request attribute com.caucho.portal.generic.HttpServletResponse");
        }
        this._wrappedRequest.start(httpRequest, renderRequest, this._parameterMap);
        this._wrappedResponse.start(httpResponse, renderResponse);
        try {
            this._dispatcher.include((ServletRequest)this._wrappedRequest, (ServletResponse)this._wrappedResponse);
        }
        catch (ServletException ex) {
            throw new PortletException((Throwable)ex);
        }
        finally {
            this._wrappedResponse.finish();
            this._wrappedRequest.finish();
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.portal.generic.HttpPortletRequestDispatcher");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    protected static final class ServletOutputStreamWrapper
    extends ServletOutputStream {
        private OutputStream _out;

        public ServletOutputStreamWrapper(OutputStream out) {
            this._out = out;
        }

        public void write(int b) throws IOException {
            this._out.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this._out.write(b, off, len);
        }

        public void write(byte[] b) throws IOException {
            this._out.write(b);
        }

        public void flush() throws IOException {
            this._out.flush();
        }

        public void close() throws IOException {
            this._out.close();
        }
    }

    protected static class HttpPortletResponseWrapper
    implements HttpServletResponse {
        private HttpServletResponse _httpResponse;
        private RenderResponse _renderResponse;
        private ServletOutputStreamWrapper _servletOutputStream;

        public void start(HttpServletResponse httpResponse, RenderResponse renderResponse) {
            this._httpResponse = httpResponse;
            this._renderResponse = renderResponse;
        }

        public void finish() {
            this._servletOutputStream = null;
            this._renderResponse = null;
            this._httpResponse = null;
        }

        public void setBufferSize(int size) {
            this._renderResponse.setBufferSize(size);
        }

        public int getBufferSize() {
            return this._renderResponse.getBufferSize();
        }

        public void flushBuffer() throws IOException {
            this._renderResponse.flushBuffer();
        }

        public void resetBuffer() {
            this._renderResponse.resetBuffer();
        }

        public void reset() {
            this._renderResponse.reset();
        }

        public boolean isCommitted() {
            return this._renderResponse.isCommitted();
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this._servletOutputStream == null) {
                OutputStream portletOutputStream = this._renderResponse.getPortletOutputStream();
                this._servletOutputStream = new ServletOutputStreamWrapper(portletOutputStream);
            }
            return this._servletOutputStream;
        }

        public String getCharacterEncoding() {
            return this._renderResponse.getCharacterEncoding();
        }

        public String getContentType() {
            return this._renderResponse.getContentType();
        }

        public void setCharacterEncoding(String enc) {
        }

        public PrintWriter getWriter() throws IOException {
            return this._renderResponse.getWriter();
        }

        public String encodeURL(String path) {
            return this._renderResponse.encodeURL(path);
        }

        public String encodeUrl(String path) {
            return this._renderResponse.encodeURL(path);
        }

        public Locale getLocale() {
            return this._renderResponse.getLocale();
        }

        public String encodeRedirectURL(String url) {
            return null;
        }

        public String encodeRedirectUrl(String url) {
            return null;
        }

        public void setContentType(String type) {
        }

        public void setContentLength(int len) {
        }

        public void setLocale(Locale locale) {
        }

        public void addCookie(Cookie cookie) {
        }

        public void sendError(int sc) throws IOException {
        }

        public void sendError(int sc, String msg) throws IOException {
        }

        public void sendRedirect(String location) throws IOException {
        }

        public void setDateHeader(String name, long date) {
        }

        public void addDateHeader(String name, long date) {
        }

        public void setHeader(String name, String value) {
        }

        public void addHeader(String name, String value) {
        }

        public void setIntHeader(String name, int value) {
        }

        public void addIntHeader(String name, int value) {
        }

        public boolean containsHeader(String name) {
            return false;
        }

        public void setStatus(int sc) {
        }

        public void setStatus(int sc, String msg) {
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class HttpPortletRequestWrapper
    implements HttpServletRequest {
        private RenderRequest _renderRequest;
        private HttpServletRequest _httpRequest;
        private Map<String, String[]> _parameterMap;
        private Map<String, String[]> _fullParameterMap;

        public void start(HttpServletRequest httpRequest, RenderRequest renderRequest, Map<String, String[]> parameterMap) {
            this._httpRequest = httpRequest;
            this._renderRequest = renderRequest;
            this._parameterMap = parameterMap;
        }

        public void finish() {
            this._renderRequest = null;
            this._httpRequest = null;
            this._parameterMap = null;
            this._fullParameterMap = null;
        }

        public String getParameter(String name) {
            String[] values = this.getParameterValues(name);
            return values == null || values.length == 0 ? null : values[0];
        }

        public String[] getParameterValues(String name) {
            if (this._fullParameterMap != null) {
                return this._fullParameterMap.get(name);
            }
            String[] values = null;
            if (this._parameterMap != null) {
                values = this._parameterMap.get(name);
            }
            if (values == null) {
                values = this._renderRequest.getParameterValues(name);
            }
            return values;
        }

        public Map getParameterMap() {
            if (this._fullParameterMap != null) {
                return this._fullParameterMap;
            }
            if (this._parameterMap == null) {
                this._fullParameterMap = this._renderRequest.getParameterMap();
            } else {
                this._fullParameterMap = new HashMap<String, String[]>();
                this._fullParameterMap.putAll(this._renderRequest.getParameterMap());
                this._fullParameterMap.putAll(this._parameterMap);
            }
            return this._fullParameterMap;
        }

        public Enumeration getParameterNames() {
            return Collections.enumeration(this.getParameterMap().keySet());
        }

        public String getScheme() {
            return this._renderRequest.getScheme();
        }

        public String getServerName() {
            return this._renderRequest.getServerName();
        }

        public int getServerPort() {
            return this._renderRequest.getServerPort();
        }

        public Object getAttribute(String name) {
            return this._renderRequest.getAttribute(name);
        }

        public void setAttribute(String name, Object o) {
            this._renderRequest.setAttribute(name, o);
        }

        public Enumeration getAttributeNames() {
            return this._renderRequest.getAttributeNames();
        }

        public void removeAttribute(String name) {
            this._renderRequest.removeAttribute(name);
        }

        public Locale getLocale() {
            return this._renderRequest.getLocale();
        }

        public Enumeration getLocales() {
            return this._renderRequest.getLocales();
        }

        public boolean isSecure() {
            return this._renderRequest.isSecure();
        }

        public String getAuthType() {
            return this._renderRequest.getAuthType();
        }

        public String getRequestedSessionId() {
            return this._renderRequest.getRequestedSessionId();
        }

        public boolean isRequestedSessionIdValid() {
            return this._renderRequest.isRequestedSessionIdValid();
        }

        public String getRemoteUser() {
            return this._renderRequest.getRemoteUser();
        }

        public boolean isUserInRole(String role) {
            return this._renderRequest.isUserInRole(role);
        }

        public Principal getUserPrincipal() {
            return this._renderRequest.getUserPrincipal();
        }

        public String getHeader(String name) {
            return this._httpRequest.getHeader(name);
        }

        public Enumeration getHeaders(String name) {
            return this._httpRequest.getHeaders(name);
        }

        public Enumeration getHeaderNames() {
            return this._httpRequest.getHeaderNames();
        }

        public int getIntHeader(String name) {
            return this._httpRequest.getIntHeader(name);
        }

        public long getDateHeader(String name) {
            return this._httpRequest.getDateHeader(name);
        }

        public Cookie[] getCookies() {
            return this._httpRequest.getCookies();
        }

        public String getProtocol() {
            return null;
        }

        public String getRealPath(String uri) {
            return null;
        }

        public StringBuffer getRequestURL() {
            return null;
        }

        public String getRemoteAddr() {
            return null;
        }

        public String getRemoteHost() {
            return null;
        }

        public String getCharacterEncoding() {
            return null;
        }

        public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        }

        public ServletInputStream getInputStream() throws IOException {
            return null;
        }

        public BufferedReader getReader() throws IOException, IllegalStateException {
            return null;
        }

        public int getContentLength() {
            return 0;
        }

        public String getMethod() {
            return "GET";
        }

        public int getRemotePort() {
            return this._httpRequest.getRemotePort();
        }

        public String getLocalAddr() {
            return this._httpRequest.getLocalAddr();
        }

        public String getLocalName() {
            return this._httpRequest.getLocalName();
        }

        public int getLocalPort() {
            return this._httpRequest.getLocalPort();
        }

        public String getContentType() {
            return this._httpRequest.getContentType();
        }

        public RequestDispatcher getRequestDispatcher(String uri) {
            return this._httpRequest.getRequestDispatcher(uri);
        }

        public String getRequestURI() {
            return this._httpRequest.getRequestURI();
        }

        public String getContextPath() {
            return this._httpRequest.getContextPath();
        }

        public String getServletPath() {
            return this._httpRequest.getServletPath();
        }

        public String getPathInfo() {
            return this._httpRequest.getPathInfo();
        }

        public String getPathTranslated() {
            return this._httpRequest.getPathTranslated();
        }

        public String getQueryString() {
            return this._httpRequest.getQueryString();
        }

        public HttpSession getSession(boolean create) {
            return this._httpRequest.getSession(create);
        }

        public HttpSession getSession() {
            return this.getSession(true);
        }

        public boolean isRequestedSessionIdFromCookie() {
            return this._httpRequest.isRequestedSessionIdFromCookie();
        }

        public boolean isRequestedSessionIdFromURL() {
            return this._httpRequest.isRequestedSessionIdFromURL();
        }

        public boolean isRequestedSessionIdFromUrl() {
            return this._httpRequest.isRequestedSessionIdFromUrl();
        }
    }
}

