/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.portal.generic;

import com.caucho.portal.generic.Action;
import com.caucho.portal.generic.GenericWindow;
import com.caucho.portal.generic.PortletConnection;
import com.caucho.portal.generic.Render;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;

public class GenericPortletWindow
extends GenericWindow {
    protected static final Logger log = Logger.getLogger(GenericPortletWindow._resin_compat_class_1().getName());
    private Portlet _portlet;
    private boolean _isPortletNameSet;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    public void setPortlet(Portlet portlet) {
        if (this._portlet != null) {
            throw new IllegalArgumentException("`portlet' is already set");
        }
        this._portlet = portlet;
    }

    public void setPortletClass(String className) {
        this.setPortlet((Portlet)this.newInstance(GenericPortletWindow._resin_compat_class_0(), className));
    }

    public void setPortletName(String portletName) {
        super.setPortletName(portletName);
        this._isPortletNameSet = true;
    }

    public void init(PortletContext portletContext) throws PortletException {
        super.init(portletContext);
        if (this._portlet == null) {
            throw new PortletException("`portlet' is required");
        }
        if (!this._isPortletNameSet) {
            this.setPortletName(this._portlet.getClass().getName());
        }
        this._portlet.init((PortletConfig)this);
    }

    protected Portlet getPortlet() {
        if (this._portlet == null) {
            throw new IllegalStateException("missing init()?");
        }
        return this._portlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAction(PortletConnection connection) throws PortletException, IOException {
        Action action = connection.getAction(this, this.getNamespace());
        if (action != null) {
            try {
                if (action.isTarget()) {
                    action.processAction(this.getPortlet());
                }
            }
            finally {
                action.finish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(PortletConnection connection) throws PortletException, IOException {
        Render render = connection.getRender(this, this.getNamespace());
        if (render != null) {
            try {
                render.render(this.getPortlet());
            }
            finally {
                render.finish();
            }
        }
    }

    public void destroy() {
        Portlet portlet = this._portlet;
        this._portlet = null;
        try {
            if (portlet != null) {
                portlet.destroy();
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, ex.toString(), ex);
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("javax.portlet.Portlet");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.portal.generic.GenericPortletWindow");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

