/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.portal.generic;

import com.caucho.portal.generic.GenericLayoutWindow;
import com.caucho.portal.generic.GenericPortal;
import com.caucho.portal.generic.HttpPortletConnection;
import com.caucho.portal.generic.HttpPortletContext;
import com.caucho.portal.generic.Portal;
import com.caucho.portal.generic.PortletConnection;
import com.caucho.util.CharBuffer;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.logging.Logger;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GenericPortalServlet
extends HttpServlet {
    protected static final Logger log = Logger.getLogger(GenericPortalServlet._resin_compat_class_2().getName());
    private Portal _portal;
    private HttpPortletContext _portletContext;
    private GenericLayoutWindow _layout;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;
    private static Class _resin_compat_class_2;

    public void setPortal(Portal portal) {
        if (this._portal != null) {
            throw new IllegalArgumentException("`portal' already set");
        }
        this._portal = portal;
    }

    public void setPortalClass(String className) {
        this.setPortal((Portal)this.newInstance(GenericPortalServlet._resin_compat_class_0(), className));
    }

    public void setLayout(GenericLayoutWindow layout) {
        if (this._layout != null) {
            throw new IllegalArgumentException("`layout' is already set");
        }
        this._layout = layout;
    }

    public void setLayoutClass(String className) {
        this.setLayout((GenericLayoutWindow)this.newInstance(GenericPortalServlet._resin_compat_class_1(), className));
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        String p = super.getInitParameter("portal-class");
        if (p != null) {
            this.setPortalClass(p);
        }
        if (this._portal == null) {
            this._portal = new GenericPortal();
        }
        if ((p = super.getInitParameter("layout-class")) != null) {
            this.setLayoutClass(p);
        }
        if (this._layout == null) {
            throw new ServletException("`layout' is required");
        }
        this._portletContext = new HttpPortletContext(this.getServletContext());
        try {
            this._layout.init(this._portletContext);
        }
        catch (PortletException ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    protected Object newInstance(Class targetClass, String className) throws IllegalArgumentException {
        Class<?> cl = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            cl = Class.forName(className, false, loader);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (cl == null) {
            throw new IllegalArgumentException(new CharBuffer().append("`").append(className).append("' is not a known class").toString());
        }
        if (!targetClass.isAssignableFrom(cl)) {
            throw new IllegalArgumentException(new CharBuffer().append("'").append(className).append("' must implement ").append(targetClass.getName()).toString());
        }
        if (Modifier.isAbstract(cl.getModifiers())) {
            throw new IllegalArgumentException(new CharBuffer().append("'").append(className).append("' must not be abstract.").toString());
        }
        if (!Modifier.isPublic(cl.getModifiers())) {
            throw new IllegalArgumentException(new CharBuffer().append("'").append(className).append("' must be public.").toString());
        }
        Constructor<?>[] constructors = cl.getDeclaredConstructors();
        Constructor<?> zeroArg = null;
        for (int i = 0; i < constructors.length; ++i) {
            if (constructors[i].getParameterTypes().length != 0) continue;
            zeroArg = constructors[i];
            break;
        }
        if (zeroArg == null || !Modifier.isPublic(zeroArg.getModifiers())) {
            throw new IllegalArgumentException(new CharBuffer().append("'").append(className).append("' must have a public zero arg constructor").toString());
        }
        Object obj = null;
        try {
            obj = cl.newInstance();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(new CharBuffer().append("error instantiating `").append(className).append("': ").append(ex.toString()).toString(), ex);
        }
        return obj;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doRequest(req, res);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doRequest(req, res);
    }

    protected void doRequest(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        HttpPortletConnection connection = new HttpPortletConnection();
        connection.start(this._portal, (PortletContext)this._portletContext, httpRequest, httpResponse, true);
        try {
            this._layout.processAction(connection);
            this._layout.render(connection);
            connection.checkForFailure();
        }
        catch (PortletException ex) {
            throw new ServletException((Throwable)ex);
        }
        finally {
            connection.finish();
        }
    }

    protected void doRequest(PortletConnection connection) throws PortletException, IOException {
    }

    public void destroy() {
        if (this._layout != null) {
            this._layout.destroy();
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.portal.generic.Portal");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.portal.generic.GenericLayoutWindow");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_2() {
        try {
            Class<?> clazz = _resin_compat_class_2;
            if (clazz == null) {
                clazz = _resin_compat_class_2 = Class.forName("com.caucho.portal.generic.GenericPortalServlet");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

