/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.portal.generic;

import com.caucho.portal.generic.BufferFactory;
import com.caucho.portal.generic.PortletByteBuffer;
import com.caucho.portal.generic.PortletCharBuffer;
import com.caucho.util.CharBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BufferFactoryImpl
implements BufferFactory {
    protected static final Logger log = Logger.getLogger(BufferFactoryImpl._resin_compat_class_0().getName());
    private static int _bufferCount = 10;
    private int _bufferSize = 8192;
    private int _poolSize = 32;
    FreeList<CharBufferImpl> _charBufferFreeList = new FreeList(this._poolSize);
    FreeList<ByteBufferImpl> _byteBufferFreeList = new FreeList(this._poolSize);
    private static Class _resin_compat_class_0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBufferSize(int bufferSize) {
        FreeList<ByteBufferImpl> freeList = this._byteBufferFreeList;
        synchronized (freeList) {
            FreeList<CharBufferImpl> freeList2 = this._charBufferFreeList;
            synchronized (freeList2) {
                this._byteBufferFreeList.clear();
                this._charBufferFreeList.clear();
                this._bufferSize = bufferSize;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPoolSize(int poolSize) {
        FreeList<ByteBufferImpl> freeList = this._byteBufferFreeList;
        synchronized (freeList) {
            FreeList<CharBufferImpl> freeList2 = this._charBufferFreeList;
            synchronized (freeList2) {
                this._poolSize = poolSize;
                this._byteBufferFreeList.ensureCapacity(poolSize);
                this._charBufferFreeList.ensureCapacity(poolSize);
            }
        }
    }

    public int getDefaultBufferSize() {
        return this._bufferSize;
    }

    public PortletCharBuffer allocateCharBuffer(int capacity) {
        CharBufferImpl b = null;
        if (capacity == Integer.MAX_VALUE) {
            capacity = this._bufferSize;
        } else if (capacity < this._bufferSize) {
            capacity = this._bufferSize;
        }
        if (capacity == this._bufferSize) {
            b = this._charBufferFreeList.allocate();
        }
        if (b == null) {
            b = new CharBufferImpl(capacity);
            if (log.isLoggable(Level.FINEST)) {
                b.log(new CharBuffer().append("allocated new with capacity ").append(capacity).toString());
            }
        } else if (log.isLoggable(Level.FINEST)) {
            b.log(new CharBuffer().append("allocated reused with capacity ").append(b.getCapacity()).toString());
        }
        return b;
    }

    public PortletByteBuffer allocateByteBuffer(int capacity) {
        ByteBufferImpl b = null;
        if (capacity == Integer.MAX_VALUE) {
            capacity = this._bufferSize;
        } else if (capacity <= this._bufferSize) {
            capacity = this._bufferSize;
        }
        b = this._byteBufferFreeList.allocate();
        if (b == null) {
            b = new ByteBufferImpl(capacity);
            if (log.isLoggable(Level.FINEST)) {
                b.log(new CharBuffer().append("allocated new with capacity ").append(capacity).toString());
            }
        } else if (log.isLoggable(Level.FINEST)) {
            b.log(new CharBuffer().append("allocated reused with capacity ").append(b.getCapacity()).toString());
        }
        return b;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.portal.generic.BufferFactoryImpl");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FreeList<E> {
        private int _freeListSize;
        private ArrayList<E> _freeList;
        private long _lastAllocateFail;

        public FreeList(int initialCapacity) {
            this._freeListSize = initialCapacity;
            this._freeList = new ArrayList(this._freeListSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E allocate() {
            ArrayList<E> arrayList = this._freeList;
            synchronized (arrayList) {
                int size = this._freeList.size();
                if (size > 0) {
                    return this._freeList.remove(--size);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean free(E obj) {
            ArrayList<E> arrayList = this._freeList;
            synchronized (arrayList) {
                int size = this._freeList.size();
                if (size < this._freeListSize) {
                    this._freeList.add(obj);
                    return true;
                }
                if (log.isLoggable(Level.CONFIG)) {
                    log.config("buffer pool overrun, consider increasing buffer-factory pool-size");
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            ArrayList<E> arrayList = this._freeList;
            synchronized (arrayList) {
                this._freeList.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void ensureCapacity(int capacity) {
            ArrayList<E> arrayList = this._freeList;
            synchronized (arrayList) {
                this._freeList.ensureCapacity(capacity);
            }
        }
    }

    private class ByteBufferImpl
    implements PortletByteBuffer {
        private String _bufferId;
        private int _bufferSize;
        private byte[] _buf;
        private int _bufferPos = 0;

        public ByteBufferImpl(int size) {
            int id = _bufferCount++;
            this._bufferId = Integer.toString(id, 36);
            this._bufferSize = size;
            this._buf = new byte[size];
        }

        void log(String message) {
            if (log.isLoggable(Level.FINEST)) {
                message = new StringBuffer(256).append("byte buffer ").append(this._bufferId).append(' ').append(message).toString();
                log.log(Level.FINEST, message);
            }
        }

        public boolean write(byte[] buf, int off, int len) {
            if (len > this._bufferSize - this._bufferPos) {
                return this.overrun();
            }
            System.arraycopy(buf, off, this._buf, this._bufferPos, len);
            this._bufferPos += len;
            return true;
        }

        public boolean write(int b) {
            if (this._bufferPos == this._bufferSize) {
                return this.overrun();
            }
            this._buf[this._bufferPos++] = (byte)b;
            return true;
        }

        public int size() {
            return this._bufferPos;
        }

        public int getCapacity() {
            return this._bufferSize;
        }

        private boolean overrun() {
            this.log("overrun");
            return false;
        }

        public void flush(OutputStream out) throws IOException {
            if (this._bufferPos != 0) {
                this.log("flush");
                out.write(this._buf, 0, this._bufferPos);
                this._bufferPos = 0;
            }
        }

        public void reset() {
            this.log("reset");
            this._bufferPos = 0;
        }

        public void finish() {
            this._bufferPos = 0;
            this.log("finish");
            if (this._bufferSize <= BufferFactoryImpl.this._bufferSize) {
                if (!BufferFactoryImpl.this._byteBufferFreeList.free(this)) {
                    this._buf = null;
                }
            } else {
                this._buf = null;
            }
        }
    }

    private class CharBufferImpl
    implements PortletCharBuffer {
        private String _bufferId;
        private int _bufferSize;
        private char[] _buf;
        private int _bufferPos = 0;

        public CharBufferImpl(int size) {
            int id = _bufferCount++;
            this._bufferId = Integer.toString(id, 36);
            this._bufferSize = size;
            this._buf = new char[size];
        }

        void log(String message) {
            if (log.isLoggable(Level.FINEST)) {
                message = new StringBuffer(256).append("char buffer ").append(this._bufferId).append(' ').append(message).toString();
                log.log(Level.FINEST, message);
            }
        }

        public boolean print(char[] buf, int off, int len) {
            if (len > this._bufferSize - this._bufferPos) {
                return this.overrun();
            }
            System.arraycopy(buf, off, this._buf, this._bufferPos, len);
            this._bufferPos += len;
            return true;
        }

        public boolean print(String str, int off, int len) {
            if (len > this._bufferSize - this._bufferPos) {
                return this.overrun();
            }
            str.getChars(off, off + len, this._buf, this._bufferPos);
            this._bufferPos += len;
            return true;
        }

        public boolean print(int c) {
            if (this._bufferPos == this._bufferSize) {
                return this.overrun();
            }
            this._buf[this._bufferPos++] = (char)c;
            return true;
        }

        private boolean overrun() {
            this.log("overrun");
            return false;
        }

        public void flush(Writer out) throws IOException {
            if (this._bufferPos != 0) {
                this.log("flush");
                out.write(this._buf, 0, this._bufferPos);
                this._bufferPos = 0;
            }
        }

        public int size() {
            return this._bufferPos;
        }

        public int getCapacity() {
            return this._bufferSize;
        }

        public void reset() {
            this.log("reset");
            this._bufferPos = 0;
        }

        public void finish() {
            this._bufferPos = 0;
            this.log("finish");
            if (this._bufferSize <= BufferFactoryImpl.this._bufferSize) {
                if (!BufferFactoryImpl.this._charBufferFreeList.free(this)) {
                    this._buf = null;
                }
            } else {
                this._buf = null;
            }
        }
    }
}

