/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.portal.generic;

import com.caucho.portal.generic.Renderer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import javax.portlet.PortletConfig;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRenderer
implements Renderer {
    public static final String PAGE_HEADER_RENDERED = "com.caucho.portal.generic.AbstractRenderer.PAGE_HEADER_RENDERED";
    protected static final Logger log = Logger.getLogger(AbstractRenderer._resin_compat_class_0().getName());
    private boolean _isAlwaysWrite = true;
    private boolean _isAlwaysStream;
    private String _defaultContentType = "text/html";
    private int _bufferSize = -1;
    private Boolean _isDecorateWindow;
    private static Class _resin_compat_class_0;

    public void setDecorateWindow(boolean isDecorateWindow) {
        this._isDecorateWindow = isDecorateWindow ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setAlwaysWrite(boolean isAlwaysWrite) {
        this._isAlwaysWrite = isAlwaysWrite;
    }

    public void setAlwaysStream(boolean isAlwaysStream) {
        this._isAlwaysStream = isAlwaysStream;
    }

    public void setDefaultContentType(String defaultContentType) {
        this._defaultContentType = defaultContentType;
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    @Override
    public boolean isWindowStateAllowed(PortletRequest request, WindowState windowState) {
        return true;
    }

    @Override
    public boolean isPortletModeAllowed(PortletRequest request, PortletMode portletMode) {
        return true;
    }

    @Override
    public boolean isAlwaysWrite() {
        return this._isAlwaysWrite;
    }

    @Override
    public boolean isAlwaysStream() {
        return this._isAlwaysStream;
    }

    @Override
    public String getDefaultContentType() {
        return this._defaultContentType;
    }

    @Override
    public int getBufferSize() {
        return this._bufferSize;
    }

    @Override
    public PrintWriter getWriter(PrintWriter out, RenderRequest request, String namespace) throws IOException {
        boolean doWindow;
        boolean doPage;
        boolean bl = doPage = request.getAttribute(PAGE_HEADER_RENDERED) == null;
        boolean bl2 = this._isDecorateWindow == null ? !doPage : (doWindow = this._isDecorateWindow.booleanValue());
        if (doPage) {
            this.beginPage(out, request, namespace);
            request.setAttribute(PAGE_HEADER_RENDERED, (Object)this);
        }
        if (doWindow) {
            this.beginWindow(out, request, namespace);
        }
        return out;
    }

    protected void beginPage(PrintWriter out, RenderRequest request, String namespace) throws IOException {
    }

    protected void beginWindow(PrintWriter out, RenderRequest request, String namespace) throws IOException {
    }

    protected void endWindow(PrintWriter out, RenderRequest request, String namespace) throws IOException {
    }

    protected void endPage(PrintWriter out, RenderRequest request, String namespace) throws IOException {
    }

    @Override
    public void finish(PrintWriter out, RenderRequest request, String namespace, boolean isDiscarded) throws IOException {
        boolean doWindow;
        boolean doPage;
        boolean bl = doPage = this == request.getAttribute(PAGE_HEADER_RENDERED);
        boolean bl2 = this._isDecorateWindow == null ? !doPage : (doWindow = this._isDecorateWindow.booleanValue());
        if (!isDiscarded) {
            if (doWindow) {
                this.endWindow(out, request, namespace);
            }
            if (doPage) {
                this.endPage(out, request, namespace);
            }
        } else if (this == request.getAttribute(PAGE_HEADER_RENDERED)) {
            request.removeAttribute(PAGE_HEADER_RENDERED);
        }
    }

    @Override
    public OutputStream getOutputStream(OutputStream out, RenderRequest request, String namespace) throws IOException {
        boolean doWindow;
        boolean doPage;
        boolean bl = doPage = request.getAttribute(PAGE_HEADER_RENDERED) == null;
        boolean bl2 = this._isDecorateWindow == null ? !doPage : (doWindow = this._isDecorateWindow.booleanValue());
        if (doPage) {
            this.beginPage(out, request, namespace);
            request.setAttribute(PAGE_HEADER_RENDERED, (Object)this);
        }
        if (doWindow) {
            this.beginWindow(out, request, namespace);
        }
        return out;
    }

    protected void beginPage(OutputStream out, RenderRequest request, String namespace) throws IOException {
    }

    protected void beginWindow(OutputStream out, RenderRequest request, String namespace) throws IOException {
    }

    protected void endWindow(OutputStream out, RenderRequest request, String namespace) throws IOException {
    }

    protected void endPage(OutputStream out, RenderRequest request, String namespace) throws IOException {
    }

    @Override
    public void finish(OutputStream out, RenderRequest request, String namespace, boolean isDiscarded) throws IOException {
        boolean doWindow;
        boolean doPage;
        boolean bl = doPage = this == request.getAttribute(PAGE_HEADER_RENDERED);
        boolean bl2 = this._isDecorateWindow == null ? !doPage : (doWindow = this._isDecorateWindow.booleanValue());
        if (!isDiscarded) {
            if (doWindow) {
                this.endWindow(out, request, namespace);
            }
            if (doPage) {
                this.endPage(out, request, namespace);
            }
        } else if (this == request.getAttribute(PAGE_HEADER_RENDERED)) {
            request.removeAttribute(PAGE_HEADER_RENDERED);
        }
    }

    protected String getContentType(RenderRequest request) {
        return request.getResponseContentType();
    }

    protected Locale getLocale(RenderRequest request) {
        return request.getLocale();
    }

    protected String getTitle(RenderRequest request) {
        Locale locale;
        PortletConfig portletConfig;
        ResourceBundle bundle;
        String title = (String)request.getAttribute("javax.portlet.title");
        if (title == null && (bundle = (portletConfig = (PortletConfig)request.getAttribute("javax.portlet.portletConfig")).getResourceBundle(locale = this.getLocale(request))) != null) {
            title = bundle.getString("javax.portlet.title");
        }
        return title;
    }

    protected String getShortTitle(RenderRequest request) {
        Locale locale;
        PortletConfig portletConfig;
        ResourceBundle bundle;
        String title = (String)request.getAttribute("javax.portlet.short-title");
        if (title == null) {
            title = (String)request.getAttribute("javax.portlet.title");
        }
        if (title == null && (title = (bundle = (portletConfig = (PortletConfig)request.getAttribute("javax.portlet.portletConfig")).getResourceBundle(locale = this.getLocale(request))).getString("javax.portlet.short-title")) == null) {
            title = bundle.getString("javax.portlet.title");
        }
        return title;
    }

    protected PortletURL createControlURL(RenderRequest request) {
        RenderResponse response = (RenderResponse)request.getAttribute("javax.portlet.renderResponse");
        Map renderParamMap = request.getParameterMap();
        PortletURL url = response.createRenderURL();
        url.setParameters(renderParamMap);
        return url;
    }

    protected Set<PortletMode> getPortletModes(RenderRequest request) {
        LinkedHashSet<PortletMode> portletModes = new LinkedHashSet<PortletMode>();
        Enumeration e = request.getPortalContext().getSupportedPortletModes();
        while (e.hasMoreElements()) {
            PortletMode portletMode = (PortletMode)e.nextElement();
            if (!request.isPortletModeAllowed(portletMode)) continue;
            portletModes.add(portletMode);
        }
        return portletModes;
    }

    protected Set<WindowState> getWindowStates(RenderRequest request) {
        LinkedHashSet<WindowState> windowStates = new LinkedHashSet<WindowState>();
        Enumeration e = request.getPortalContext().getSupportedWindowStates();
        while (e.hasMoreElements()) {
            WindowState windowState = (WindowState)e.nextElement();
            if (!request.isWindowStateAllowed(windowState)) continue;
            windowStates.add(windowState);
        }
        return windowStates;
    }

    protected ResourceBundle getResourceBundle(RenderRequest request) {
        Locale locale = this.getLocale(request);
        PortletConfig portletConfig = this.getPortletConfig(request);
        return portletConfig.getResourceBundle(locale);
    }

    protected PortletConfig getPortletConfig(RenderRequest request) {
        return (PortletConfig)request.getAttribute("javax.portlet.portletConfig");
    }

    protected RenderResponse getRenderResponse(RenderRequest request) {
        return (RenderResponse)request.getAttribute("javax.portlet.renderResponse");
    }

    protected PrintWriter printEscaped(PrintWriter out, CharSequence string) {
        if (string == null) {
            out.print((String)null);
            return out;
        }
        block7: for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '<': {
                    out.print("&lt;");
                    continue block7;
                }
                case '>': {
                    out.print("&gt;");
                    continue block7;
                }
                case '&': {
                    out.print("&amp;");
                    continue block7;
                }
                case '\"': {
                    out.print("&quot;");
                    continue block7;
                }
                case '\'': {
                    out.print("&rsquo;");
                    continue block7;
                }
                default: {
                    out.print(ch);
                }
            }
        }
        return out;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.portal.generic.AbstractRenderer");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

