/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.portal;

import com.caucho.portal.PortletMediator;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletSupport
extends GenericPortlet {
    private static final L10N L = new L10N(PortletSupport._resin_compat_class_0());
    protected static final Logger log = Logger.getLogger(PortletSupport._resin_compat_class_0().getName());
    private static final Class[] _actionMethodParams = new Class[]{PortletSupport._resin_compat_class_1(), PortletSupport._resin_compat_class_2()};
    private static final Class[] _renderMethodParams = new Class[]{PortletSupport._resin_compat_class_3(), PortletSupport._resin_compat_class_4()};
    private Map<PortletMode, ActionProxy> _actionProxyCache = Collections.synchronizedMap(new HashMap());
    private Map<PortletMode, RenderProxy> _renderProxyCache = Collections.synchronizedMap(new HashMap());
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;
    private static Class _resin_compat_class_2;
    private static Class _resin_compat_class_3;
    private static Class _resin_compat_class_4;

    public void init() throws PortletException {
    }

    protected <T> T useBean(PortletRequest request, String name, Class<T> c) {
        return this.useBean(request, name, c, true);
    }

    protected <T> T useBean(PortletRequest request, String name, Class<T> c, boolean create) {
        Object bean = request.getAttribute(name);
        if (bean == null && create) {
            try {
                bean = c.newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            request.setAttribute(name, bean);
        }
        return (T)bean;
    }

    protected boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    protected static <S extends PortletMediator> S createMediator(RenderRequest request, RenderResponse response, Class<S> mediatorClass) throws PortletException {
        String namespace = response.getNamespace();
        return PortletSupport.createMediator(request, response, mediatorClass, namespace);
    }

    protected static <S extends PortletMediator> S createMediator(RenderRequest request, RenderResponse response, Class<S> mediatorClass, String namespace) throws PortletException {
        PortletMediator mediator;
        String attributeName = mediatorClass.getName();
        if (namespace != null) {
            attributeName = new CharBuffer().append(attributeName).append(namespace).toString();
        }
        if ((mediator = (PortletMediator)request.getAttribute(attributeName)) == null) {
            try {
                mediator = (PortletMediator)mediatorClass.newInstance();
            }
            catch (Exception ex) {
                throw new PortletException((Throwable)ex);
            }
            request.setAttribute(attributeName, (Object)mediator);
        }
        mediator.setNamespace(namespace);
        mediator.setRequest((PortletRequest)request);
        mediator.setResponse((PortletResponse)response);
        return (S)mediator;
    }

    protected void prepare(PortletRequest request, PortletResponse response) throws PortletException {
    }

    protected void checkPrepare(PortletRequest request, PortletResponse response) throws PortletException {
        String attributeName = new CharBuffer().append("__prepared__").append(System.identityHashCode((Object)this)).toString();
        if (request.getAttribute(attributeName) == null) {
            request.setAttribute(attributeName, (Object)Boolean.TRUE);
            if (log.isLoggable(Level.FINEST)) {
                log.finest(L.l("prepare for mode `{0}'", request.getPortletMode()));
            }
            this.prepare(request, response);
        }
    }

    private ActionProxy findActionProxy(ActionRequest request, ActionResponse response) {
        ActionProxy proxy;
        PortletMode mode;
        block6: {
            mode = request.getPortletMode();
            proxy = this._actionProxyCache.get(mode);
            if (proxy != null) {
                return proxy;
            }
            try {
                Method method;
                String methodName = new StringBuffer().append("action").append(Character.toUpperCase(mode.toString().charAt(0))).append(mode.toString().substring(1)).toString();
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, new CharBuffer().append("looking for method `").append(methodName).append("'").toString());
                }
                if ((method = ((Object)((Object)this)).getClass().getMethod(methodName, _actionMethodParams)) != null) {
                    proxy = new ActionProxy(){

                        public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
                            try {
                                if (log.isLoggable(Level.FINEST)) {
                                    log.log(Level.FINER, new CharBuffer().append("invoking method ").append(method).toString());
                                }
                                method.invoke((Object)PortletSupport.this, request, response);
                            }
                            catch (IllegalAccessException ex) {
                                throw new PortletException((Throwable)ex);
                            }
                            catch (InvocationTargetException ex) {
                                throw new PortletException((Throwable)ex);
                            }
                        }
                    };
                }
            }
            catch (NoSuchMethodException ex) {
                if (!log.isLoggable(Level.FINE)) break block6;
                log.log(Level.FINE, ex.toString(), ex);
            }
        }
        if (proxy != null) {
            this._actionProxyCache.put(mode, proxy);
        }
        return proxy;
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        ActionProxy proxy;
        PortletMode mode = request.getPortletMode();
        if (log.isLoggable(Level.FINEST)) {
            log.finest(L.l("processAction for mode `{0}'", mode));
        }
        if ((proxy = this.findActionProxy(request, response)) == null) {
            throw new PortletModeException(L.l("No action for mode `{0}'", mode), mode);
        }
        this.checkPrepare((PortletRequest)request, (PortletResponse)response);
        proxy.processAction(request, response);
    }

    private RenderProxy findRenderProxy(RenderRequest request, RenderResponse response) {
        RenderProxy proxy;
        PortletMode mode;
        block9: {
            mode = request.getPortletMode();
            proxy = this._renderProxyCache.get(mode);
            if (proxy != null) {
                return proxy;
            }
            Iterator<String> candidates = this.getViewCandidates(request, response);
            while (candidates.hasNext()) {
                String candidate = candidates.next();
                if (log.isLoggable(Level.FINER)) {
                    log.finer(L.l("view candidate `{0}'", candidate));
                }
                if (!new File(this.getPortletContext().getRealPath(candidate)).exists()) continue;
                final String target = candidate;
                proxy = new RenderProxy(){

                    public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
                        PortletSupport.this.dispatchView(request, response, target);
                    }
                };
                break;
            }
            if (proxy != null) {
                this._renderProxyCache.put(mode, proxy);
                return proxy;
            }
            String methodName = new StringBuffer().append("do").append(Character.toUpperCase(mode.toString().charAt(0))).append(mode.toString().substring(1)).toString();
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, new CharBuffer().append("looking for method `").append(methodName).append("'").toString());
            }
            try {
                final Method method = ((Object)((Object)this)).getClass().getMethod(methodName, _renderMethodParams);
                if (method != null) {
                    proxy = new RenderProxy(){

                        public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
                            try {
                                if (log.isLoggable(Level.FINER)) {
                                    log.log(Level.FINER, new CharBuffer().append("invoking method ").append(method).toString());
                                }
                                if (log.isLoggable(Level.FINER)) {
                                    log.log(Level.FINER, new CharBuffer().append("with ").append(request).append(" ").append(response).toString());
                                }
                                method.invoke((Object)PortletSupport.this, request, response);
                            }
                            catch (IllegalAccessException ex) {
                                throw new PortletException((Throwable)ex);
                            }
                            catch (InvocationTargetException ex) {
                                throw new PortletException((Throwable)ex);
                            }
                        }
                    };
                }
            }
            catch (NoSuchMethodException ex) {
                if (!log.isLoggable(Level.FINEST)) break block9;
                log.log(Level.FINEST, ex.toString(), ex);
            }
        }
        if (proxy != null) {
            this._renderProxyCache.put(mode, proxy);
        }
        return proxy;
    }

    protected Iterator<String> getViewCandidates(RenderRequest request, RenderResponse response) {
        final String path = new StringBuffer().append(this.getPortletName()).append('/').append(request.getPortletMode().toString()).toString();
        return new Iterator<String>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 3;
            }

            @Override
            public String next() {
                switch (this.i++) {
                    case 0: {
                        return new CharBuffer().append(path).append(".xtp").toString();
                    }
                    case 1: {
                        return new CharBuffer().append(path).append(".jsp").toString();
                    }
                    case 2: {
                        return new CharBuffer().append(path).append(".jspx").toString();
                    }
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        WindowState windowState = request.getWindowState();
        if (windowState.equals((Object)WindowState.MINIMIZED)) {
            return;
        }
        RenderProxy proxy = this.findRenderProxy(request, response);
        PortletMode mode = request.getPortletMode();
        if (log.isLoggable(Level.FINEST)) {
            log.finest(L.l("render for mode `{0}'", mode));
        }
        if (proxy == null) {
            throw new PortletModeException(L.l("No render for mode `{0}'", mode), mode);
        }
        this.checkPrepare((PortletRequest)request, (PortletResponse)response);
        if (response.getContentType() == null) {
            response.setContentType("text/html");
        }
        proxy.render(request, response);
    }

    protected void dispatchView(RenderRequest request, RenderResponse response, String path) throws PortletException, IOException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(L.l("dispatching view to `{0}'", path));
        }
        PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher(path);
        dispatcher.include(request, response);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.portal.PortletSupport");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("javax.portlet.ActionRequest");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_2() {
        try {
            Class<?> clazz = _resin_compat_class_2;
            if (clazz == null) {
                clazz = _resin_compat_class_2 = Class.forName("javax.portlet.ActionResponse");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_3() {
        try {
            Class<?> clazz = _resin_compat_class_3;
            if (clazz == null) {
                clazz = _resin_compat_class_3 = Class.forName("javax.portlet.RenderRequest");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_4() {
        try {
            Class<?> clazz = _resin_compat_class_4;
            if (clazz == null) {
                clazz = _resin_compat_class_4 = Class.forName("javax.portlet.RenderResponse");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static interface RenderProxy {
        public void render(RenderRequest var1, RenderResponse var2) throws PortletException, IOException;
    }

    private static interface ActionProxy {
        public void processAction(ActionRequest var1, ActionResponse var2) throws PortletException, IOException;
    }
}

