/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.naming;

import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingException;

public class Jndi {
    private static Logger log = Log.open(Jndi._resin_compat_class_0());
    private static L10N L = new L10N(Jndi._resin_compat_class_0());
    private static Class _resin_compat_class_0;

    public static void bindDeepShort(String name, Object obj) throws NamingException {
        if (name.startsWith("java:comp")) {
            Jndi.bindDeep(name, obj);
        } else {
            Jndi.bindDeep(new CharBuffer().append("java:comp/env/").append(name).toString(), obj);
        }
    }

    public static void bindDeep(String name, Object obj) throws NamingException {
        Jndi.bindDeep(new InitialContext(), name, obj, name);
    }

    public static void bindDeep(Context context, String name, Object obj, String fullName) throws NamingException {
        NameParser parser = context.getNameParser("");
        Name parsedName = parser.parse(name);
        if (parsedName.size() == 1) {
            Object value = null;
            try {
                value = context.lookup(name);
            }
            catch (NameNotFoundException e) {
                // empty catch block
            }
            if (value != null) {
                log.warning(L.l("`{0}' is a conflicting JNDI resource for `{1}'", (Object)fullName, obj));
            }
            context.rebind(name, obj);
            return;
        }
        Object sub = null;
        try {
            sub = context.lookup(parsedName.get(0));
        }
        catch (NameNotFoundException e) {
            // empty catch block
        }
        if (sub == null) {
            sub = context.createSubcontext(parsedName.get(0));
        }
        if (!(sub instanceof Context)) {
            throw new NamingException(L.l("`{0}' is an invalid JNDI name because `{1} is not a Context.  One of the subcontexts is not a Context as expected.", (Object)fullName, sub));
        }
        Jndi.bindDeep((Context)sub, parsedName.getSuffix(1).toString(), obj, fullName);
    }

    public static void rebindDeepShort(String name, Object obj) throws NamingException {
        if (name.startsWith("java:comp")) {
            Jndi.rebindDeep(name, obj);
        } else {
            Jndi.rebindDeep(new CharBuffer().append("java:comp/env/").append(name).toString(), obj);
        }
    }

    public static String getFullName(String shortName) {
        if (shortName.startsWith("java:comp")) {
            return shortName;
        }
        return new CharBuffer().append("java:comp/env/").append(shortName).toString();
    }

    public static void rebindDeep(String name, Object obj) throws NamingException {
        Jndi.rebindDeep(new InitialContext(), name, obj, name);
    }

    public static void rebindDeep(Context context, String name, Object obj, String fullName) throws NamingException {
        NameParser parser = context.getNameParser("");
        Name parsedName = parser.parse(name);
        if (parsedName.size() == 1) {
            context.rebind(name, obj);
            return;
        }
        Object sub = context.lookup(parsedName.get(0));
        if (sub == null) {
            sub = context.createSubcontext(parsedName.get(0));
        }
        if (!(sub instanceof Context)) {
            throw new NamingException(L.l("`{0}' is an invalid JNDI name because `{1} is not a Context.  One of the subcontexts is not a Context as expected.", (Object)fullName, sub));
        }
        Jndi.rebindDeep((Context)sub, parsedName.getSuffix(1).toString(), obj, fullName);
    }

    public static Object lookup(String name) {
        Object value;
        try {
            value = new InitialContext().lookup(name);
            if (value != null) {
                return value;
            }
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (!name.startsWith("java:comp/env")) {
            try {
                value = new InitialContext().lookup(new CharBuffer().append("java:comp/env/").append(name).toString());
                if (value != null) {
                    return value;
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return null;
    }

    private Jndi() {
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.naming.Jndi");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

