/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.make;

import com.caucho.loader.DynamicClassLoader;
import com.caucho.log.Log;
import com.caucho.make.Dependency;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import java.util.ArrayList;
import java.util.logging.Logger;

public class DependencyContainer
implements Dependency {
    private static Logger _log;
    private ArrayList<Dependency> _dependencyList = new ArrayList();
    private boolean _isModified;
    private long _checkInterval = DynamicClassLoader.getGlobalDependencyCheckInterval();
    private long _lastCheckTime = 0L;
    private volatile boolean _isChecking;
    private static Class _resin_compat_class_0;

    public DependencyContainer() {
        for (ClassLoader loader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof DynamicClassLoader)) continue;
            this._checkInterval = ((DynamicClassLoader)loader).getDependencyCheckInterval();
            break;
        }
    }

    public DependencyContainer add(Dependency dependency) {
        if (dependency == this) {
            throw new IllegalArgumentException("Can't add self as a dependency.");
        }
        if (!this._dependencyList.contains(dependency)) {
            this._dependencyList.add(dependency);
        }
        return this;
    }

    public DependencyContainer remove(Dependency dependency) {
        if (dependency == this) {
            throw new IllegalArgumentException("Can't remove self as a dependency.");
        }
        this._dependencyList.remove(dependency);
        return this;
    }

    public void setCheckInterval(long checkInterval) {
        this._checkInterval = checkInterval < 0L || checkInterval > 0x3FFFFFFFFFFFFFFFL ? 0x3FFFFFFFFFFFFFFFL : checkInterval;
        this._lastCheckTime = 0L;
    }

    public long getCheckInterval() {
        return this._checkInterval;
    }

    public void setModified(boolean isModified) {
        this._isModified = isModified;
        this._lastCheckTime = 0L;
    }

    public void resetDependencyCheckInterval() {
        this._lastCheckTime = 0L;
    }

    public void clearModified() {
        this._isModified = false;
        this._lastCheckTime = Alarm.getCurrentTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isModified() {
        DependencyContainer dependencyContainer = this;
        synchronized (dependencyContainer) {
            if (this._isChecking || this._isModified) {
                return this._isModified;
            }
            this._isChecking = true;
        }
        try {
            long now = Alarm.getCurrentTime();
            if (now < this._lastCheckTime + this._checkInterval) {
                boolean bl = this._isModified;
                return bl;
            }
            this._lastCheckTime = now;
            for (int i = this._dependencyList.size() - 1; i >= 0; --i) {
                Dependency dependency = this._dependencyList.get(i);
                if (!dependency.isModified()) continue;
                this.log().fine(new CharBuffer().append(dependency).append(" is modified").toString());
                boolean bl = this._isModified = true;
                return bl;
            }
            boolean bl = this._isModified;
            return bl;
        }
        finally {
            this._isChecking = false;
        }
    }

    public boolean isModifiedNow() {
        this._lastCheckTime = 0L;
        return this.isModified();
    }

    private Logger log() {
        if (_log == null) {
            _log = Log.open(DependencyContainer._resin_compat_class_0());
        }
        return _log;
    }

    public String toString() {
        return new CharBuffer().append("DependencyContainer").append(this._dependencyList).toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.make.DependencyContainer");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

