/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import com.caucho.config.ConfigException;
import com.caucho.config.types.RawString;
import com.caucho.el.EL;
import com.caucho.el.ELParser;
import com.caucho.el.Expr;
import com.caucho.log.MessageFormatter;
import com.caucho.util.L10N;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;

public class ELFormatter
extends MessageFormatter {
    static final L10N L = new L10N(ELFormatter._resin_compat_class_0());
    private String _format;
    private Expr _expr;
    private static Class _resin_compat_class_0;

    public void setFormat(RawString format) {
        this._format = format.getValue();
    }

    public String getFormat() {
        return this._format;
    }

    public void init() throws ConfigException {
        if (this._format != null) {
            try {
                this._expr = new ELParser(this._format).parse();
            }
            catch (Exception ex) {
                throw new ConfigException(ex);
            }
        }
    }

    public String format(LogRecord logRecord) {
        String ret;
        if (this._expr == null) {
            return super.format(logRecord);
        }
        if (this._expr == null) {
            ret = super.format(logRecord);
        } else {
            try {
                ELFormatterVariableResolver vr = new ELFormatterVariableResolver();
                vr.setLogRecord(logRecord);
                ret = this._expr.evalString(vr);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return ret;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.log.ELFormatter");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public class ELFormatterLogRecord {
        LogRecord _logRecord;

        ELFormatterLogRecord(LogRecord logRecord) {
            this._logRecord = logRecord;
        }

        public String getMessage() {
            return ELFormatter.this.formatMessage(this._logRecord);
        }

        public String getName() {
            return this._logRecord.getLoggerName();
        }

        public String getLoggerName() {
            return this._logRecord.getLoggerName();
        }

        public String getShortName() {
            int index;
            String name = this._logRecord.getLoggerName();
            if (name != null && (index = name.lastIndexOf(46) + 1) > 0 && index < name.length()) {
                name = name.substring(index);
            }
            return name;
        }

        public Level getLevel() {
            return this._logRecord.getLevel();
        }

        public long getMillis() {
            return this._logRecord.getMillis();
        }

        public int getThreadID() {
            return this._logRecord.getThreadID();
        }

        public Throwable getThrown() {
            return this._logRecord.getThrown();
        }

        public long getSequenceNumber() {
            return this._logRecord.getSequenceNumber();
        }

        public String getSourceClassName() {
            return this._logRecord.getSourceClassName();
        }

        public String getShortSourceClassName() {
            int index;
            String name = this._logRecord.getSourceClassName();
            if (name != null && (index = name.lastIndexOf(46) + 1) > 0 && index < name.length()) {
                name = name.substring(index);
            }
            return name;
        }

        public String getSourceMethodName() {
            return this._logRecord.getSourceMethodName();
        }

        public String getRawMessage() {
            return this._logRecord.getMessage();
        }

        public ResourceBundle getResourceBundle() {
            return this._logRecord.getResourceBundle();
        }

        public String getResourceBundleName() {
            return this._logRecord.getResourceBundleName();
        }

        public Object[] getParameters() {
            return this._logRecord.getParameters();
        }
    }

    class ELFormatterVariableResolver
    implements VariableResolver {
        ELFormatterLogRecord _logRecord;

        ELFormatterVariableResolver() {
        }

        public void setLogRecord(LogRecord logRecord) {
            this._logRecord = new ELFormatterLogRecord(logRecord);
        }

        public Object resolveVariable(String name) throws ELException {
            if (name.equals("log")) {
                return this._logRecord;
            }
            return EL.getEnvironment().resolveVariable(name);
        }
    }
}

