/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader.enhancer;

import com.caucho.bytecode.Analyzer;
import com.caucho.bytecode.Attribute;
import com.caucho.bytecode.ByteCodeParser;
import com.caucho.bytecode.CodeAttribute;
import com.caucho.bytecode.CodeEnhancer;
import com.caucho.bytecode.CodeVisitor;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.ConstantPoolEntry;
import com.caucho.bytecode.JavaClass;
import com.caucho.bytecode.JavaClassLoader;
import com.caucho.bytecode.JavaField;
import com.caucho.bytecode.JavaMethod;
import com.caucho.bytecode.MethodRefConstant;
import com.caucho.bytecode.Utf8Constant;
import com.caucho.java.WorkDir;
import com.caucho.java.gen.JavaClassGenerator;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.enhancer.ClassEnhancer;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

public class EnhancerFixup {
    private static final L10N L = new L10N(EnhancerFixup._resin_compat_class_0());
    private static final Logger log = Logger.getLogger(EnhancerFixup._resin_compat_class_0().getName());
    private static final int ACC_PUBLIC = 1;
    private static final int ACC_PRIVATE = 2;
    private static final int ACC_PROTECTED = 4;
    private JavaClassGenerator _javaGen = new JavaClassGenerator();
    private JavaClassLoader _jClassLoader;
    private DynamicClassLoader _loader;
    private Path _workPath;
    private String _baseSuffix = "";
    private String _extSuffix = "__ResinExt";
    private ArrayList<ClassEnhancer> _enhancerList = new ArrayList();
    private boolean _isParentStarted;
    private static Class _resin_compat_class_0;

    public void setClassLoader(DynamicClassLoader loader) {
        this._loader = loader;
    }

    public void setJavaClassLoader(JavaClassLoader jClassLoader) {
        this._jClassLoader = jClassLoader;
    }

    public JavaClassLoader getJavaClassLoader() {
        return this._jClassLoader;
    }

    public Path getWorkPath() {
        if (this._workPath != null) {
            return this._workPath;
        }
        return WorkDir.getLocalWorkDir();
    }

    public void setWorkPath(Path workPath) {
        this._workPath = workPath;
    }

    public final Path getPreWorkPath() {
        return this.getWorkPath().lookup("pre-enhance");
    }

    public final Path getPostWorkPath() {
        return this.getWorkPath().lookup("post-enhance");
    }

    public void addEnhancer(ClassEnhancer enhancer) {
        this._enhancerList.add(enhancer);
    }

    protected void fixup(String className, String extClassName) throws Exception {
        String classSuffix;
        Path targetDir;
        Path preTargetDir;
        Path prePath = this.getPreWorkPath();
        Path postPath = this.getPostWorkPath();
        Path source = this.getSource(className);
        if (source == null || !source.canRead()) {
            return;
        }
        Path ext = prePath.lookup(new CharBuffer().append(extClassName.replace('.', '/')).append(".class").toString());
        Path target = postPath.lookup(new CharBuffer().append(className.replace('.', '/')).append(".class").toString());
        try {
            target.getParent().mkdirs();
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (source != null) {
            this.mergeClasses(className, target, source, ext);
        } else {
            this.mergeClasses(className, target, ext);
        }
        int p = className.lastIndexOf(46);
        String prefix = "";
        if (p > 0) {
            prefix = className.substring(0, p).replace('.', '/');
            preTargetDir = prePath.lookup(prefix);
            targetDir = postPath.lookup(prefix);
            classSuffix = className.substring(p + 1);
        } else {
            preTargetDir = prePath;
            targetDir = postPath;
            classSuffix = className;
        }
        prefix = prefix.replace('/', '.');
        if (!prefix.equals("")) {
            prefix = new CharBuffer().append(prefix).append(".").toString();
        }
        String extSuffix = (p = extClassName.lastIndexOf(46)) > 0 ? extClassName.substring(p + 1) : extClassName;
        this.fixupPreSubClasses(preTargetDir, targetDir, extSuffix, classSuffix);
        this.fixupPostSubClasses(targetDir, prefix, classSuffix);
    }

    private void fixupPreSubClasses(Path preTargetDir, Path targetDir, String extSuffix, String classSuffix) throws Exception {
        String[] list = preTargetDir.list();
        for (int i = 0; i < list.length; ++i) {
            Path extPath;
            Path subTarget;
            String targetClass;
            int p;
            String name = list[i];
            if (name.startsWith(new CharBuffer().append(extSuffix).append('$').toString()) && name.endsWith(".class")) {
                p = name.indexOf(36);
                targetClass = new CharBuffer().append(classSuffix).append('$').append(name.substring(p + 1, name.length() - 6)).toString();
                subTarget = targetDir.lookup(new CharBuffer().append(targetClass).append(".class").toString());
                extPath = preTargetDir.lookup(name);
                this.renameSubClass(classSuffix, subTarget, extPath);
                continue;
            }
            if (!name.startsWith(new CharBuffer().append(extSuffix).append('-').toString()) || !name.endsWith(".class")) continue;
            p = name.indexOf(45);
            targetClass = new CharBuffer().append(classSuffix).append('-').append(name.substring(p + 1, name.length() - 6)).toString();
            subTarget = targetDir.lookup(new CharBuffer().append(targetClass).append(".class").toString());
            extPath = preTargetDir.lookup(name);
            this.renameSubClass(classSuffix, subTarget, extPath);
        }
    }

    private void fixupPostSubClasses(Path targetDir, String prefix, String classSuffix) throws Exception {
        String[] list = targetDir.list();
        for (int i = 0; i < list.length; ++i) {
            String name = list[i];
            if (!name.endsWith(".class")) continue;
            String className = name.substring(0, name.length() - ".class".length());
            if (name.startsWith(new CharBuffer().append(classSuffix).append('$').toString())) {
                if (this._loader == null) continue;
                this._loader.addPathClass(new CharBuffer().append(prefix).append(className).toString(), targetDir.lookup(name));
                continue;
            }
            if (name.startsWith(new CharBuffer().append(classSuffix).append('-').toString())) {
                if (this._loader == null) continue;
                this._loader.addPathClass(new CharBuffer().append(prefix).append(className).toString(), targetDir.lookup(name));
                continue;
            }
            if (!name.startsWith(new CharBuffer().append(classSuffix).append('+').toString()) || this._loader == null) continue;
            this._loader.addPathClass(new CharBuffer().append(prefix).append(className).toString(), targetDir.lookup(name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renameSubClass(String className, Path targetPath, Path extPath) throws Exception {
        JavaClass extClass = null;
        ByteCodeParser parser = new ByteCodeParser();
        parser = new ByteCodeParser();
        parser.setClassLoader(new JavaClassLoader());
        ReadStream is = extPath.openRead();
        try {
            extClass = parser.parse(is);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        this.cleanExtConstantPool(className, extClass);
        WriteStream os = targetPath.openWrite();
        try {
            extClass.write(os);
        }
        finally {
            os.close();
        }
    }

    protected void renameExtSuperMethods(String className, JavaClass baseClass, JavaClass extClass) throws Exception {
        ArrayList<ConstantPoolEntry> entries = extClass.getConstantPool().getEntries();
        className = className.replace('.', '/');
        String baseName = new CharBuffer().append(className).append(this._baseSuffix).toString();
        String extName = new CharBuffer().append(className).append("__ResinExt").toString();
        for (int i = 0; i < entries.size(); ++i) {
            String type;
            String methodName;
            MethodRefConstant methodRef;
            ConstantPoolEntry entry = entries.get(i);
            if (!(entry instanceof MethodRefConstant) || !(methodRef = (MethodRefConstant)entry).getClassName().equals(baseName) || this.findMethod(baseClass, methodName = methodRef.getName(), type = methodRef.getType()) == null || this.findMethod(extClass, methodName, type) == null) continue;
            if (methodName.equals("<init>")) {
                methodName = "__init__super";
                continue;
            }
            methodName = new CharBuffer().append(methodName).append("__super").toString();
            methodRef.setNameAndType(methodName, type);
        }
    }

    private void moveSuperMethods(String className, JavaClass baseClass, JavaClass extClass) {
        className = className.replace('.', '/');
        ArrayList<JavaMethod> methods = baseClass.getMethodList();
        ArrayList<JavaMethod> extMethods = extClass.getMethodList();
        block0: for (int i = 0; i < extMethods.size(); ++i) {
            JavaMethod extMethod = extMethods.get(i);
            String baseName = extMethod.getName();
            if (baseName.endsWith("__super")) continue;
            String superName = new CharBuffer().append(baseName).append("__super").toString();
            for (int j = 0; j < methods.size(); ++j) {
                JavaMethod method = methods.get(j);
                String type = method.getDescriptor();
                if (!method.getName().equals(baseName) || !method.getDescriptor().equals(extMethod.getDescriptor())) continue;
                if (baseName.equals("<init>")) {
                    baseClass.getConstantPool().addUTF8("__init__super");
                    this.mergeInitMethods(baseClass, method, extClass, extMethod);
                    continue block0;
                }
                if (baseName.equals("<clinit>")) {
                    this.concatenateMethods(baseClass, method, extClass, extMethod);
                    continue block0;
                }
                baseClass.getConstantPool().addUTF8(superName);
                method.setName(superName);
                baseClass.getConstantPool().addUTF8(type);
                method.setDescriptor(type);
                int flags = method.getAccessFlags();
                flags = flags & 0xFFFFFFFE & 0xFFFFFFFB | 2;
                method.setAccessFlags(flags);
                continue block0;
            }
        }
    }

    private void concatenateMethods(JavaClass baseClass, JavaMethod baseMethod, JavaClass extClass, JavaMethod extMethod) {
        extMethod = extMethod.export(extClass, baseClass);
        baseMethod.concatenate(extMethod);
    }

    private void mergeInitMethods(JavaClass baseClass, JavaMethod baseMethod, JavaClass extClass, JavaMethod extMethod) {
        extMethod = extMethod.export(extClass, baseClass);
        baseMethod.setName("__init__super");
        baseClass.getMethodList().add(extMethod);
        try {
            InitAnalyzer initAnalyzer = new InitAnalyzer();
            CodeEnhancer baseEnhancer = new CodeEnhancer(baseClass, baseMethod.getCode());
            baseEnhancer.analyze(initAnalyzer);
            int offset = initAnalyzer.getOffset();
            byte[] code = new byte[offset];
            byte[] oldCode = baseEnhancer.getCode();
            System.arraycopy(oldCode, 0, code, 0, offset);
            baseEnhancer.remove(0, offset);
            baseEnhancer.update();
            CodeEnhancer extEnhancer = new CodeEnhancer(baseClass, extMethod.getCode());
            extEnhancer.add(0, code, 0, code.length);
            ExtInitAnalyzer extInitAnalyzer = new ExtInitAnalyzer(offset);
            extEnhancer.analyze(extInitAnalyzer);
            extEnhancer.update();
            CodeAttribute baseCode = baseMethod.getCode();
            CodeAttribute extCode = extMethod.getCode();
            if (extCode.getMaxStack() < baseCode.getMaxStack()) {
                extCode.setMaxStack(baseCode.getMaxStack());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addExtInterfaces(JavaClass baseClass, JavaClass extClass) {
        Iterator<String> i$ = extClass.getInterfaceNames().iterator();
        while (i$.hasNext()) {
            String name = i$.next();
            baseClass.getConstantPool().addClass(name);
            baseClass.addInterface(name);
        }
    }

    private void addExtMethods(JavaClass baseClass, JavaClass extClass) {
        ArrayList<JavaMethod> methods = baseClass.getMethodList();
        ArrayList<JavaMethod> extMethods = extClass.getMethodList();
        for (int i = 0; i < extMethods.size(); ++i) {
            JavaMethod extMethod = extMethods.get(i);
            if (extMethod.getName().equals("<clinit>") && this.findMethod(baseClass, "<clinit>", extMethod.getDescriptor()) != null || extMethod.getName().equals("<init>") || extMethod.getName().endsWith("__super")) continue;
            log.finest(new CharBuffer().append("adding extension method: ").append(extClass.getThisClass()).append(":").append(extMethod.getName()).toString());
            JavaMethod method = extMethod.export(extClass, baseClass);
            methods.add(method);
        }
    }

    private void addExtClasses(JavaClass baseClass, JavaClass extClass) {
    }

    private JavaMethod findMethod(JavaClass cl, String name, String descriptor) {
        ArrayList<JavaMethod> methods = cl.getMethodList();
        for (int j = 0; j < methods.size(); ++j) {
            JavaMethod method = methods.get(j);
            if (!method.getName().equals(name) || !method.getDescriptor().equals(descriptor)) continue;
            return method;
        }
        return null;
    }

    private void moveSuperFields(JavaClass baseClass, JavaClass extClass) {
        ArrayList<JavaField> fields = baseClass.getFieldList();
        ArrayList<JavaField> extFields = extClass.getFieldList();
        for (int i = 0; i < extFields.size(); ++i) {
        }
    }

    private Path getSource(String className) {
        ClassLoader loader = this._loader;
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        URL url = ((ClassLoader)loader).getResource(new CharBuffer().append(className.replace('.', '/')).append(".class").toString());
        return Vfs.lookup(url.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeClasses(String className, Path targetPath, Path sourcePath, Path extPath) throws Exception {
        JavaClass baseClass = null;
        JavaClass extClass = null;
        ByteCodeParser parser = new ByteCodeParser();
        parser.setClassLoader(this.getJavaClassLoader());
        ReadStream is = sourcePath.openRead();
        try {
            baseClass = parser.parse(is);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        parser = new ByteCodeParser();
        parser.setClassLoader(this.getJavaClassLoader());
        is = extPath.openRead();
        try {
            extClass = parser.parse(is);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        this.mergeClasses(className, baseClass, extClass);
        this.postEnhance(baseClass);
        WriteStream os = targetPath.openWrite();
        try {
            baseClass.write(os);
        }
        finally {
            os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeClasses(String className, Path targetPath, Path extPath) throws Exception {
        JavaClass baseClass = null;
        JavaClass extClass = null;
        ByteCodeParser parser = new ByteCodeParser();
        parser.setClassLoader(this.getJavaClassLoader());
        ReadStream is = extPath.openRead();
        try {
            extClass = parser.parse(is);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        this.cleanExtConstantPool(className, extClass);
        this.postEnhance(baseClass);
        WriteStream os = targetPath.openWrite();
        try {
            extClass.write(os);
        }
        finally {
            os.close();
        }
    }

    protected void postEnhance(JavaClass baseClass) throws Exception {
        for (int i = 0; i < this._enhancerList.size(); ++i) {
            this._enhancerList.get(i).postEnhance(baseClass);
        }
    }

    protected void mergeClasses(String className, JavaClass baseClass, JavaClass extClass) throws Exception {
        if (baseClass.getMajor() < extClass.getMajor()) {
            baseClass.setMajor(extClass.getMajor());
            baseClass.setMinor(extClass.getMinor());
        }
        this.cleanExtConstantPool(className, extClass);
        this.renameExtSuperMethods(className, baseClass, extClass);
        this.cleanExtConstantPool(className, baseClass);
        this.addExtInterfaces(baseClass, extClass);
        this.addExtFields(baseClass, extClass);
        this.moveSuperMethods(className, baseClass, extClass);
        this.addExtMethods(baseClass, extClass);
        this.copyExtAnnotations(baseClass);
        this.addExtClasses(baseClass, extClass);
    }

    protected void cleanExtConstantPool(String className, JavaClass extClass) throws Exception {
        extClass.setThisClass(this.replaceString(className, extClass.getThisClass()));
        extClass.setSuperClass(this.replaceString(className, extClass.getSuperClassName()));
        ArrayList<ConstantPoolEntry> entries = extClass.getConstantPool().getEntries();
        int t = className.lastIndexOf(46);
        if (t > 0) {
            className = className.substring(t + 1);
        }
        String baseName = new CharBuffer().append(className).append(this._baseSuffix).toString();
        String extName = new CharBuffer().append(className).append("__ResinExt").toString();
        for (int i = 0; i < entries.size(); ++i) {
            ConstantPoolEntry entry = entries.get(i);
            if (!(entry instanceof Utf8Constant)) continue;
            Utf8Constant utf8 = (Utf8Constant)entry;
            String string = utf8.getValue();
            string = this.replaceString(className, string);
            utf8.setValue(string);
        }
        ArrayList<JavaField> fields = extClass.getFieldList();
        for (int i = 0; i < fields.size(); ++i) {
            JavaField field = fields.get(i);
            field.setName(this.replaceString(className, field.getName()));
            field.setDescriptor(this.replaceString(className, field.getDescriptor()));
        }
        ArrayList<JavaMethod> methods = extClass.getMethodList();
        for (int i = 0; i < methods.size(); ++i) {
            JavaMethod method = methods.get(i);
            method.setName(this.replaceString(className, method.getName()));
            method.setDescriptor(this.replaceString(className, method.getDescriptor()));
        }
    }

    private void copyExtAnnotations(JavaClass baseClass) {
        Iterator<JavaMethod> i$ = baseClass.getMethodList().iterator();
        while (i$.hasNext()) {
            Attribute ann;
            JavaMethod method = i$.next();
            if (!method.getName().endsWith("__super") || (ann = method.getAttribute("RuntimeVisibleAnnotations")) == null) continue;
            String name = method.getName();
            JavaMethod baseMethod = this.findMethod(baseClass, name = name.substring(0, name.length() - "__super".length()), method.getDescriptor());
            if (baseMethod == null) continue;
            baseMethod.addAttribute(ann);
        }
    }

    private void addExtFields(JavaClass baseClass, JavaClass extClass) {
        ArrayList<JavaField> fields = baseClass.getFieldList();
        Iterator<JavaField> i$ = extClass.getFieldList().iterator();
        while (i$.hasNext()) {
            JavaField extField = i$.next();
            JavaField field = extField.export(extClass, baseClass);
            if (fields.contains(field)) continue;
            fields.add(field);
        }
    }

    private String replaceString(String className, String string) {
        string = this.replaceStringInt(className.replace('.', '/'), string);
        string = this.replaceStringInt(className.replace('.', '$'), string);
        string = this.replaceStringInt(className.replace('.', '-'), string);
        return string;
    }

    private String replaceStringInt(String className, String string) {
        String suffix;
        String prefix;
        int p;
        int t = className.lastIndexOf(46);
        if (t > 0) {
            className = className.substring(t + 1);
        }
        String baseName = new CharBuffer().append(className).append(this._baseSuffix).toString();
        String extName = "__ResinExt";
        if (!baseName.equals(className)) {
            while ((p = string.indexOf(baseName)) >= 0) {
                prefix = string.substring(0, p);
                suffix = string.substring(p + baseName.length());
                string = new CharBuffer().append(prefix).append(className).append(suffix).toString();
            }
        }
        while ((p = string.indexOf(extName)) >= 0) {
            prefix = string.substring(0, p);
            suffix = string.substring(p + extName.length());
            string = new CharBuffer().append(prefix).append(suffix).toString();
        }
        return string;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.loader.enhancer.EnhancerFixup");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static class ExtInitAnalyzer
    extends Analyzer {
        int _startOffset;
        boolean _isEnhanced;

        ExtInitAnalyzer(int length) {
            this._startOffset = length;
        }

        public void analyze(CodeVisitor visitor) throws Exception {
            if (this._isEnhanced) {
                return;
            }
            if (visitor.getOffset() < this._startOffset) {
                return;
            }
            switch (visitor.getOpcode()) {
                case 183: {
                    int index = visitor.getShortArg();
                    ConstantPool cp = visitor.getJavaClass().getConstantPool();
                    MethodRefConstant ref = cp.getMethodRef(index);
                    if (!ref.getName().equals("<init>")) {
                        return;
                    }
                    MethodRefConstant newRef = cp.addMethodRef(ref.getClassName(), "__init__super", ref.getType());
                    visitor.setShortArg(1, newRef.getIndex());
                    this._isEnhanced = true;
                }
            }
        }
    }

    private static class InitAnalyzer
    extends Analyzer {
        int _offset = -1;

        private InitAnalyzer() {
        }

        public int getOffset() {
            return this._offset;
        }

        public void analyze(CodeVisitor visitor) throws Exception {
            if (this._offset >= 0) {
                return;
            }
            switch (visitor.getOpcode()) {
                case 183: {
                    JavaClass javaClass = visitor.getJavaClass();
                    ConstantPool cp = javaClass.getConstantPool();
                    MethodRefConstant ref = cp.getMethodRef(visitor.getShortArg());
                    if (!ref.getName().equals("<init>") || !ref.getClassName().equals(javaClass.getThisClass()) && !ref.getClassName().equals(javaClass.getSuperClassName())) break;
                    this._offset = visitor.getOffset() + 3;
                }
            }
        }
    }
}

