/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.SimpleLoader;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.File;
import java.net.URLClassLoader;

public class SystemClassLoader
extends EnvironmentClassLoader
implements EnvironmentBean {
    private boolean _isInit;
    private URLClassLoader _loader;

    public SystemClassLoader(ClassLoader parent) {
        super(parent);
    }

    public ClassLoader getClassLoader() {
        return this;
    }

    public void init() {
        if (this._isInit) {
            return;
        }
        this._isInit = true;
        this.initClasspath();
        super.init();
        String systemConf = System.getProperty("system.conf");
        if (systemConf != null) {
            try {
                Path path = Vfs.lookup(systemConf);
                Config config = new Config();
                config.configure((Object)this, path, this.getSchema());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex.toString());
            }
        }
    }

    private void initClasspath() {
        String[] classpathElements;
        String classpath = System.getProperty("java.class.path");
        String[] arr$ = classpathElements = classpath.split(File.pathSeparator, 512);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String classpathElement = arr$[i$];
            SimpleLoader loader = new SimpleLoader(Vfs.lookup(classpathElement));
            try {
                loader.init();
                this.addLoader(loader);
                continue;
            }
            catch (ConfigException ex) {
                System.err.println(new CharBuffer().append("bad classpath elenent ").append(classpathElement).toString());
                ex.printStackTrace();
            }
        }
    }

    protected String getSchema() {
        return "com/caucho/loader/system.rnc";
    }
}

