/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.config.ConfigException;
import com.caucho.loader.ClassEntry;
import com.caucho.loader.ClassPackage;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.JarEntry;
import com.caucho.loader.Loader;
import com.caucho.log.Log;
import com.caucho.make.Dependency;
import com.caucho.make.DependencyContainer;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.Depend;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarLoader
extends Loader
implements Dependency {
    private static final Logger log = Log.open(JarLoader._resin_compat_class_0());
    private ArrayList<JarEntry> _jarList = new ArrayList();
    private DependencyContainer _dependencyList = new DependencyContainer();
    private static Class _resin_compat_class_0;

    public void init() {
    }

    @Override
    public void setLoader(DynamicClassLoader loader) {
        super.setLoader(loader);
        for (int i = 0; i < this._jarList.size(); ++i) {
            loader.addURL(this._jarList.get(i).getJarPath());
        }
    }

    @Override
    public void validate() throws ConfigException {
        for (int i = 0; i < this._jarList.size(); ++i) {
            this._jarList.get(i).validate();
        }
    }

    @Override
    public boolean isModified() {
        return this._dependencyList.isModified();
    }

    public void addJar(Path jar) {
        JarPath jarPath = JarPath.create(jar);
        JarEntry jarEntry = new JarEntry(jarPath);
        if (this._jarList.contains(jarEntry)) {
            return;
        }
        this._jarList.add(jarEntry);
        this._dependencyList.add(new Depend(jarPath));
        if (this.getLoader() != null) {
            this.getLoader().addURL(jarPath);
        }
    }

    @Override
    protected String getClassPath(String head) {
        CharBuffer cb = new CharBuffer();
        cb.append(head);
        for (int i = 0; i < this._jarList.size(); ++i) {
            JarEntry jarEntry = this._jarList.get(i);
            JarPath jar = jarEntry.getJarPath();
            if (cb.length() > 0) {
                cb.append(CauchoSystem.getPathSeparatorChar());
            }
            cb.append(jar.getContainer().getNativePath());
        }
        return cb.close();
    }

    @Override
    protected ClassEntry getClassEntry(String name) throws ClassNotFoundException {
        String pathName = name.replace('.', '/');
        String pkg = "";
        int p = pathName.lastIndexOf(47);
        if (p > 0) {
            pkg = pathName.substring(0, p + 1);
        }
        pathName = new CharBuffer().append(pathName).append(".class").toString();
        Object classPath = null;
        for (int i = 0; i < this._jarList.size(); ++i) {
            JarEntry jarEntry = this._jarList.get(i);
            JarPath path = jarEntry.getJarPath();
            Path filePath = path.lookup(pathName);
            if (!filePath.canRead() || filePath.getLength() <= 0L) continue;
            ClassEntry entry = new ClassEntry(this.getLoader(), name, filePath, filePath, this.getCodeSource(filePath));
            ClassPackage classPackage = jarEntry.getPackage(pkg);
            entry.setClassPackage(classPackage);
            return entry;
        }
        return null;
    }

    @Override
    public void getResources(Vector<URL> vector, String name) {
        for (int i = 0; i < this._jarList.size(); ++i) {
            JarEntry jarEntry = this._jarList.get(i);
            Path path = jarEntry.getJarPath();
            if (!(path = path.lookup(name)).canRead()) continue;
            try {
                vector.add(new URL(path.getURL()));
                continue;
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    @Override
    public Path getPath(String pathName) {
        for (int i = 0; i < this._jarList.size(); ++i) {
            JarEntry jarEntry = this._jarList.get(i);
            JarPath path = jarEntry.getJarPath();
            Path filePath = path.lookup(pathName);
            if (!filePath.canRead()) continue;
            return filePath;
        }
        return null;
    }

    public Path getCodePath() {
        return null;
    }

    public String toString() {
        return "JarLoader[]";
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.loader.JarLoader");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

