/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.jca.UserTransactionProxy;
import com.caucho.jmx.Jmx;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentListener;
import com.caucho.loader.EnvironmentProperties;
import com.caucho.loader.StartRuntimeException;
import com.caucho.loader.WeakStopListener;
import com.caucho.naming.Jndi;
import com.caucho.security.PolicyImpl;
import com.caucho.transaction.TransactionManagerImpl;
import com.caucho.util.CharBuffer;
import com.caucho.util.ThreadPool;
import com.caucho.vfs.EnvironmentStream;
import com.caucho.vfs.SchemeMap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import javax.management.MBeanServerFactory;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentClassLoader
extends DynamicClassLoader {
    private static boolean _isStaticInit;
    private EnvironmentBean _owner;
    private Hashtable<String, Object> _attributes = new Hashtable(8);
    private ArrayList<EnvironmentListener> _listeners;
    private WeakStopListener _stopListener;
    private volatile boolean _isStarted;
    private volatile boolean _isActive;
    private volatile boolean _isStopped;

    public EnvironmentClassLoader() {
        super(Thread.currentThread().getContextClassLoader());
        this.initListeners();
    }

    public EnvironmentClassLoader(ClassLoader parent) {
        super(parent);
        this.initListeners();
    }

    public EnvironmentBean getOwner() {
        return this._owner;
    }

    public void setOwner(EnvironmentBean owner) {
        this._owner = owner;
    }

    public boolean isActive() {
        return this._isActive;
    }

    @Override
    public void init() {
        EnvironmentClassLoader.initializeEnvironment();
        super.init();
    }

    public Object getAttribute(String name) {
        if (this._attributes != null) {
            return this._attributes.get(name);
        }
        return null;
    }

    public Object setAttribute(String name, Object obj) {
        if (obj == null) {
            if (this._attributes == null) {
                return null;
            }
            return this._attributes.remove(name);
        }
        if (this._attributes == null) {
            this._attributes = new Hashtable(8);
        }
        return this._attributes.put(name, obj);
    }

    public Object removeAttribute(String name) {
        if (this._attributes == null) {
            return null;
        }
        return this._attributes.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(EnvironmentListener listener) {
        Object object = this;
        synchronized (object) {
            if (this._listeners == null) {
                this._listeners = new ArrayList();
                this.initListeners();
            }
        }
        object = this._listeners;
        synchronized (object) {
            for (int i = this._listeners.size() - 1; i >= 0; --i) {
                EnvironmentListener oldListener = this._listeners.get(i);
                if (listener == oldListener) {
                    return;
                }
                if (oldListener != null) continue;
                this._listeners.remove(i);
            }
            this._listeners.add(listener);
        }
        if (this._isStarted) {
            try {
                listener.environmentStart(this);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new StartRuntimeException(e);
            }
        }
    }

    private void initListeners() {
        for (ClassLoader parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof EnvironmentClassLoader)) continue;
            EnvironmentClassLoader loader = (EnvironmentClassLoader)parent;
            this._stopListener = new WeakStopListener(this);
            loader.addListener(this._stopListener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(EnvironmentListener listener) {
        if (this._listeners == null) {
            return;
        }
        ArrayList<EnvironmentListener> arrayList = this._listeners;
        synchronized (arrayList) {
            for (int i = this._listeners.size() - 1; i >= 0; --i) {
                EnvironmentListener oldListener = this._listeners.get(i);
                if (listener == oldListener) {
                    this._listeners.remove(i);
                    return;
                }
                if (oldListener != null) continue;
                this._listeners.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<EnvironmentListener> getEnvironmentListeners() {
        ArrayList<EnvironmentListener> listeners = new ArrayList<EnvironmentListener>();
        if (this._listeners == null) {
            return listeners;
        }
        ArrayList<EnvironmentListener> arrayList = this._listeners;
        synchronized (arrayList) {
            for (int i = 0; i < this._listeners.size(); ++i) {
                EnvironmentListener listener = this._listeners.get(i);
                if (listener != null) {
                    listeners.add(listener);
                    continue;
                }
                this._listeners.remove(i);
                --i;
            }
        }
        return listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        EnvironmentClassLoader environmentClassLoader = this;
        synchronized (environmentClassLoader) {
            if (this._isStarted) {
                return;
            }
            this._isStarted = true;
        }
        try {
            ArrayList<EnvironmentListener> listeners = this.getEnvironmentListeners();
            int size = listeners.size();
            for (int i = 0; listeners != null && i < size; ++i) {
                EnvironmentListener listener = listeners.get(i);
                listener.environmentStart(this);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new StartRuntimeException(e);
        }
        finally {
            this._isActive = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        EnvironmentClassLoader environmentClassLoader = this;
        synchronized (environmentClassLoader) {
            if (this._isStopped) {
                return;
            }
            this._isStopped = true;
            this._isActive = false;
        }
        ArrayList<EnvironmentListener> listeners = this.getEnvironmentListeners();
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this);
        try {
            if (listeners != null) {
                for (int i = listeners.size() - 1; i >= 0; --i) {
                    EnvironmentListener listener = listeners.get(i);
                    try {
                        listener.environmentStop(this);
                        continue;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        EnvironmentClassLoader.log().log(Level.WARNING, e.toString(), e);
                    }
                }
            }
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    protected void replace(EnvironmentClassLoader source) {
        super.replace(source);
        this._owner = source._owner;
        this._attributes = source._attributes;
        if (source._listeners != null) {
            if (this._listeners == null) {
                this._listeners = new ArrayList();
            }
            this._listeners.addAll(source._listeners);
            source._listeners.clear();
        }
        this._isStarted = source._isStarted;
        this._isActive = source._isActive;
        this._isStopped = source._isStopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        try {
            this.stop();
            super.destroy();
            for (ClassLoader parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof EnvironmentClassLoader)) continue;
                EnvironmentClassLoader loader = (EnvironmentClassLoader)parent;
                loader.removeListener(this._stopListener);
            }
        }
        finally {
            this._owner = null;
            this._attributes = null;
            this._listeners = null;
            ThreadPool.reset();
        }
    }

    @Override
    public String toString() {
        if (this.getId() != null) {
            return new CharBuffer().append("EnvironmentClassLoader$").append(System.identityHashCode(this)).append("[").append(this.getId()).append("]").toString();
        }
        return new CharBuffer().append("EnvironmentClassLoader$").append(System.identityHashCode(this)).append(this.getLoaders()).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void initializeEnvironment() {
        if (_isStaticInit) {
            return;
        }
        _isStaticInit = true;
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            Properties props;
            thread.setContextClassLoader(ClassLoader.getSystemClassLoader());
            ClassLoader loader = thread.getContextClassLoader();
            PolicyImpl.init();
            EnvironmentStream.setStdout(System.out);
            EnvironmentStream.setStderr(System.err);
            try {
                SchemeMap.initJNI();
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (System.getProperty("org.xml.sax.driver") == null) {
                System.setProperty("org.xml.sax.driver", "com.caucho.xml.Xml");
            }
            if ((props = System.getProperties()).get("java.util.logging.manager") == null) {
                props.put("java.util.logging.manager", "com.caucho.log.LogManagerImpl");
            }
            if (props.get("java.naming.factory.initial") == null) {
                props.put("java.naming.factory.initial", "com.caucho.naming.InitialContextFactoryImpl");
            }
            props.put("java.naming.factory.url.pkgs", "com.caucho.naming");
            EnvironmentProperties contextProps = new EnvironmentProperties(props);
            System.setProperties(contextProps);
            TransactionManagerImpl tm = TransactionManagerImpl.getInstance();
            Jndi.bindDeep("java:comp/TransactionManager", tm);
            UserTransactionProxy ut = UserTransactionProxy.getInstance();
            Jndi.bindDeep("java:comp/UserTransaction", ut);
            String oldBuilder = props.getProperty("javax.management.builder.initial");
            if (oldBuilder == null) {
                oldBuilder = "com.caucho.jmx.MBeanServerBuilderImpl";
            }
            props.put("javax.management.builder.initial", oldBuilder);
            if (MBeanServerFactory.findMBeanServer(null).size() == 0) {
                MBeanServerFactory.createMBeanServer("Resin");
            }
            try {
                Class<?> cl = Class.forName("java.lang.management.ManagementFactory");
                Method method = cl.getMethod("getPlatformMBeanServer", new Class[0]);
                method.invoke(null, new Object[0]);
            }
            catch (Throwable e) {
                // empty catch block
            }
            Jndi.bindDeep("java:comp/env/jmx/MBeanServer", Jmx.getContextMBeanServer());
            Jndi.bindDeep("java:comp/env/jmx/GlobalMBeanServer", Jmx.getGlobalMBeanServer());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }
}

