/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.config.ConfigException;
import com.caucho.loader.ClassEntry;
import com.caucho.loader.ClassPackage;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.JarEntry;
import com.caucho.loader.Loader;
import com.caucho.log.Log;
import com.caucho.make.Dependency;
import com.caucho.make.DependencyContainer;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryLoader
extends Loader
implements Dependency {
    private static final Logger log = Log.open(DirectoryLoader._resin_compat_class_0());
    private Path _dir;
    private long _lastModified;
    private String[] _fileNames;
    private ArrayList<JarEntry> _jarList;
    private DependencyContainer _dependencyList = new DependencyContainer();
    private static Class _resin_compat_class_0;

    public DirectoryLoader() {
    }

    public DirectoryLoader(Path dir) {
        this._dir = dir;
        this.init();
    }

    public void setPath(Path path) {
        this._dir = path;
    }

    public Path getPath() {
        return this._dir;
    }

    public static DynamicClassLoader create(ClassLoader parent, Path dir) {
        DynamicClassLoader loader = new DynamicClassLoader(parent);
        DirectoryLoader dirLoader = new DirectoryLoader(dir);
        loader.addLoader(dirLoader);
        loader.init();
        return loader;
    }

    public void init() {
        this._lastModified = this._dir.getLastModified();
        try {
            this._fileNames = this._dir.list();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._jarList = new ArrayList();
        this._dependencyList = new DependencyContainer();
        this.fillJars();
    }

    @Override
    public void setLoader(DynamicClassLoader loader) {
        super.setLoader(loader);
        for (int i = 0; i < this._jarList.size(); ++i) {
            loader.addURL(this._jarList.get(i).getJarPath());
        }
    }

    @Override
    public void validate() throws ConfigException {
        for (int i = 0; i < this._jarList.size(); ++i) {
            this._jarList.get(i).validate();
        }
    }

    @Override
    public boolean isModified() {
        if (this._lastModified < this._dir.getLastModified()) {
            return true;
        }
        String[] list = null;
        try {
            list = this._dir.list();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (this._fileNames.length != list.length || this._fileNames == null != (list == null)) {
            return true;
        }
        if (this._fileNames != null) {
            for (int i = 0; i < this._fileNames.length; ++i) {
                if (this._fileNames[i].equals(list[i])) continue;
                return true;
            }
        }
        return this._dependencyList.isModified();
    }

    private void fillJars() {
        this._jarList.clear();
        String[] list = null;
        try {
            list = this._dir.list();
        }
        catch (IOException e) {
            // empty catch block
        }
        for (int j = 0; list != null && j < list.length; ++j) {
            if (!list[j].endsWith(".jar") && !list[j].endsWith(".zip")) continue;
            Path jar = this._dir.lookup(list[j]);
            this.addJar(jar);
        }
    }

    private void addJar(Path jar) {
        JarPath jarPath = JarPath.create(jar);
        JarEntry jarEntry = new JarEntry(jarPath);
        if (this._jarList.contains(jarEntry)) {
            return;
        }
        this._jarList.add(jarEntry);
        this._dependencyList.add(jarPath.getDepend());
        if (this.getLoader() != null) {
            this.getLoader().addURL(jarPath);
        }
    }

    @Override
    protected String getClassPath(String head) {
        CharBuffer cb = new CharBuffer();
        cb.append(head);
        for (int i = 0; i < this._jarList.size(); ++i) {
            JarEntry jarEntry = this._jarList.get(i);
            JarPath jar = jarEntry.getJarPath();
            if (cb.length() > 0) {
                cb.append(CauchoSystem.getPathSeparatorChar());
            }
            cb.append(jar.getContainer().getNativePath());
        }
        return cb.close();
    }

    @Override
    protected ClassEntry getClassEntry(String name) throws ClassNotFoundException {
        String pathName = name.replace('.', '/');
        String pkg = "";
        int p = pathName.lastIndexOf(47);
        if (p > 0) {
            pkg = pathName.substring(0, p + 1);
        }
        pathName = new CharBuffer().append(pathName).append(".class").toString();
        Object classPath = null;
        for (int i = 0; i < this._jarList.size(); ++i) {
            JarEntry jarEntry = this._jarList.get(i);
            JarPath path = jarEntry.getJarPath();
            Path filePath = path.lookup(pathName);
            if (!filePath.canRead() || filePath.getLength() <= 0L) continue;
            ClassEntry entry = new ClassEntry(this.getLoader(), name, filePath, filePath, jarEntry.getCodeSource());
            ClassPackage classPackage = jarEntry.getPackage(pkg);
            entry.setClassPackage(classPackage);
            return entry;
        }
        return null;
    }

    @Override
    public void getResources(Vector<URL> vector, String name) {
        for (int i = 0; i < this._jarList.size(); ++i) {
            JarEntry jarEntry = this._jarList.get(i);
            Path path = jarEntry.getJarPath();
            if (!(path = path.lookup(name)).canRead()) continue;
            try {
                vector.add(new URL(path.getURL()));
                continue;
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    @Override
    public Path getPath(String pathName) {
        for (int i = 0; i < this._jarList.size(); ++i) {
            JarEntry jarEntry = this._jarList.get(i);
            JarPath path = jarEntry.getJarPath();
            Path filePath = path.lookup(pathName);
            if (!filePath.exists()) continue;
            return filePath;
        }
        return null;
    }

    public Path getCodePath() {
        return this._dir;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectoryLoader loader = (DirectoryLoader)o;
        return this._dir.equals(loader._dir);
    }

    public String toString() {
        return new CharBuffer().append("DirectoryLoader[").append(this._dir).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.loader.DirectoryLoader");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

