/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.lifecycle;

import com.caucho.lifecycle.LifecycleListener;
import com.caucho.lifecycle.LifecycleState;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Lifecycle
implements LifecycleState {
    private final Logger _log;
    private String _name;
    private Level _level = Level.FINE;
    private int _state;
    private ArrayList<WeakReference<LifecycleListener>> _listeners;
    private static Class _resin_compat_class_0;

    public Lifecycle() {
        this._log = null;
    }

    public Lifecycle(Logger log) {
        this._log = log;
    }

    public Lifecycle(Logger log, String name) {
        this._log = log;
        this._name = name;
    }

    public Lifecycle(Logger log, String name, Level level) {
        this._log = log;
        this._name = name;
        this._level = level;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public Level getLevel() {
        return this._level;
    }

    public void setLevel(Level level) {
        this._level = level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(LifecycleListener listener) {
        Lifecycle lifecycle = this;
        synchronized (lifecycle) {
            if (this.isDestroyed()) {
                IllegalStateException e = new IllegalStateException(new CharBuffer().append("attempted to add listener to a destroyed lifecyle ").append(this).toString());
                if (this._log != null) {
                    this._log.log(Level.WARNING, e.toString(), e);
                } else {
                    Logger.getLogger(Lifecycle._resin_compat_class_0().getName()).log(Level.WARNING, e.toString(), e);
                }
                return;
            }
            if (this._listeners == null) {
                this._listeners = new ArrayList();
            }
            for (int i = this._listeners.size() - 1; i >= 0; --i) {
                LifecycleListener oldListener = (LifecycleListener)this._listeners.get(i).get();
                if (listener == oldListener) {
                    return;
                }
                if (oldListener != null) continue;
                this._listeners.remove(i);
            }
            this._listeners.add(new WeakReference<LifecycleListener>(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(LifecycleListener listener) {
        Lifecycle lifecycle = this;
        synchronized (lifecycle) {
            if (this._listeners == null) {
                return;
            }
            for (int i = this._listeners.size() - 1; i >= 0; --i) {
                LifecycleListener oldListener = (LifecycleListener)this._listeners.get(i).get();
                if (listener == oldListener) {
                    this._listeners.remove(i);
                    return;
                }
                if (oldListener != null) continue;
                this._listeners.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(int oldState, int newState) {
        Lifecycle lifecycle = this;
        synchronized (lifecycle) {
            if (this._listeners == null) {
                return;
            }
            for (int i = 0; i < this._listeners.size(); ++i) {
                LifecycleListener listener = (LifecycleListener)this._listeners.get(i).get();
                if (listener != null) {
                    listener.lifecycleEvent(oldState, newState);
                    continue;
                }
                this._listeners.remove(i);
                --i;
            }
        }
    }

    public int getState() {
        return this._state;
    }

    public static String getStateName(int state) {
        switch (state) {
            case 0: {
                return "new";
            }
            case 1: {
                return "initializing";
            }
            case 2: {
                return "init";
            }
            case 3: {
                return "starting";
            }
            case 5: {
                return "error";
            }
            case 4: {
                return "active";
            }
            case 6: {
                return "stopping";
            }
            case 7: {
                return "stopped";
            }
            case 8: {
                return "destroying";
            }
            case 9: {
                return "destroyed";
            }
        }
        return "unknown";
    }

    public String getStateName() {
        return Lifecycle.getStateName(this._state);
    }

    public boolean isInitializing() {
        return this._state == 1;
    }

    public boolean isInit() {
        return this._state == 2;
    }

    public boolean isBeforeInit() {
        return this._state < 2;
    }

    public boolean isAfterInit() {
        return this._state >= 2;
    }

    public boolean isStarting() {
        return this._state == 3;
    }

    public boolean isBeforeActive() {
        return this._state < 4;
    }

    public boolean isAfterActive() {
        return 4 < this._state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForActive(long timeout) {
        if (this._state == 4) {
            return true;
        }
        long waitEnd = Alarm.getCurrentTime() + timeout;
        Lifecycle lifecycle = this;
        synchronized (lifecycle) {
            while (Alarm.getCurrentTime() < waitEnd) {
                if (this._state == 4) {
                    return true;
                }
                if (4 < this._state) {
                    return false;
                }
                if (Alarm.isTest()) {
                    return false;
                }
                try {
                    this.wait(waitEnd - Alarm.getCurrentTime());
                }
                catch (InterruptedException e) {}
            }
        }
        return this._state == 4;
    }

    public boolean isActive() {
        return this._state == 4;
    }

    public boolean isError() {
        return this._state == 5;
    }

    public boolean isStopped() {
        return 6 <= this._state;
    }

    public boolean isDestroyed() {
        return 8 <= this._state;
    }

    public synchronized boolean toInitializing() {
        if (1 <= this._state) {
            return false;
        }
        int oldState = this._state;
        this._state = 1;
        if (this._log != null && this._log.isLoggable(Level.FINE)) {
            this._log.fine(new CharBuffer().append(this._name).append(" initializing").toString());
        }
        this.notifyListeners(oldState, this._state);
        return true;
    }

    public synchronized boolean toInit() {
        if (2 <= this._state) {
            return false;
        }
        int oldState = this._state;
        this._state = 2;
        if (this._log != null && this._log.isLoggable(Level.FINE)) {
            this._log.fine(new CharBuffer().append(this._name).append(" initialized").toString());
        }
        this.notifyListeners(oldState, this._state);
        return true;
    }

    public synchronized boolean toPostInit() {
        if (7 == this._state) {
            int oldState = this._state;
            this._state = 2;
            this.notifyListeners(oldState, this._state);
            return true;
        }
        return 2 == this._state;
    }

    public synchronized boolean toStarting() {
        if (this._state < 3 || this._state == 7) {
            int oldState = this._state;
            this._state = 3;
            if (this._log != null && this._log.isLoggable(this._level)) {
                this._log.log(this._level, new CharBuffer().append(this._name).append(" starting").toString());
            }
            this.notifyListeners(oldState, this._state);
            return true;
        }
        return false;
    }

    public synchronized boolean toActive() {
        if (this._state < 4 || this._state == 7) {
            int oldState = this._state;
            this._state = 4;
            if (this._log != null && this._log.isLoggable(Level.FINE)) {
                this._log.fine(new CharBuffer().append(this._name).append(" active").toString());
            }
            this.notifyListeners(oldState, this._state);
            this.notifyAll();
            return true;
        }
        return false;
    }

    public synchronized boolean toError() {
        if (this._state < 8 && this._state != 5) {
            int oldState = this._state;
            this._state = 5;
            if (this._log != null && this._log.isLoggable(this._level)) {
                this._log.log(this._level, new CharBuffer().append(this._name).append(" error").toString());
            }
            this.notifyListeners(oldState, this._state);
            this.notifyAll();
            return true;
        }
        return false;
    }

    public synchronized boolean toStopping() {
        if (this._state < 6 && this._state != 3) {
            int oldState = this._state;
            this._state = 6;
            if (this._log != null && this._log.isLoggable(this._level)) {
                this._log.log(this._level, new CharBuffer().append(this._name).append(" stopping").toString());
            }
            this.notifyListeners(oldState, this._state);
            return true;
        }
        return false;
    }

    public synchronized boolean toStop() {
        if (this._state < 7) {
            if (this._log != null) {
                if (this._state < 6 && this._log.isLoggable(this._level)) {
                    this._log.log(this._level, new CharBuffer().append(this._name).append(" stopped").toString());
                } else if (this._log.isLoggable(Level.FINE)) {
                    this._log.fine(new CharBuffer().append(this._name).append(" stopped").toString());
                }
            }
            int oldState = this._state;
            this._state = 7;
            this.notifyListeners(oldState, this._state);
            this.notifyAll();
            return true;
        }
        return false;
    }

    public synchronized boolean toDestroying() {
        if (this._state < 8) {
            int oldState = this._state;
            this._state = 8;
            if (this._log != null && this._log.isLoggable(Level.FINE)) {
                this._log.fine(new CharBuffer().append(this._name).append(" destroying").toString());
            }
            this.notifyListeners(oldState, this._state);
            return true;
        }
        return false;
    }

    public synchronized boolean toDestroy() {
        if (this._state < 9) {
            int oldState = this._state;
            this._state = 9;
            if (this._log != null && this._log.isLoggable(Level.FINE)) {
                this._log.fine(new CharBuffer().append(this._name).append(" destroyed").toString());
            }
            this.notifyListeners(oldState, this._state);
            this.notifyAll();
            return true;
        }
        return false;
    }

    public void copyState(Lifecycle source) {
        this._state = source._state;
    }

    public String toString() {
        if (this._name != null) {
            return new CharBuffer().append("Lifecycle[").append(this._name).append(", ").append(this.getStateName()).append("]").toString();
        }
        return new CharBuffer().append("Lifecycle[").append(this.getStateName()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.lifecycle.Lifecycle");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

