/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.rt;

import com.caucho.jsp.PageContextImpl;
import com.caucho.jstl.rt.CoreSetTag;
import com.caucho.jstl.rt.SqlQueryTag;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.jstl.sql.SQLExecutionTag;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.sql.DataSource;

public class SqlUpdateTag
extends BodyTagSupport
implements SQLExecutionTag {
    private static final Logger log = Log.open(SqlUpdateTag._resin_compat_class_0());
    private static final L10N L = new L10N(SqlUpdateTag._resin_compat_class_0());
    private String _sql;
    private String _var;
    private String _scope;
    private Object _dataSource;
    private ArrayList<Object> _params;
    private static Class _resin_compat_class_0;

    public void setSql(String sql) {
        this._sql = sql;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public void setScope(String scope) {
        this._scope = scope;
    }

    public void setDataSource(Object dataSource) {
        this._dataSource = dataSource;
    }

    public void addSQLParameter(Object value) {
        if (this._params == null) {
            this._params = new ArrayList();
        }
        this._params.add(value);
    }

    public int doEndTag() throws JspException {
        Connection conn = null;
        boolean isTransaction = false;
        PageContextImpl pageContext = (PageContextImpl)this.pageContext;
        try {
            Statement stmt;
            String sql = this._sql != null ? this._sql : this.bodyContent.getString();
            conn = (Connection)pageContext.getAttribute("caucho.jstl.sql.conn");
            if (conn != null) {
                isTransaction = true;
            }
            if (!isTransaction) {
                DataSource ds = this._dataSource != null ? SqlQueryTag.getDataSource(pageContext, this._dataSource) : SqlQueryTag.getDataSource(pageContext, null);
                conn = ds.getConnection();
            }
            Object value = null;
            ArrayList<Object> params = this._params;
            this._params = null;
            int rows = 0;
            if (params == null) {
                stmt = conn.createStatement();
                rows = stmt.executeUpdate(sql);
            } else {
                PreparedStatement pstmt = conn.prepareStatement(sql);
                stmt = pstmt;
                for (int i = 0; i < params.size(); ++i) {
                    Object paramValue = params.get(i);
                    if (paramValue == null) {
                        pstmt.setNull(i + 1, 12);
                        continue;
                    }
                    pstmt.setObject(i + 1, paramValue);
                }
                rows = pstmt.executeUpdate();
            }
            stmt.close();
            CoreSetTag.setValue(pageContext, this._var, this._scope, new Integer(rows));
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
        finally {
            if (!isTransaction && conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
        }
        return 6;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jstl.rt.SqlUpdateTag");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

