/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.el;

import com.caucho.el.Expr;
import com.caucho.jstl.el.CoreSetTag;
import com.caucho.jstl.el.SqlQueryTag;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.el.VariableResolver;
import javax.servlet.jsp.tagext.TagSupport;
import javax.sql.DataSource;

public class SqlSetDataSourceTag
extends TagSupport {
    private static final Logger log = Log.open(SqlSetDataSourceTag._resin_compat_class_0());
    private static final L10N L = new L10N(SqlSetDataSourceTag._resin_compat_class_0());
    private Expr _dataSource;
    private Expr _url;
    private Expr _driver;
    private Expr _user;
    private Expr _password;
    private String _var;
    private String _scope;
    private static Class _resin_compat_class_0;

    public void setDataSource(Expr dataSource) {
        this._dataSource = dataSource;
    }

    public void setUrl(Expr url) {
        this._url = url;
    }

    public void setDriver(Expr driver) {
        this._driver = driver;
    }

    public void setUser(Expr user) {
        this._user = user;
    }

    public void setPassword(Expr password) {
        this._password = password;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public void setScope(String scope) {
        this._scope = scope;
    }

    public int doStartTag() throws JspException {
        try {
            String var = this._var;
            if (var == null) {
                var = "javax.servlet.jsp.jstl.sql.dataSource";
            }
            VariableResolver env = (VariableResolver)this.pageContext;
            DataSource dataSource = null;
            if (this._dataSource != null) {
                Object ds = this._dataSource.evalObject(env);
                dataSource = SqlQueryTag.getDataSource(this.pageContext, ds);
            } else {
                dataSource = SqlSetDataSourceTag.openDataSource(this._driver.evalString(env), this._url.evalString(env), this._user != null ? this._user.evalString(env) : null, this._password != null ? this._password.evalString(env) : null);
            }
            CoreSetTag.setValue(this.pageContext, var, this._scope, dataSource);
            return 0;
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
    }

    public static DataSource openDataSource(String driverClass, String url, String user, String password) throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> cl = Class.forName(driverClass, false, loader);
        Driver driver = (Driver)cl.newInstance();
        return new DataSourceAdapter(driver, url, user, password);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jstl.el.SqlSetDataSourceTag");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static class DataSourceAdapter
    implements DataSource {
        private Driver _driver;
        private String _url;
        private String _user;
        private String _password;

        public DataSourceAdapter(Driver driver, String url, String user, String password) {
            this._driver = driver;
            this._url = url;
            this._user = user;
            this._password = password;
        }

        public Connection getConnection(String user, String password) throws SQLException {
            Properties props = new Properties();
            props.put("user", user);
            props.put("password", user);
            return this._driver.connect(this._url, props);
        }

        public Connection getConnection() throws SQLException {
            Properties props = new Properties();
            if (this._user != null) {
                props.put("user", this._user);
            }
            if (this._password != null) {
                props.put("password", this._password);
            }
            return this._driver.connect(this._url, props);
        }

        public void setLogWriter(PrintWriter out) {
        }

        public PrintWriter getLogWriter() {
            return null;
        }

        public void setLoginTimeout(int timeout) {
        }

        public int getLoginTimeout() {
            return -1;
        }
    }
}

