/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp.java;

import com.caucho.java.JavaWriter;
import com.caucho.jsp.java.JavaJspGenerator;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;

public class JspJavaWriter
extends JavaWriter {
    private JavaJspGenerator _gen;
    private String _filename;
    private int _line = -1;
    private CharBuffer _cb = CharBuffer.allocate();

    public JspJavaWriter(WriteStream os, JavaJspGenerator gen) {
        super(os);
        this._gen = gen;
    }

    public void addText(String text) throws IOException {
        if (this._filename != null && this._cb.length() == 0) {
            super.setLocation(this._filename, this._line);
        }
        this._cb.append(text);
    }

    public void setLocation(String filename, int line) throws IOException {
        this._filename = filename;
        this._line = line;
    }

    protected void flushText() throws IOException {
        String filename = this._filename;
        int line = this._line;
        this._filename = null;
        if (this._cb.length() > 0) {
            int length = this._cb.length();
            this._cb.clear();
            this.generateText(this._cb.getBuffer(), 0, length);
        }
        if (filename != null) {
            super.setLocation(filename, line);
        }
    }

    private void generateText(char[] text, int offset, int length) throws IOException {
        if (length > 32000) {
            this.generateText(text, offset, 16384);
            this.generateText(text, offset + 16384, length - 16384);
            return;
        }
        if (length == 1) {
            char ch = text[offset];
            this.print("out.write('");
            switch (ch) {
                case '\\': {
                    this.print("\\\\");
                    break;
                }
                case '\'': {
                    this.print("\\'");
                    break;
                }
                case '\n': {
                    this.print("\\n");
                    break;
                }
                case '\r': {
                    this.print("\\r");
                    break;
                }
                default: {
                    this.print(ch);
                }
            }
            this.println("');");
        } else {
            int index = this._gen.addString(new String(text, offset, length));
            this.print(new CharBuffer().append("out.write(_jsp_string").append(index).append(", 0, ").toString());
            this.println(new CharBuffer().append("_jsp_string").append(index).append(".length);").toString());
        }
    }

    public void printJavaString(String s) throws IOException {
        this.flushText();
        super.printJavaString(s);
    }

    public void pushDepth() throws IOException {
        this.flushText();
        super.pushDepth();
    }

    public void popDepth() throws IOException {
        this.flushText();
        super.popDepth();
    }

    public void print(String s) throws IOException {
        this.flushText();
        super.print(s);
    }

    public void print(char ch) throws IOException {
        this.flushText();
        super.print(ch);
    }

    public void print(boolean b) throws IOException {
        this.flushText();
        super.print(b);
    }

    public void print(int i) throws IOException {
        this.flushText();
        super.print(i);
    }

    public void print(long l) throws IOException {
        this.flushText();
        super.print(l);
    }

    public void print(Object o) throws IOException {
        this.flushText();
        super.print(o);
    }

    public void println(String s) throws IOException {
        this.flushText();
        super.println(s);
    }

    public void println(boolean v) throws IOException {
        this.flushText();
        super.println(v);
    }

    public void println(char ch) throws IOException {
        this.flushText();
        super.println(ch);
    }

    public void println(int v) throws IOException {
        this.flushText();
        super.println(v);
    }

    public void println(long v) throws IOException {
        this.flushText();
        super.println(v);
    }

    public void println(Object v) throws IOException {
        this.flushText();
        super.println(v);
    }

    public void println() throws IOException {
        this.flushText();
        super.println();
    }
}

