/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp.java;

import com.caucho.jsp.JspParseException;
import com.caucho.jsp.cfg.TldAttribute;
import com.caucho.jsp.cfg.TldVariable;
import com.caucho.jsp.java.JavaTagGenerator;
import com.caucho.jsp.java.JspJavaWriter;
import com.caucho.jsp.java.JspNode;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.QName;
import java.io.IOException;
import java.util.ArrayList;

public class JspDirectiveVariable
extends JspNode {
    private static final QName NAME_GIVEN = new QName("name-given");
    private static final QName NAME_FROM_ATTRIBUTE = new QName("name-from-attribute");
    private static final QName ALIAS = new QName("alias");
    private static final QName VARIABLE_CLASS = new QName("variable-class");
    private static final QName DECLARE = new QName("declare");
    private static final QName SCOPE = new QName("scope");
    private static final QName DESCRIPTION = new QName("description");
    static final L10N L = new L10N(JspDirectiveVariable._resin_compat_class_1());
    private String _nameGiven;
    private String _nameFromAttribute;
    private String _alias;
    private String _variableClass;
    private boolean _isDeclare = true;
    private String _scope;
    private String _description;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    public void addAttribute(QName name, String value) throws JspParseException {
        if (NAME_GIVEN.equals(name)) {
            this._nameGiven = value;
        } else if (NAME_FROM_ATTRIBUTE.equals(name)) {
            this._nameFromAttribute = value;
        } else if (ALIAS.equals(name)) {
            this._alias = value;
        } else if (VARIABLE_CLASS.equals(name)) {
            this._variableClass = value;
        } else if (DECLARE.equals(name)) {
            this._isDeclare = this.attributeToBoolean(name.getName(), value);
        } else if (SCOPE.equals(name)) {
            if (!("NESTED".equals(value) || "AT_BEGIN".equals(value) || "AT_END".equals(value))) {
                throw this.error(L.l("`{0}' is an illegal scope value.  NESTED, AT_BEGIN, and AT_END are the only accepted values.", value));
            }
            this._scope = value;
        } else if (DESCRIPTION.equals(name)) {
            this._description = value;
        } else {
            throw this.error(L.l("`{0}' is an unknown JSP attribute directive attributes.  See the JSP documentation for a complete list of page directive attributes.", name.getName()));
        }
    }

    public void endElement() throws JspParseException {
        if (!this._gen.getParseState().isTag()) {
            throw this.error(L.l("`{0}' is only allowed in .tag files.  Variable directives are not allowed in normal JSP files.", this.getTagName()));
        }
        if (this._nameGiven == null && this._nameFromAttribute == null) {
            throw this.error(L.l("<{0}> needs a `name-given' or `name-from-attribute' attribute.", this.getTagName()));
        }
        if (this._nameFromAttribute != null && this._alias == null) {
            throw this.error(L.l("<{0}> needs an `alias' attribute.  name-from-attribute requires an alias attribute.", this.getTagName()));
        }
        JavaTagGenerator tagGen = (JavaTagGenerator)this._gen;
        TldVariable var = new TldVariable();
        var.setNameGiven(this._nameGiven);
        var.setNameFromAttribute(this._nameFromAttribute);
        var.setAlias(this._alias);
        String name = this._nameGiven;
        if (name == null) {
            name = this._nameFromAttribute;
        }
        if (this._variableClass != null) {
            var.setVariableClass(this._variableClass);
        }
        var.setDeclare(this._isDeclare);
        if (this._scope != null) {
            var.setScope(this._scope);
        }
        tagGen.addVariable(var);
    }

    public boolean isStatic() {
        return true;
    }

    public void printXml(WriteStream os) throws IOException {
        os.print("<jsp:directive.variable");
        if (this._nameGiven != null) {
            os.print(new CharBuffer().append(" name-given=\"").append(this._nameGiven).append("\"").toString());
        }
        if (this._nameFromAttribute != null) {
            os.print(new CharBuffer().append(" name-from-attribute=\"").append(this._nameFromAttribute).append("\"").toString());
        }
        if (this._variableClass != null) {
            os.print(new CharBuffer().append(" variable-class=\"").append(this._variableClass).append("\"").toString());
        }
        os.print("/>");
    }

    public void generatePrologue(JspJavaWriter out) throws Exception {
        JavaTagGenerator gen = (JavaTagGenerator)this._gen;
        if (this._nameFromAttribute == null) {
            return;
        }
        ArrayList<TldAttribute> attributes = gen.getAttributes();
        for (int i = 0; i < attributes.size(); ++i) {
            TldAttribute attr = attributes.get(i);
            if (!attr.getName().equals(this._nameFromAttribute)) continue;
            if (!JspDirectiveVariable._resin_compat_class_0().equals(attr.getType())) {
                throw this.error(L.l("name-from-attribute variable `{0}' needs a matching String attribute, not `{1}' .  name-from-attribute requires a matching String attribute.", (Object)this._nameFromAttribute, attr.getType().getName()));
            }
            return;
        }
        throw this.error(L.l("name-from-attribute variable `{0}' needs a matching String attribute.", this._nameFromAttribute));
    }

    public void generate(JspJavaWriter out) throws Exception {
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.lang.String");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.jsp.java.JspDirectiveVariable");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

