/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp.java;

import com.caucho.jsp.JspParseException;
import com.caucho.jsp.java.JavaTagGenerator;
import com.caucho.jsp.java.JspJavaWriter;
import com.caucho.jsp.java.JspNode;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.QName;
import java.io.IOException;

public class JspDirectiveTag
extends JspNode {
    private static final QName IS_EL_IGNORED = new QName("isELIgnored");
    private static final QName IS_VELOCITY_ENABLED = new QName("isVelocityEnabled");
    private static final QName PAGE_ENCODING = new QName("pageEncoding");
    private static final QName LANGUAGE = new QName("language");
    private static final QName IMPORT = new QName("import");
    private static final QName DISPLAY_NAME = new QName("display-name");
    private static final QName SMALL_ICON = new QName("small-icon");
    private static final QName LARGE_ICON = new QName("large-icon");
    private static final QName DESCRIPTION = new QName("description");
    private static final QName EXAMPLE = new QName("example");
    private static final QName DYNAMIC_ATTRIBUTES = new QName("dynamic-attributes");
    private static final QName BODY_CONTENT = new QName("body-content");
    static final L10N L = new L10N(JspDirectiveTag._resin_compat_class_0());
    private Boolean _isElIgnored;
    private static Class _resin_compat_class_0;

    public void addAttribute(QName name, String value) throws JspParseException {
        if (IS_EL_IGNORED.equals(name)) {
            boolean isIgnored = value.equals("true");
            this._parseState.setELIgnored(isIgnored);
            if (this._isElIgnored != null && this._isElIgnored != isIgnored) {
                throw this.error(L.l("isELIgnored values conflict"));
            }
            this._isElIgnored = new Boolean(isIgnored);
        } else if (IS_VELOCITY_ENABLED.equals(name)) {
            this._parseState.setVelocityEnabled(value.equals("true"));
        } else if (PAGE_ENCODING.equals(name)) {
            String oldEncoding = this._parseState.getPageEncoding();
            if (oldEncoding != null && !value.equals(oldEncoding)) {
                throw this.error(L.l("pageEncoding `{0}' conflicts with previous value of pageEncoding `{1}'.  Check the .jsp and any included .jsp files for conflicts.", (Object)value, oldEncoding));
            }
            this._parseState.setPageEncoding(value);
        } else if (LANGUAGE.equals(name)) {
            if (!value.equals("java")) {
                throw this.error(L.l("`{0}' is not supported as a JSP scripting language.", value));
            }
        } else if (IMPORT.equals(name)) {
            this._parseState.addImport(value);
        } else if (!(DISPLAY_NAME.equals(name) || SMALL_ICON.equals(name) || LARGE_ICON.equals(name) || DESCRIPTION.equals(name) || EXAMPLE.equals(name))) {
            if (DYNAMIC_ATTRIBUTES.equals(name)) {
                JavaTagGenerator gen = (JavaTagGenerator)this._gen;
                gen.setDynamicAttributes(value);
            } else if (BODY_CONTENT.equals(name)) {
                if (!(value.equals("scriptless") || value.equals("tagdependent") || value.equals("empty"))) {
                    throw this.error(L.l("`{0}' is an unknown body-content value for the JSP tag directive attribute.  'scriptless', 'tagdependent', and 'empty' are the allowed values.", value));
                }
                ((JavaTagGenerator)this._gen).setBodyContent(value);
            } else {
                throw this.error(L.l("`{0}' is an unknown JSP tag directive attribute.  See the JSP documentation for a complete list of tag directive attributes.", name.getName()));
            }
        }
    }

    protected String getRelativeUrl(String value) {
        if (value.length() > 0 && value.charAt(0) == '/') {
            return value;
        }
        return new CharBuffer().append(this._parseState.getUriPwd()).append(value).toString();
    }

    static String parseCharEncoding(String type) throws JspParseException {
        int i;
        type = type.toLowerCase();
        while ((i = type.indexOf(59)) >= 0 && i < type.length()) {
            char ch;
            ++i;
            while (i < type.length() && ((ch = type.charAt(i)) == ' ' || ch == '\t')) {
                ++i;
            }
            if (i >= type.length()) {
                return null;
            }
            if ((i = (type = type.substring(i)).indexOf(61)) >= 0) {
                if (!type.startsWith("charset")) continue;
                ++i;
                while (i < type.length() && ((ch = type.charAt(i)) == ' ' || ch == '\t')) {
                    ++i;
                }
                type = type.substring(i);
            }
            for (i = 0; i < type.length() && (ch = type.charAt(i)) != ';' && ch != ' '; ++i) {
            }
            return type.substring(0, i);
        }
        return null;
    }

    public void endAttributes() throws JspParseException {
        if (!this._gen.isTag()) {
            throw this.error(L.l("tag directive is only allowed in tag files."));
        }
    }

    public boolean isStatic() {
        return true;
    }

    public void printXml(WriteStream os) throws IOException {
        String dynAttr;
        JavaTagGenerator gen = (JavaTagGenerator)this._gen;
        os.print("<jsp:directive.tag");
        if (!this._parseState.isELIgnored()) {
            os.print(" el-ignored='false'");
        }
        if ((dynAttr = gen.getDynamicAttributes()) != null) {
            os.print(new CharBuffer().append("dynamic-attributes='").append(dynAttr).append("'").toString());
        }
        os.print("/>");
    }

    public void generate(JspJavaWriter out) throws Exception {
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jsp.java.JspDirectiveTag");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

