/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp.java;

import com.caucho.jsp.JspParseException;
import com.caucho.jsp.java.JspJavaWriter;
import com.caucho.jsp.java.JspNode;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.QName;
import java.io.IOException;
import java.util.ArrayList;

public class JspDirectivePage
extends JspNode {
    static L10N L = new L10N(JspDirectivePage._resin_compat_class_1());
    private static final QName IS_EL_IGNORED = new QName("isELIgnored");
    private static final QName IS_VELOCITY_ENABLED = new QName("isVelocityEnabled");
    private static final QName INFO = new QName("info");
    private static final QName CONTENT_TYPE = new QName("contentType");
    private static final QName PAGE_ENCODING = new QName("pageEncoding");
    private static final QName LANGUAGE = new QName("language");
    private static final QName IMPORT = new QName("import");
    private static final QName SESSION = new QName("session");
    private static final QName BUFFER = new QName("buffer");
    private static final QName ERROR_PAGE = new QName("errorPage");
    private static final QName IS_ERROR_PAGE = new QName("isErrorPage");
    private static final QName AUTO_FLUSH = new QName("autoFlush");
    private static final QName IS_THREAD_SAFE = new QName("isThreadSafe");
    private static final QName EXTENDS = new QName("extends");
    private Boolean _isElIgnored;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    public void addAttribute(QName name, String value) throws JspParseException {
        if (IS_EL_IGNORED.equals(name)) {
            boolean isIgnored = value.equals("true");
            this._parseState.setELIgnored(isIgnored);
            if (this._isElIgnored != null && this._isElIgnored != isIgnored) {
                throw this.error(L.l("isELIgnored values conflict"));
            }
            this._isElIgnored = new Boolean(isIgnored);
        } else if (IS_VELOCITY_ENABLED.equals(name)) {
            this._parseState.setVelocityEnabled(value.equals("true"));
        } else if (INFO.equals(name)) {
            String oldInfo = this._parseState.getInfo();
            if (oldInfo != null && !value.equals(oldInfo)) {
                throw this.error(L.l("info `{0}' conflicts with previous value of info `{1}'.  Check the .jsp and any included .jsp files for conflicts.", (Object)value, oldInfo));
            }
            this._parseState.setInfo(value);
        } else if (CONTENT_TYPE.equals(name)) {
            String oldContentType = this._parseState.getContentType();
            if (oldContentType != null && !value.equals(oldContentType)) {
                throw this.error(L.l("contentType `{0}' conflicts with previous value of contentType `{1}'.  Check the .jsp and any included .jsp files for conflicts.", (Object)value, oldContentType));
            }
            this._parseState.setContentType(value);
            String charEncoding = JspDirectivePage.parseCharEncoding(value);
            this._parseState.setCharEncoding(charEncoding);
        } else if (PAGE_ENCODING.equals(name)) {
            String oldEncoding = this._parseState.getPageEncoding();
            if (oldEncoding != null) {
                String oldCanonical = Encoding.getMimeName(oldEncoding);
                String newCanonical = Encoding.getMimeName(value);
                if (!newCanonical.equals(oldCanonical)) {
                    throw this.error(L.l("pageEncoding `{0}' conflicts with previous value of pageEncoding `{1}'.  Check the .jsp and any included .jsp files for conflicts.", (Object)value, oldEncoding));
                }
            }
            this._parseState.setPageEncoding(value);
        } else if (LANGUAGE.equals(name)) {
            if (!value.equals("java")) {
                throw this.error(L.l("`{0}' is not supported as a JSP scripting language.", value));
            }
        } else if (IMPORT.equals(name)) {
            this._parseState.addImport(value);
        } else if (SESSION.equals(name)) {
            boolean isValid = false;
            if (value.equals("true")) {
                isValid = this._parseState.setSession(true);
            } else if (value.equals("false")) {
                isValid = this._parseState.setSession(false);
            } else {
                throw this.error(L.l("session expects `true' or `false' at `{0}'", value));
            }
            this._parseState.markSessionSet();
            if (!isValid) {
                throw this.error(L.l("session is assigned different values."));
            }
        } else if (BUFFER.equals(name)) {
            boolean isValid = this._parseState.setBuffer(this.processBufferSize(value));
            this._parseState.markBufferSet();
            if (!isValid) {
                throw this.error(L.l("buffer is assigned different values."));
            }
            if (this._parseState.getBuffer() == 0 && !this._parseState.isAutoFlush()) {
                throw this.error(L.l("buffer must be non-zero when autoFlush is false."));
            }
        } else if (ERROR_PAGE.equals(name)) {
            String errorPage = this._parseState.getErrorPage();
            String newErrorPage = this.getRelativeUrl(value);
            this._parseState.setErrorPage(newErrorPage);
            if (errorPage != null && !errorPage.equals(newErrorPage)) {
                this._parseState.setErrorPage(null);
                throw this.error(L.l("errorPage is assigned different value '{0}'.", newErrorPage));
            }
        } else if (IS_ERROR_PAGE.equals(name)) {
            boolean isValid = false;
            if (value.equals("true")) {
                isValid = this._parseState.setErrorPage(true);
            } else if (value.equals("false")) {
                isValid = this._parseState.setErrorPage(false);
            } else {
                throw this.error(L.l("isErrorPage expects `true' or `false' at `{0}'", value));
            }
            this._parseState.markErrorPage();
            if (!isValid) {
                throw this.error(L.l("isErrorPage is assigned different values."));
            }
        } else if (AUTO_FLUSH.equals(name)) {
            boolean isValid = false;
            if (value.equals("true")) {
                isValid = this._parseState.setAutoFlush(true);
            } else if (value.equals("false")) {
                isValid = this._parseState.setAutoFlush(false);
            } else {
                throw this.error(L.l("autoFlush expects `true' or `false' at `{0}'", value));
            }
            if (!isValid) {
                throw this.error(L.l("autoFlush is assigned different values."));
            }
            if (this._parseState.getBuffer() == 0 && !this._parseState.isAutoFlush()) {
                throw this.error(L.l("buffer must be non-zero when autoFlush is false."));
            }
        } else if (IS_THREAD_SAFE.equals(name)) {
            boolean isValid = false;
            if (value.equals("true")) {
                isValid = this._parseState.setThreadSafe(true);
            } else if (value.equals("false")) {
                isValid = this._parseState.setThreadSafe(false);
            } else {
                throw this.error(L.l("isThreadSafe expects `true' or `false' at `{0}'", value));
            }
            this._parseState.markThreadSafeSet();
            if (!isValid) {
                throw this.error(L.l("isThreadSafe is assigned different values."));
            }
        } else if (EXTENDS.equals(name)) {
            Class cl = null;
            try {
                cl = CauchoSystem.loadClass(value);
            }
            catch (Exception e) {
                throw this.error(e);
            }
            if (!JspDirectivePage._resin_compat_class_0().isAssignableFrom(cl)) {
                throw this.error(L.l("`{0}' must implement HttpJspPage.  The class named by jsp:directive.page extends='...' must implement HttpJspPage.", value));
            }
            Class oldExtends = this._parseState.getExtends();
            if (oldExtends != null && !cl.equals(oldExtends)) {
                throw this.error(L.l("extends `{0}' conflicts with previous value of extends `{1}'.  Check the .jsp and any included .jsp files for conflicts.", (Object)value, oldExtends.getName()));
            }
            this._parseState.setExtends(cl);
        } else {
            throw this.error(L.l("`{0}' is an unknown JSP page directive attribute.  See the JSP documentation for a complete list of page directive attributes.", name.getName()));
        }
    }

    private int processBufferSize(String value) throws JspParseException {
        char ch;
        int i;
        if (value.equals("none")) {
            return 0;
        }
        int kb = 0;
        for (i = 0; i < value.length() && (ch = value.charAt(i)) >= '0' && ch <= '9'; ++i) {
            kb = 10 * kb + ch - 48;
        }
        if (!value.substring(i).equals("kb")) {
            throw this.error(L.l("Expected buffer size at '{0}'.  Buffer sizes must end in 'kb'", value));
        }
        return 1024 * kb;
    }

    protected String getRelativeUrl(String value) {
        if (value.length() > 0 && value.charAt(0) == '/') {
            return value;
        }
        return new CharBuffer().append(this._parseState.getUriPwd()).append(value).toString();
    }

    static String parseCharEncoding(String type) throws JspParseException {
        int i;
        type = type.toLowerCase();
        while ((i = type.indexOf(59)) >= 0 && i < type.length()) {
            char ch;
            ++i;
            while (i < type.length() && ((ch = type.charAt(i)) == ' ' || ch == '\t')) {
                ++i;
            }
            if (i >= type.length()) {
                return null;
            }
            if ((i = (type = type.substring(i)).indexOf(61)) >= 0) {
                if (!type.startsWith("charset")) continue;
                ++i;
                while (i < type.length() && ((ch = type.charAt(i)) == ' ' || ch == '\t')) {
                    ++i;
                }
                type = type.substring(i);
            }
            for (i = 0; i < type.length() && (ch = type.charAt(i)) != ';' && ch != ' '; ++i) {
            }
            return type.substring(0, i);
        }
        return null;
    }

    public void endAttributes() throws JspParseException {
        if (this._gen.isTag()) {
            throw this.error(L.l("page directives are forbidden in tags."));
        }
    }

    public boolean isStatic() {
        return true;
    }

    public void printXml(WriteStream os) throws IOException {
        ArrayList<String> imports;
        os.print("<jsp:directive.page");
        this.printJspId(os);
        if (!this._parseState.isELIgnored()) {
            os.print(" el-ignored='false'");
        }
        if (this._parseState.getContentType() != null) {
            os.print(new CharBuffer().append(" content-type='").append(this._parseState.getContentType()).append("'").toString());
        }
        if ((imports = this._parseState.getImportList()) != null && imports.size() != 0) {
            os.print(" import='");
            for (int i = 0; i < imports.size(); ++i) {
                if (i != 0) {
                    os.print(',');
                }
                os.print(imports.get(i));
            }
            os.print("'");
        }
        os.print("/>");
    }

    public void generate(JspJavaWriter out) throws Exception {
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("javax.servlet.jsp.HttpJspPage");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.jsp.java.JspDirectivePage");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

