/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.bytecode.ByteCodeParser;
import com.caucho.bytecode.CodeAttribute;
import com.caucho.bytecode.CodeVisitor;
import com.caucho.bytecode.JavaClass;
import com.caucho.bytecode.JavaMethod;
import com.caucho.jsp.AnalyzedTag;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TagAnalyzer {
    private static final Logger log = Log.open(TagAnalyzer._resin_compat_class_7());
    static final L10N L = new L10N(TagAnalyzer._resin_compat_class_7());
    private HashMap<Class, AnalyzedTag> _analyzedTags = new HashMap();
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;
    private static Class _resin_compat_class_2;
    private static Class _resin_compat_class_3;
    private static Class _resin_compat_class_4;
    private static Class _resin_compat_class_5;
    private static Class _resin_compat_class_6;
    private static Class _resin_compat_class_7;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnalyzedTag analyze(Class tagClass) {
        if (tagClass == null) {
            return null;
        }
        AnalyzedTag analyzedTag = this._analyzedTags.get(tagClass);
        if (analyzedTag != null) {
            return analyzedTag;
        }
        if (!TagAnalyzer._resin_compat_class_0().isAssignableFrom(tagClass)) {
            return null;
        }
        if (tagClass.isInterface()) {
            return null;
        }
        AnalyzedTag parent = this.analyze(tagClass.getSuperclass());
        String name = new CharBuffer().append(tagClass.getName().replace('.', '/')).append(".class").toString();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        AnalyzedTag tag = new AnalyzedTag();
        try {
            this.analyzeByReflection(tagClass, tag, parent);
            InputStream is = loader.getResourceAsStream(name);
            if (is == null) {
                return tag;
            }
            try {
                JavaClass javaClass = new ByteCodeParser().parse(is);
                this.analyze(javaClass, "doStartTag", "()I", new StartAnalyzer(), tag);
                this.analyze(javaClass, "doEndTag", "()I", new EndAnalyzer(), tag);
                if (TagAnalyzer._resin_compat_class_1().isAssignableFrom(tagClass)) {
                    this.analyze(javaClass, "doAfterBody", "()I", new AfterAnalyzer(), tag);
                }
                if (TagAnalyzer._resin_compat_class_2().isAssignableFrom(tagClass)) {
                    this.analyze(javaClass, "doInitBody", "()V", new InitAnalyzer(), tag);
                }
                if (TagAnalyzer._resin_compat_class_3().isAssignableFrom(tagClass)) {
                    this.analyze(javaClass, "doCatch", "(Ljava/lang/Throwable;)V", new CatchAnalyzer(), tag);
                    this.analyze(javaClass, "doFinally", "()V", new FinallyAnalyzer(), tag);
                }
            }
            finally {
                is.close();
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        return tag;
    }

    public void analyzeByReflection(Class tagClass, AnalyzedTag tag, AnalyzedTag parent) {
        tag.setBodyTag(TagAnalyzer._resin_compat_class_2().isAssignableFrom(tagClass));
        Method doStartMethod = this.getMethod(tagClass, "doStartTag", new Class[0]);
        if (doStartMethod != null && doStartMethod.getDeclaringClass().equals(tagClass)) {
            if (TagAnalyzer._resin_compat_class_4().equals(tagClass)) {
                tag.setDoStart(false);
                tag.setStartReturnsSkip(false);
                tag.setStartReturnsInclude(true);
                tag.setStartReturnsBuffered(false);
            } else if (TagAnalyzer._resin_compat_class_5().equals(tagClass)) {
                tag.setDoStart(false);
                tag.setStartReturnsSkip(false);
                tag.setStartReturnsInclude(false);
                tag.setStartReturnsBuffered(true);
            } else if (TagAnalyzer._resin_compat_class_2().isAssignableFrom(tagClass)) {
                tag.setDoStart(true);
                tag.setStartReturnsSkip(true);
                tag.setStartReturnsInclude(true);
                tag.setStartReturnsBuffered(true);
            } else {
                tag.setDoStart(true);
                tag.setStartReturnsSkip(true);
                tag.setStartReturnsInclude(true);
                tag.setStartReturnsBuffered(false);
            }
        } else if (parent != null) {
            tag.setDoStart(parent.getDoStart());
            tag.setStartReturnsSkip(parent.getStartReturnsSkip());
            tag.setStartReturnsInclude(parent.getStartReturnsInclude());
            tag.setStartReturnsBuffered(parent.getStartReturnsBufferedAsParent());
        }
        Method doEndMethod = this.getMethod(tagClass, "doEndTag", new Class[0]);
        if (doEndMethod != null && doEndMethod.getDeclaringClass().equals(tagClass)) {
            if (TagAnalyzer._resin_compat_class_4().equals(tagClass) || TagAnalyzer._resin_compat_class_5().equals(tagClass)) {
                tag.setDoEnd(false);
                tag.setEndReturnsSkip(false);
                tag.setEndReturnsEval(true);
            } else {
                tag.setDoEnd(true);
                tag.setEndReturnsSkip(true);
                tag.setEndReturnsEval(true);
            }
        } else if (parent != null) {
            tag.setDoEnd(parent.getDoEnd());
            tag.setEndReturnsSkip(parent.getEndReturnsSkip());
            tag.setEndReturnsEval(parent.getEndReturnsEval());
        }
        Method doAfterBody = this.getMethod(tagClass, "doAfterBody", new Class[0]);
        if (doAfterBody != null && doAfterBody.getDeclaringClass().equals(tagClass)) {
            if (TagAnalyzer._resin_compat_class_4().equals(tagClass) || TagAnalyzer._resin_compat_class_5().equals(tagClass)) {
                tag.setDoAfter(false);
                tag.setAfterReturnsAgain(false);
            } else if (!TagAnalyzer._resin_compat_class_1().isAssignableFrom(tagClass)) {
                tag.setDoAfter(false);
                tag.setAfterReturnsAgain(false);
            } else {
                tag.setDoAfter(true);
                tag.setAfterReturnsAgain(true);
            }
        } else if (parent != null) {
            tag.setDoAfter(parent.getDoAfter());
            tag.setAfterReturnsAgain(parent.getAfterReturnsAgain());
        }
        Method doInitBody = this.getMethod(tagClass, "doInitBody", new Class[0]);
        if (doInitBody != null && doInitBody.getDeclaringClass().equals(tagClass)) {
            if (TagAnalyzer._resin_compat_class_5().equals(tagClass)) {
                tag.setDoInit(false);
            } else if (!TagAnalyzer._resin_compat_class_2().isAssignableFrom(tagClass)) {
                tag.setDoInit(false);
            } else {
                tag.setDoInit(true);
            }
        } else if (parent != null) {
            tag.setDoInit(parent.getDoInit());
        }
        Method doCatch = this.getMethod(tagClass, "doCatch", new Class[]{TagAnalyzer._resin_compat_class_6()});
        if (doCatch != null && doCatch.getDeclaringClass().equals(tagClass)) {
            if (!TagAnalyzer._resin_compat_class_3().isAssignableFrom(tagClass)) {
                tag.setDoCatch(false);
            } else {
                tag.setDoCatch(true);
            }
        } else if (parent != null) {
            tag.setDoCatch(parent.getDoCatch());
        }
        Method doFinally = this.getMethod(tagClass, "doFinally", new Class[0]);
        if (doFinally != null && doFinally.getDeclaringClass().equals(tagClass)) {
            if (!TagAnalyzer._resin_compat_class_3().isAssignableFrom(tagClass)) {
                tag.setDoFinally(false);
            } else {
                tag.setDoFinally(true);
            }
        } else if (parent != null) {
            tag.setDoFinally(parent.getDoFinally());
        }
    }

    private Method getMethod(Class tagClass, String name, Class[] args) {
        try {
            return tagClass.getMethod(name, args);
        }
        catch (Throwable e) {
            return null;
        }
    }

    private void analyze(JavaClass javaClass, String name, String signature, Analyzer analyzer, AnalyzedTag tag) {
        JavaMethod method = javaClass.findMethod(name, signature);
        if (method == null) {
            return;
        }
        CodeAttribute codeAttribute = method.getCode();
        if (codeAttribute == null) {
            return;
        }
        CodeVisitor visitor = new CodeVisitor(javaClass, codeAttribute);
        try {
            visitor.analyze(analyzer);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        analyzer.complete(tag);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("javax.servlet.jsp.tagext.Tag");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("javax.servlet.jsp.tagext.IterationTag");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_2() {
        try {
            Class<?> clazz = _resin_compat_class_2;
            if (clazz == null) {
                clazz = _resin_compat_class_2 = Class.forName("javax.servlet.jsp.tagext.BodyTag");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_3() {
        try {
            Class<?> clazz = _resin_compat_class_3;
            if (clazz == null) {
                clazz = _resin_compat_class_3 = Class.forName("javax.servlet.jsp.tagext.TryCatchFinally");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_4() {
        try {
            Class<?> clazz = _resin_compat_class_4;
            if (clazz == null) {
                clazz = _resin_compat_class_4 = Class.forName("javax.servlet.jsp.tagext.TagSupport");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_5() {
        try {
            Class<?> clazz = _resin_compat_class_5;
            if (clazz == null) {
                clazz = _resin_compat_class_5 = Class.forName("javax.servlet.jsp.tagext.BodyTagSupport");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_6() {
        try {
            Class<?> clazz = _resin_compat_class_6;
            if (clazz == null) {
                clazz = _resin_compat_class_6 = Class.forName("java.lang.Throwable");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_7() {
        try {
            Class<?> clazz = _resin_compat_class_7;
            if (clazz == null) {
                clazz = _resin_compat_class_7 = Class.forName("com.caucho.jsp.TagAnalyzer");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    static class FinallyAnalyzer
    extends Analyzer {
        private boolean _hasCode;
        private int _count = 0;

        FinallyAnalyzer() {
        }

        public void analyze(CodeVisitor visitor) {
            int count = this._count++;
            switch (visitor.getOpcode()) {
                case 177: {
                    if (count == 0) break;
                    this._hasCode = true;
                    break;
                }
                default: {
                    this._hasCode = true;
                }
            }
        }

        public void complete(AnalyzedTag tag) {
            tag.setDoFinally(this._hasCode);
        }
    }

    static class CatchAnalyzer
    extends Analyzer {
        private boolean _hasCode;
        private int _count = 0;

        CatchAnalyzer() {
        }

        public void analyze(CodeVisitor visitor) {
            int count = this._count++;
            switch (visitor.getOpcode()) {
                case 177: {
                    if (count == 0) break;
                    this._hasCode = true;
                    break;
                }
                default: {
                    this._hasCode = true;
                }
            }
        }

        public void complete(AnalyzedTag tag) {
            tag.setDoCatch(this._hasCode);
        }
    }

    static class InitAnalyzer
    extends Analyzer {
        private boolean _hasCode;
        private int _count = 0;

        InitAnalyzer() {
        }

        public void analyze(CodeVisitor visitor) {
            int count = this._count++;
            switch (visitor.getOpcode()) {
                case 177: {
                    if (count == 0) break;
                    this._hasCode = true;
                    break;
                }
                default: {
                    this._hasCode = true;
                }
            }
        }

        public void complete(AnalyzedTag tag) {
            tag.setDoInit(this._hasCode);
        }
    }

    static class AfterAnalyzer
    extends Analyzer {
        private boolean _hasAfter;
        private boolean _hasAgain;
        private int _count = 0;
        private int _value = -1;

        AfterAnalyzer() {
        }

        public void analyze(CodeVisitor visitor) {
            int count = this._count++;
            switch (visitor.getOpcode()) {
                case 172: {
                    if (count != 1) {
                        this._hasAfter = true;
                    }
                    if (this._value == 2) {
                        this._hasAgain = true;
                        break;
                    }
                    if (this._value == 0) break;
                    this._hasAgain = true;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    if (count != 0) {
                        this._hasAfter = true;
                    }
                    this._value = visitor.getOpcode() - 3;
                    break;
                }
                case 16: {
                    if (count != 0) {
                        this._hasAfter = true;
                    }
                    this._value = visitor.getByteArg();
                    break;
                }
                case 17: {
                    if (count != 0) {
                        this._hasAfter = true;
                    }
                    this._value = visitor.getShortArg();
                    break;
                }
                default: {
                    this._hasAfter = true;
                    this._value = -1;
                }
            }
        }

        public void complete(AnalyzedTag tag) {
            tag.setDoAfter(this._hasAfter);
            tag.setAfterReturnsAgain(this._hasAgain);
        }
    }

    static class EndAnalyzer
    extends Analyzer {
        private boolean _hasSkip;
        private boolean _hasEval;
        private boolean _hasEnd;
        private int _count = 0;
        private int _value = -1;

        EndAnalyzer() {
        }

        public void analyze(CodeVisitor visitor) {
            int count = this._count++;
            switch (visitor.getOpcode()) {
                case 172: {
                    if (count != 1) {
                        this._hasEnd = true;
                    }
                    if (this._value == 5) {
                        this._hasSkip = true;
                        break;
                    }
                    if (this._value == 6) {
                        this._hasEval = true;
                        break;
                    }
                    this._hasEnd = true;
                    this._hasSkip = true;
                    this._hasEval = true;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    if (count != 0) {
                        this._hasEnd = true;
                    }
                    this._value = visitor.getOpcode() - 3;
                    break;
                }
                case 16: {
                    if (count != 0) {
                        this._hasEnd = true;
                    }
                    this._value = visitor.getByteArg();
                    break;
                }
                case 17: {
                    if (count != 0) {
                        this._hasEnd = true;
                    }
                    this._value = visitor.getShortArg();
                    break;
                }
                default: {
                    this._hasEnd = true;
                    this._value = -1;
                }
            }
        }

        public void complete(AnalyzedTag tag) {
            tag.setDoEnd(this._hasEnd);
            tag.setEndReturnsSkip(this._hasSkip);
            tag.setEndReturnsEval(this._hasEval);
        }
    }

    static class StartAnalyzer
    extends Analyzer {
        private boolean _hasSkip;
        private boolean _hasInclude;
        private boolean _hasBuffered;
        private boolean _hasStart;
        private int _count = 0;
        private int _value = -1;

        StartAnalyzer() {
        }

        public void analyze(CodeVisitor visitor) {
            int count = this._count++;
            switch (visitor.getOpcode()) {
                case 172: {
                    if (count != 1) {
                        this._hasStart = true;
                    }
                    if (this._value == 0) {
                        this._hasSkip = true;
                        break;
                    }
                    if (this._value == 1) {
                        this._hasInclude = true;
                        break;
                    }
                    if (this._value == 2) {
                        this._hasBuffered = true;
                        break;
                    }
                    this._hasSkip = true;
                    this._hasInclude = true;
                    this._hasBuffered = true;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    if (count != 0) {
                        this._hasStart = true;
                    }
                    this._value = visitor.getOpcode() - 3;
                    break;
                }
                case 16: {
                    if (count != 0) {
                        this._hasStart = true;
                    }
                    this._value = visitor.getByteArg();
                    break;
                }
                case 17: {
                    if (count != 0) {
                        this._hasStart = true;
                    }
                    this._value = visitor.getShortArg();
                    break;
                }
                default: {
                    this._hasStart = true;
                    this._value = -1;
                }
            }
        }

        public void complete(AnalyzedTag tag) {
            tag.setDoStart(this._hasStart);
            tag.setStartReturnsSkip(this._hasSkip);
            tag.setStartReturnsInclude(this._hasInclude);
            tag.setStartReturnsBuffered(this._hasBuffered);
        }
    }

    static class Analyzer
    extends com.caucho.bytecode.Analyzer {
        Analyzer() {
        }

        public void analyze(CodeVisitor visitor) {
        }

        public void complete(AnalyzedTag tag) {
        }
    }
}

