/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.java.JavaCompiler;
import com.caucho.jsp.Page;
import com.caucho.jsp.cfg.JspPropertyGroup;
import com.caucho.loader.Environment;
import com.caucho.log.Log;
import com.caucho.make.PersistentDependency;
import com.caucho.server.webapp.Application;
import com.caucho.util.Alarm;
import com.caucho.util.CacheListener;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.LruCache;
import com.caucho.vfs.MemoryPath;
import com.caucho.vfs.Path;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PageManager {
    private static final Logger log = Log.open(PageManager._resin_compat_class_0());
    static final long ACCESS_INTERVAL = 60000L;
    protected Application _application;
    private Path _classDir;
    private long _updateInterval = 1000L;
    private boolean _isAdapter;
    private boolean _omitInitLog;
    private int _jspMax = 1024;
    private LruCache<String, Entry> _cache;
    protected boolean _autoCompile = true;
    private static Class _resin_compat_class_0;

    PageManager(Application application) {
        this._application = application;
        this._classDir = CauchoSystem.getWorkPath();
        long interval = Environment.getDependencyCheckInterval();
        JspPropertyGroup jspPropertyGroup = this._application.getJsp();
        if (jspPropertyGroup != null) {
            this._autoCompile = jspPropertyGroup.isAutoCompile();
            this._jspMax = jspPropertyGroup.getJspMax();
            if (jspPropertyGroup.getDependencyCheckInterval() != Long.MIN_VALUE) {
                interval = jspPropertyGroup.getDependencyCheckInterval();
            }
        }
        if (interval < 0L) {
            interval = 0x3FFFFFFFL;
        }
        this._updateInterval = interval;
    }

    public Path getClassDir() {
        if (this._classDir != null) {
            return this._classDir;
        }
        Path appDir = this._application.getAppDir();
        if (appDir instanceof MemoryPath) {
            String workPathName = new CharBuffer().append("./").append(this._application.getURL()).toString();
            Path path = CauchoSystem.getWorkPath().lookup(workPathName);
            return path;
        }
        return appDir.lookup("WEB-INF/work");
    }

    public Path getAppDir() {
        return this._application.getAppDir();
    }

    Application getApplication() {
        return this._application;
    }

    public Page getPage(String uri, Path path) throws Exception {
        return this.getPage(uri, uri, path, null);
    }

    public Page getPage(String uri, String pageURI, Path path) throws Exception {
        return this.getPage(uri, pageURI, path, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page getPage(String uri, String pageURI, Path path, ArrayList<PersistentDependency> dependList) throws Exception {
        LruCache<String, Entry> cache = this._cache;
        if (cache == null) {
            PageManager pageManager = this;
            synchronized (pageManager) {
                if (this._cache == null) {
                    this._cache = new LruCache(this._jspMax);
                }
                cache = this._cache;
            }
        }
        Entry entry = null;
        Object object = cache;
        synchronized (object) {
            entry = cache.get(uri);
            if (entry == null) {
                entry = new Entry(uri);
                cache.put(uri, entry);
            }
        }
        object = entry;
        synchronized (object) {
            String className;
            Page page = entry.getPage();
            if (page != null && !page.cauchoIsModified()) {
                return page;
            }
            if (page != null && !page.isDead()) {
                try {
                    page.destroy();
                }
                catch (Exception e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine(new CharBuffer().append("uri:").append(uri).append("(cp:").append(this._application.getContextPath()).append(",app:").append(this._application.getAppDir()).append(") -> ").append(path).toString());
            }
            Path appDir = this.getApplication().getAppDir();
            String rawClassName = pageURI;
            if (path.getPath().startsWith(appDir.getPath())) {
                rawClassName = path.getPath().substring(appDir.getPath().length());
            }
            if ((page = this.createPage(path, pageURI, className = JavaCompiler.mangleName(new CharBuffer().append("jsp/").append(rawClassName).toString()), dependList)) == null) {
                throw new FileNotFoundException(pageURI);
            }
            if (!this._autoCompile) {
                page._caucho_setNeverModified(true);
            }
            page._caucho_setUpdateInterval(this._updateInterval);
            entry.setPage(page);
            return page;
        }
    }

    abstract Page createPage(Path var1, String var2, String var3, ArrayList<PersistentDependency> var4) throws Exception;

    void killPage(HttpServletRequest request, HttpServletResponse response, Page page) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        LruCache<String, Entry> cache = this._cache;
        this._cache = null;
        if (cache == null) {
            return;
        }
        LruCache<String, Entry> lruCache = cache;
        synchronized (lruCache) {
            Iterator<Entry> iter = cache.values();
            while (iter.hasNext()) {
                Entry entry = iter.next();
                Page page = entry != null ? entry.getPage() : null;
                try {
                    if (page == null || page.isDead()) continue;
                    page.destroy();
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jsp.PageManager");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    class Entry
    implements CacheListener {
        private String _key;
        Page _page;
        private long _lastAccessTime;

        Entry(String key) {
            this._key = key;
        }

        void setPage(Page page) {
            this._page = page;
            if (page != null) {
                page._caucho_setEntry(this);
            }
        }

        Page getPage() {
            return this._page;
        }

        public void accessPage() {
            long now = Alarm.getCurrentTime();
            if (now < this._lastAccessTime + 60000L) {
                return;
            }
            this._lastAccessTime = now;
            if (PageManager.this._cache != null) {
                PageManager.this._cache.get(this._key);
            }
        }

        public void removeEvent() {
            Page page = this._page;
            this._page = null;
            if (page != null && !page.isDead()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(new CharBuffer().append("dropping page ").append(page).toString());
                }
                page.setDead();
                page.destroy();
            }
        }
    }
}

