/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jmx;

import com.caucho.jmx.AbstractMBeanServer;
import com.caucho.jmx.MBeanContext;
import com.caucho.jmx.MBeanServerDelegateImpl;
import com.caucho.jmx.MBeanWrapper;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanView {
    private static final Logger log = Log.open(MBeanView._resin_compat_class_0());
    private static final L10N L = new L10N(MBeanView._resin_compat_class_0());
    private ClassLoader _classLoader;
    private AbstractMBeanServer _mbeanServer;
    private MBeanServerDelegateImpl _delegate;
    private HashMap<ObjectName, MBeanWrapper> _mbeans = new HashMap(8);
    private static Class _resin_compat_class_0;

    MBeanView(AbstractMBeanServer mbeanServer, ClassLoader loader, String agentId) {
        this._mbeanServer = mbeanServer;
        this._classLoader = loader;
        this._delegate = new MBeanServerDelegateImpl(agentId);
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    protected MBeanView getParentView() {
        if (this._classLoader == null) {
            return null;
        }
        MBeanContext context = this._mbeanServer.getContext(this._classLoader.getParent());
        if (context.getView() == this) {
            return null;
        }
        return context.getView();
    }

    protected MBeanView getParentGlobalView() {
        return null;
    }

    public int getMBeanCount() {
        MBeanView parentView = this.getParentView();
        if (parentView != null) {
            return this._mbeans.size() + parentView.getMBeanCount();
        }
        return this._mbeans.size();
    }

    public String[] getDomains() {
        ArrayList<String> domains = new ArrayList<String>();
        this.getDomains(domains);
        return domains.toArray(new String[domains.size()]);
    }

    protected void getDomains(ArrayList<String> domains) {
        for (ObjectName name : this._mbeans.keySet()) {
            String domain = name.getDomain();
            if (domains.contains(domain)) continue;
            domains.add(domain);
        }
        MBeanView parent = this.getParentView();
        if (parent != null) {
            parent.getDomains(domains);
        }
    }

    public Set<ObjectName> queryNames(ObjectName queryName, QueryExp query) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        HashSet<ObjectName> set = new HashSet<ObjectName>();
        this.queryNames(set, queryName, query);
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queryNames(Set<ObjectName> set, ObjectName queryName, QueryExp query) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        HashMap<ObjectName, MBeanWrapper> hashMap = this._mbeans;
        synchronized (hashMap) {
            for (ObjectName name : this._mbeans.keySet()) {
                if (!this.isMatch(name, queryName, query)) continue;
                set.add(name);
            }
        }
        MBeanView parentView = this.getParentView();
        if (parentView != null) {
            parentView.queryNames(set, queryName, query);
        }
    }

    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        HashSet<ObjectInstance> set = new HashSet<ObjectInstance>();
        this.queryMBeans(set, name, query);
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queryMBeans(Set<ObjectInstance> set, ObjectName name, QueryExp query) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        HashMap<ObjectName, MBeanWrapper> hashMap = this._mbeans;
        synchronized (hashMap) {
            for (ObjectName testName : this._mbeans.keySet()) {
                MBeanWrapper mbean;
                if (!this.isMatch(testName, name, query) || (mbean = this._mbeans.get(testName)) == null) continue;
                set.add(mbean.getObjectInstance());
            }
        }
        MBeanView parentView = this.getParentView();
        if (parentView != null) {
            parentView.queryMBeans(set, name, query);
        }
    }

    private boolean isMatch(ObjectName name, ObjectName queryName, QueryExp query) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        if (queryName == null) {
            return true;
        }
        if (!queryName.isDomainPattern() && !name.getDomain().equals(queryName.getDomain())) {
            return false;
        }
        if (queryName.isPropertyPattern()) {
            Hashtable<String, String> map = queryName.getKeyPropertyList();
            for (String key : map.keySet()) {
                String value = map.get(key);
                if (value.equals(name.getKeyProperty(key))) continue;
                return false;
            }
        } else {
            String queryProps;
            String testProps = name.getCanonicalKeyPropertyListString();
            if (!testProps.equals(queryProps = queryName.getCanonicalKeyPropertyListString())) {
                return false;
            }
        }
        return query == null || query.apply(name);
    }

    boolean add(ObjectName name, MBeanWrapper mbean) {
        return this.add(name, mbean, false);
    }

    boolean add(ObjectName name, MBeanWrapper mbean, boolean overwrite) {
        if (overwrite || this._mbeans.get(name) == null) {
            this._mbeans.put(name, mbean);
            return true;
        }
        return false;
    }

    MBeanWrapper remove(ObjectName name) {
        return this._mbeans.remove(name);
    }

    MBeanWrapper remove(ObjectName name, MBeanWrapper mbean) {
        if (mbean != null && this._mbeans.get(name) != mbean) {
            return null;
        }
        return this._mbeans.remove(name);
    }

    public MBeanWrapper getMBean(ObjectName name) {
        MBeanWrapper mbean = this._mbeans.get(name);
        if (mbean != null) {
            return mbean;
        }
        if (this._classLoader == null) {
            return null;
        }
        MBeanView parentView = this.getParentView();
        if (parentView != null) {
            return parentView.getMBean(name);
        }
        return null;
    }

    void close() {
        this._mbeans = null;
    }

    public String toString() {
        return new CharBuffer().append("MBeanView[").append(this._classLoader).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jmx.MBeanView");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

