/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jmx;

import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import javax.management.AttributeNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;

public class MBeanSkeleton {
    private static L10N L = new L10N(MBeanSkeleton._resin_compat_class_1());
    private Class _mbeanClass;
    private MBeanInfo _mbeanInfo;
    private HashMap<String, Method> _getAttributes = new HashMap();
    private HashMap<String, Method> _setAttributes = new HashMap();
    private Method[] _operations;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    MBeanSkeleton(Class mbeanClass) throws IntrospectionException {
        this._mbeanClass = mbeanClass;
        this.introspect();
    }

    public Class getMBeanClass() {
        return this._mbeanClass;
    }

    public MBeanInfo getMBeanInfo() {
        return this._mbeanInfo;
    }

    public Object getAttribute(Object object, String name) throws AttributeNotFoundException, ReflectionException {
        Method method = this._getAttributes.get(name);
        if (method != null) {
            try {
                return method.invoke(object, (Object[])null);
            }
            catch (IllegalAccessException e) {
                throw new ReflectionException(e);
            }
            catch (InvocationTargetException e) {
                throw new ReflectionException(e);
            }
        }
        if (name.equals("resin-api")) {
            return this._mbeanClass.getName();
        }
        throw new AttributeNotFoundException(L.l("MBean class `{0}' has no read attribute `{1}'.", (Object)this._mbeanClass.getName(), name));
    }

    public void setAttribute(Object object, String name, Object value) throws AttributeNotFoundException, ReflectionException {
        Method method = this._setAttributes.get(name);
        if (method == null) {
            throw new AttributeNotFoundException(L.l("MBean class `{0}' has no write attribute `{1}'.", (Object)this._mbeanClass.getName(), name));
        }
        try {
            method.invoke(object, value);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(e);
        }
    }

    public Object invoke(Object object, String name, Object[] args, String[] sig) throws MBeanException, ReflectionException {
        Method method = this.findMethod(name, sig);
        if (method == null) {
            throw new MBeanException(null, L.l("MBean class `{0}' has no matching operation `{1}'.", (Object)this._mbeanClass.getName(), name));
        }
        try {
            return method.invoke(object, args);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(e);
        }
    }

    private Method findMethod(String name, String[] sig) {
        block0: for (int i = 0; i < this._operations.length; ++i) {
            Class<?>[] param;
            Method method = this._operations[i];
            if (!method.getName().equals(name) || (param = method.getParameterTypes()).length != sig.length) continue;
            for (int j = 0; j < sig.length; ++j) {
                if (!param[j].getName().equals(sig[j])) continue block0;
            }
            return method;
        }
        return null;
    }

    private void introspect() throws IntrospectionException {
        Method[] methods = this._mbeanClass.getMethods();
        ArrayList<Method> publicMethods = new ArrayList<Method>();
        ArrayList<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>();
        ArrayList<MBeanOperationInfo> operations = new ArrayList<MBeanOperationInfo>();
        for (int i = 0; i < methods.length; ++i) {
            Method setter;
            String attributeName;
            Method method = methods[i];
            if (!Modifier.isPublic(method.getModifiers()) || method.getDeclaringClass().getName().startsWith("javax.management.")) continue;
            String name = method.getName();
            Class<?>[] param = method.getParameterTypes();
            Class<?> retType = method.getReturnType();
            if (name.startsWith("get") && param.length == 0 && !Void.TYPE.equals(retType)) {
                attributeName = name.substring(3);
                setter = this.getSetter(attributeName, retType);
                this._getAttributes.put(attributeName, method);
                attributes.add(new MBeanAttributeInfo(attributeName, attributeName, method, setter));
                continue;
            }
            if (name.startsWith("is") && param.length == 0 && (Boolean.TYPE.equals(retType) || MBeanSkeleton._resin_compat_class_0().equals(retType))) {
                attributeName = name.substring(2);
                setter = this.getSetter(attributeName, retType);
                attributes.add(new MBeanAttributeInfo(attributeName, attributeName, method, setter));
                this._getAttributes.put(attributeName, method);
                continue;
            }
            if (name.startsWith("set") && param.length == 1 && Void.TYPE.equals(retType)) {
                attributeName = name.substring(3);
                this._setAttributes.put(attributeName, method);
                continue;
            }
            operations.add(new MBeanOperationInfo(method.getName(), method));
            publicMethods.add(method);
        }
        this._operations = new Method[publicMethods.size()];
        publicMethods.toArray(this._operations);
        MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[attributes.size()];
        attributes.toArray(attrs);
        MBeanConstructorInfo[] makers = new MBeanConstructorInfo[]{};
        MBeanOperationInfo[] ops = new MBeanOperationInfo[operations.size()];
        operations.toArray(ops);
        MBeanNotificationInfo[] notifs = new MBeanNotificationInfo[]{};
        this._mbeanInfo = new MBeanInfo(this._mbeanClass.getName(), this._mbeanClass.getName(), attrs, makers, ops, notifs);
    }

    private Method getSetter(String attributeName, Class type) {
        String setName = new CharBuffer().append("set").append(attributeName).toString();
        Method[] methods = this._mbeanClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String name;
            Method method = methods[i];
            if (!Modifier.isPublic(method.getModifiers()) || !setName.equals(name = method.getName())) continue;
            Class<?>[] param = method.getParameterTypes();
            Class<?> ret = method.getReturnType();
            if (param.length != 1 || !Void.TYPE.equals(ret)) continue;
            if (param[0].equals(type)) {
                return method;
            }
            return null;
        }
        return null;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.lang.Boolean");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.jmx.MBeanSkeleton");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

