/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.session;

import com.caucho.jms.AbstractDestination;
import com.caucho.jms.message.BytesMessageImpl;
import com.caucho.jms.message.MapMessageImpl;
import com.caucho.jms.message.MessageImpl;
import com.caucho.jms.message.ObjectMessageImpl;
import com.caucho.jms.message.StreamMessageImpl;
import com.caucho.jms.message.TextMessageImpl;
import com.caucho.jms.session.ConnectionImpl;
import com.caucho.jms.session.MessageConsumerImpl;
import com.caucho.jms.session.MessageProducerImpl;
import com.caucho.jms.session.QueueSenderImpl;
import com.caucho.jms.session.TemporaryQueueImpl;
import com.caucho.jms.session.TemporaryTopicImpl;
import com.caucho.jms.session.TopicPublisherImpl;
import com.caucho.log.Log;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.ThreadPool;
import com.caucho.util.ThreadTask;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

public class SessionImpl
implements Session,
ThreadTask {
    protected static final Logger log = Log.open(SessionImpl._resin_compat_class_0());
    protected static final L10N L = new L10N(SessionImpl._resin_compat_class_0());
    private static final long SHUTDOWN_WAIT_TIME = 10000L;
    private boolean _isTransacted;
    private int _acknowledgeMode;
    private ClassLoader _classLoader;
    private ConnectionImpl _connection;
    private ArrayList<MessageConsumerImpl> _consumers = new ArrayList();
    private MessageListener _messageListener;
    private boolean _isAsynchronous;
    private Thread _thread;
    private ArrayList<TransactedMessage> _transactedMessages;
    private volatile boolean _isRunning;
    private volatile boolean _isClosed;
    private volatile boolean _hasMessage;
    private static Class _resin_compat_class_0;

    public SessionImpl(ConnectionImpl connection, boolean isTransacted, int ackMode) throws JMSException {
        this._classLoader = Thread.currentThread().getContextClassLoader();
        this._connection = connection;
        this._isTransacted = isTransacted;
        if (isTransacted) {
            this._acknowledgeMode = 4;
        } else {
            switch (ackMode) {
                case 1: 
                case 2: 
                case 3: {
                    this._acknowledgeMode = ackMode;
                    break;
                }
                default: {
                    throw new JMSException(L.l("{0} is an illegal acknowledge mode", ackMode));
                }
            }
        }
        this._connection.addSession(this);
    }

    ConnectionImpl getConnection() {
        return this._connection;
    }

    public String getClientID() throws JMSException {
        return this._connection.getClientID();
    }

    public boolean isActive() {
        return !this._isClosed && this._connection.isActive();
    }

    boolean isStopping() {
        return this._connection.isStopping();
    }

    public boolean getTransacted() throws JMSException {
        this.checkOpen();
        return this._isTransacted;
    }

    public int getAcknowledgeMode() throws JMSException {
        this.checkOpen();
        return this._acknowledgeMode;
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkOpen();
        return this._messageListener;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.checkOpen();
        this._messageListener = listener;
        this.setAsynchronous();
    }

    void setAsynchronous() {
        boolean oldAsynchronous = this._isAsynchronous;
        this._isAsynchronous = true;
        this.notifyListener();
    }

    boolean isAsynchronous() {
        return this._isAsynchronous;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.checkOpen();
        return new BytesMessageImpl();
    }

    public MapMessage createMapMessage() throws JMSException {
        this.checkOpen();
        return new MapMessageImpl();
    }

    public Message createMessage() throws JMSException {
        this.checkOpen();
        return new MessageImpl();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.checkOpen();
        return new ObjectMessageImpl();
    }

    public ObjectMessage createObjectMessage(Serializable obj) throws JMSException {
        this.checkOpen();
        ObjectMessage msg = this.createObjectMessage();
        msg.setObject(obj);
        return msg;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.checkOpen();
        return new StreamMessageImpl();
    }

    public TextMessage createTextMessage() throws JMSException {
        this.checkOpen();
        return new TextMessageImpl();
    }

    public TextMessage createTextMessage(String message) throws JMSException {
        this.checkOpen();
        TextMessage msg = this.createTextMessage();
        msg.setText(message);
        return msg;
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        this.checkOpen();
        return this.createConsumer(destination, null, false);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        this.checkOpen();
        return this.createConsumer(destination, messageSelector, false);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        this.checkOpen();
        AbstractDestination dest = (AbstractDestination)destination;
        MessageConsumer consumer = dest.createConsumer(this, messageSelector, noLocal);
        this.addConsumer((MessageConsumerImpl)consumer);
        return consumer;
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        this.checkOpen();
        if (destination instanceof Queue) {
            return new QueueSenderImpl(this, (Queue)destination);
        }
        if (destination instanceof Topic) {
            return new TopicPublisherImpl(this, (Topic)destination);
        }
        return new MessageProducerImpl(this, destination);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        this.checkOpen();
        return this.createBrowser(queue, null);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        this.checkOpen();
        return ((AbstractDestination)queue).createBrowser(this, messageSelector);
    }

    public Queue createQueue(String queueName) throws JMSException {
        this.checkOpen();
        return this._connection.getConnectionFactory().createQueue(queueName);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        this.checkOpen();
        return new TemporaryQueueImpl();
    }

    public Topic createTopic(String topicName) throws JMSException {
        this.checkOpen();
        return this._connection.getConnectionFactory().createTopic(topicName);
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        this.checkOpen();
        return new TemporaryTopicImpl();
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        this.checkOpen();
        if (this.getClientID() == null) {
            throw new JMSException(L.l("connection may not create a durable subscriber because it does not have an assigned ClientID."));
        }
        return this.createDurableSubscriber(topic, name, null, false);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        this.checkOpen();
        AbstractDestination topicImpl = (AbstractDestination)topic;
        if (this._connection.getDurableSubscriber(name) != null) {
            throw new JMSException(L.l("'{0}' is already an active durable subscriber", name));
        }
        TopicSubscriber consumer = topicImpl.createDurableSubscriber(this, messageSelector, noLocal, name);
        this._connection.putDurableSubscriber(name, consumer);
        this.addConsumer((MessageConsumerImpl)consumer);
        return consumer;
    }

    public void unsubscribe(String name) throws JMSException {
        this.checkOpen();
        this._connection.removeDurableSubscriber(name);
    }

    void start() {
        this.notifyListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        ArrayList<MessageConsumerImpl> arrayList = this._consumers;
        synchronized (arrayList) {
            this._consumers.notifyAll();
            long timeout = Alarm.getCurrentTime() + 10000L;
            while (this._isRunning && Alarm.getCurrentTime() < timeout) {
                try {
                    this._consumers.wait(10000L);
                    if (!Alarm.isTest()) continue;
                    return;
                }
                catch (Throwable e) {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws JMSException {
        this.checkOpen();
        if (!this._isTransacted) {
            throw new IllegalStateException(L.l("commit() can only be called on a transacted session."));
        }
        ArrayList<TransactedMessage> messages = this._transactedMessages;
        if (messages != null) {
            try {
                for (int i = 0; i < messages.size(); ++i) {
                    messages.get(i).send();
                }
            }
            finally {
                messages.clear();
            }
        }
        this.acknowledge();
    }

    public void acknowledge() throws JMSException {
        this.checkOpen();
        for (int i = 0; i < this._consumers.size(); ++i) {
            MessageConsumerImpl consumer = this._consumers.get(i);
            try {
                consumer.acknowledge();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    public void rollback() throws JMSException {
        this.checkOpen();
        if (!this._isTransacted) {
            throw new IllegalStateException(L.l("rollback() can only be called on a transacted session."));
        }
        if (this._transactedMessages != null) {
            this._transactedMessages.clear();
        }
        for (int i = 0; i < this._consumers.size(); ++i) {
            MessageConsumerImpl consumer = this._consumers.get(i);
            try {
                consumer.rollback();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    public void recover() throws JMSException {
        this.checkOpen();
        if (this._isTransacted) {
            throw new IllegalStateException(L.l("recover() may not be called on a transacted session."));
        }
        for (int i = 0; i < this._consumers.size(); ++i) {
            MessageConsumerImpl consumer = this._consumers.get(i);
            try {
                consumer.rollback();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        if (this._isClosed) {
            return;
        }
        try {
            this.stop();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        for (int i = 0; i < this._consumers.size(); ++i) {
            MessageConsumerImpl consumer = this._consumers.get(i);
            try {
                consumer.rollback();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            try {
                consumer.close();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        try {
            this._connection.removeSession(this);
        }
        finally {
            this._isClosed = true;
        }
        this._classLoader = null;
    }

    protected void addConsumer(MessageConsumerImpl consumer) {
        if (this._consumers == null) {
            this._consumers = new ArrayList();
        }
        this._consumers.add(consumer);
        this.notifyListener();
    }

    protected void removeConsumer(MessageConsumerImpl consumer) {
        if (this._consumers != null) {
            this._consumers.remove(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyListener() {
        this._hasMessage = true;
        ArrayList<MessageConsumerImpl> arrayList = this._consumers;
        synchronized (arrayList) {
            this._consumers.notifyAll();
        }
        if (this._isAsynchronous) {
            ThreadPool.schedule(this);
            Thread.yield();
        }
    }

    public void send(AbstractDestination queue, MessageImpl message, int deliveryMode, int priority, long expiration) throws JMSException {
        this.checkOpen();
        message.setJMSMessageID(queue.generateMessageID());
        message.setJMSDestination(queue);
        message.setJMSDeliveryMode(deliveryMode);
        message.setJMSTimestamp(Alarm.getCurrentTime());
        message.setJMSExpiration(expiration);
        message.setJMSPriority(priority);
        MessageImpl destMessage = message.copy();
        destMessage.setSession(this);
        destMessage.setReceive();
        if (this._isTransacted) {
            if (this._transactedMessages == null) {
                this._transactedMessages = new ArrayList();
            }
            TransactedMessage transMsg = new TransactedMessage(queue, message);
            this._transactedMessages.add(transMsg);
        } else {
            queue.send(destMessage);
        }
    }

    protected Message receive(MessageConsumerImpl consumer, long timeout) throws JMSException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this._hasMessage = true;
        Thread thread = Thread.currentThread();
        while (this._hasMessage && this.isActive() && !this.isStopping()) {
            ArrayList<MessageConsumerImpl> arrayList = this._consumers;
            synchronized (arrayList) {
                if (this._isRunning) {
                    return;
                }
                this._isRunning = true;
            }
            try {
                this._hasMessage = false;
                for (int i = 0; i < this._consumers.size(); ++i) {
                    MessageConsumerImpl consumer = this._consumers.get(i);
                    MessageListener listener = consumer.getMessageListener();
                    if (this._messageListener != null) {
                        listener = this._messageListener;
                    }
                    if (!consumer.isActive() || this.isStopping() || listener == null) continue;
                    try {
                        Message msg = consumer.receiveNoWait();
                        if (msg == null) continue;
                        this._hasMessage = true;
                        if (log.isLoggable(Level.FINE)) {
                            log.fine(new CharBuffer().append("JMS ").append(msg).append(" delivered to ").append(listener).toString());
                        }
                        ClassLoader oldLoader = thread.getContextClassLoader();
                        try {
                            thread.setContextClassLoader(this._classLoader);
                            listener.onMessage(msg);
                            continue;
                        }
                        finally {
                            thread.setContextClassLoader(oldLoader);
                        }
                    }
                    catch (Throwable e) {
                        log.log(Level.WARNING, e.toString(), e);
                    }
                }
            }
            finally {
                arrayList = this._consumers;
                synchronized (arrayList) {
                    this._isRunning = false;
                    this._consumers.notifyAll();
                }
            }
        }
    }

    public void checkOpen() throws IllegalStateException {
        if (this._isClosed) {
            throw new IllegalStateException(L.l("session is closed"));
        }
    }

    void checkThread() throws JMSException {
        Thread thread = this._thread;
        if (thread != Thread.currentThread() && thread != null) {
            IllegalStateException e = new IllegalStateException(L.l("Can't use session from concurrent threads."));
            log.log(Level.WARNING, e.toString(), (Throwable)e);
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jms.session.SessionImpl");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    static class TransactedMessage {
        private AbstractDestination _queue;
        private MessageImpl _message;

        TransactedMessage(AbstractDestination queue, MessageImpl message) {
            this._queue = queue;
            this._message = message;
        }

        void send() throws JMSException {
            this._queue.send(this._message);
        }
    }
}

