/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.session;

import com.caucho.jms.AbstractDestination;
import com.caucho.jms.selector.Selector;
import com.caucho.jms.selector.SelectorParser;
import com.caucho.jms.session.SessionImpl;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.caucho.util.NullEnumeration;
import java.util.Enumeration;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;

public class QueueBrowserImpl
implements QueueBrowser {
    static final Logger log = Log.open(QueueBrowserImpl._resin_compat_class_0());
    static final L10N L = new L10N(QueueBrowserImpl._resin_compat_class_0());
    private SessionImpl _session;
    protected AbstractDestination _queue;
    private String _messageSelector;
    private Selector _selector;
    private static Class _resin_compat_class_0;

    QueueBrowserImpl(SessionImpl session, Queue queue, String messageSelector) throws JMSException {
        this._session = session;
        this._queue = (AbstractDestination)queue;
        this._messageSelector = messageSelector;
        if (this._messageSelector != null) {
            SelectorParser parser = new SelectorParser();
            this._selector = parser.parse(messageSelector);
        }
    }

    public Queue getQueue() throws JMSException {
        return (Queue)this._queue;
    }

    public String getMessageSelector() throws JMSException {
        return this._messageSelector;
    }

    public Enumeration getEnumeration() throws JMSException {
        if (this._session.isActive()) {
            return this._queue.getEnumeration(this._selector);
        }
        return NullEnumeration.create();
    }

    public void close() throws JMSException {
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jms.session.QueueBrowserImpl");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

