/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.session;

import com.caucho.jms.AbstractDestination;
import com.caucho.jms.message.MessageImpl;
import com.caucho.jms.selector.Selector;
import com.caucho.jms.selector.SelectorParser;
import com.caucho.jms.session.MessageAvailableListener;
import com.caucho.jms.session.SessionImpl;
import com.caucho.log.Log;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import java.util.logging.Logger;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;

public class MessageConsumerImpl
implements MessageConsumer,
MessageAvailableListener {
    static final Logger log = Log.open(MessageConsumerImpl._resin_compat_class_0());
    static final L10N L = new L10N(MessageConsumerImpl._resin_compat_class_0());
    private final Object _consumerLock = new Object();
    protected SessionImpl _session;
    private AbstractDestination _queue;
    private MessageListener _messageListener;
    private String _messageSelector;
    protected Selector _selector;
    private boolean _noLocal;
    private volatile boolean _isClosed;
    private static Class _resin_compat_class_0;

    protected MessageConsumerImpl(SessionImpl session, String messageSelector, AbstractDestination queue, boolean noLocal) throws JMSException {
        this._session = session;
        this._queue = queue;
        this._messageSelector = messageSelector;
        if (this._messageSelector != null) {
            SelectorParser parser = new SelectorParser();
            this._selector = parser.parse(messageSelector);
        }
        this._noLocal = noLocal;
        this._queue.addListener(this);
    }

    public boolean getNoLocal() {
        return this._noLocal;
    }

    public MessageListener getMessageListener() {
        return this._messageListener;
    }

    public void setMessageListener(MessageListener listener) {
        this._messageListener = listener;
        this._session.setAsynchronous();
    }

    public String getMessageSelector() {
        return this._messageSelector;
    }

    public Selector getSelector() {
        return this._selector;
    }

    public boolean isActive() {
        return this._session.isActive() && !this._isClosed;
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    public Message receive() throws JMSException {
        return this.receive(Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive(long timeout) throws JMSException {
        this._session.checkOpen();
        if (0x3FFFFFFFFFFFFFFFL < timeout || timeout < 0L) {
            timeout = 0x3FFFFFFFFFFFFFFFL;
        }
        long now = Alarm.getCurrentTime();
        long expireTime = Alarm.getCurrentTime() + timeout;
        while (!this.isClosed()) {
            Message msg = this.receiveNoWait();
            if (msg != null) {
                return msg;
            }
            long delta = expireTime - Alarm.getCurrentTime();
            if (delta <= 0L || this._isClosed || Alarm.isTest()) {
                return null;
            }
            Object object = this._consumerLock;
            synchronized (object) {
                try {
                    this._consumerLock.wait(delta);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public Message receiveNoWait() throws JMSException {
        if (this._isClosed) {
            throw new IllegalStateException(L.l("can't receive when consumer is closed"));
        }
        if (!this._session.isActive()) {
            return null;
        }
        MessageImpl msg = this.receiveImpl();
        if (msg == null) {
            return null;
        }
        switch (this._session.getAcknowledgeMode()) {
            case 2: {
                msg.setSession(this._session);
                break;
            }
            case 1: 
            case 3: {
                this.acknowledge();
                break;
            }
        }
        return msg;
    }

    protected MessageImpl receiveImpl() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void acknowledge() throws JMSException {
    }

    public void rollback() throws JMSException {
    }

    public void close() throws JMSException {
        this._isClosed = true;
        this._queue.removeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageAvailable() {
        this._session.notifyListener();
        Object object = this._consumerLock;
        synchronized (object) {
            try {
                this._consumerLock.notify();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jms.session.MessageConsumerImpl");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

