/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.selector;

import com.caucho.jms.selector.Selector;
import com.caucho.util.L10N;
import javax.jms.JMSException;
import javax.jms.Message;

public class UnarySelector
extends Selector {
    static L10N L = new L10N(UnarySelector._resin_compat_class_0());
    private int _token;
    private Selector _expr;
    private static Class _resin_compat_class_0;

    UnarySelector(int token, Selector expr) {
        this._token = token;
        this._expr = expr;
    }

    boolean isBoolean() {
        switch (this._token) {
            case 3: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    boolean isNumber() {
        switch (this._token) {
            case 43: 
            case 45: {
                return true;
            }
        }
        return false;
    }

    boolean isUnknown() {
        return false;
    }

    Object evaluate(Message message) throws JMSException {
        Object value = this._expr.evaluate(message);
        switch (this._token) {
            case 15: {
                if (!(value instanceof Boolean)) {
                    return NULL;
                }
                return UnarySelector.toBoolean((Boolean)value == false);
            }
            case 3: {
                return UnarySelector.toBoolean(value == null);
            }
            case 43: {
                if (!(value instanceof Number)) {
                    return NULL;
                }
                return value;
            }
            case 45: {
                if (!(value instanceof Number)) {
                    return NULL;
                }
                if (UnarySelector.isInteger(value)) {
                    return new Long(-this.toLong(value));
                }
                return new Double(-((Number)value).doubleValue());
            }
        }
        throw new JMSException("NOTONE");
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jms.selector.Selector");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

