/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.selector;

import com.caucho.jms.selector.Selector;
import com.caucho.util.L10N;
import javax.jms.JMSException;
import javax.jms.Message;

public class NumericBinarySelector
extends Selector {
    static L10N L = new L10N(NumericBinarySelector._resin_compat_class_0());
    private int _token;
    private Selector _left;
    private Selector _right;
    private static Class _resin_compat_class_0;

    NumericBinarySelector(int token, Selector left, Selector right) {
        this._token = token;
        this._left = left;
        this._right = right;
    }

    Object evaluate(Message message) throws JMSException {
        Object lobj = this._left.evaluate(message);
        Object robj = this._right.evaluate(message);
        if (!(lobj instanceof Number) || !(robj instanceof Number)) {
            return NULL;
        }
        if (NumericBinarySelector.isInteger(lobj) && NumericBinarySelector.isInteger(robj)) {
            long lvalue = this.toLong(lobj);
            long rvalue = this.toLong(robj);
            switch (this._token) {
                case 43: {
                    return new Long(lvalue + rvalue);
                }
                case 45: {
                    return new Long(lvalue - rvalue);
                }
                case 42: {
                    return new Long(lvalue * rvalue);
                }
                case 47: {
                    return new Long(lvalue / rvalue);
                }
            }
            throw new RuntimeException("Unknown expression");
        }
        double lvalue = ((Number)lobj).doubleValue();
        double rvalue = ((Number)robj).doubleValue();
        switch (this._token) {
            case 43: {
                return new Double(lvalue + rvalue);
            }
            case 45: {
                return new Double(lvalue - rvalue);
            }
            case 42: {
                return new Double(lvalue * rvalue);
            }
            case 47: {
                return new Double(lvalue / rvalue);
            }
        }
        throw new RuntimeException("Unknown expression");
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jms.selector.Selector");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

