/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.resource;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.types.InitProgram;
import com.caucho.jms.AbstractDestination;
import com.caucho.jms.ConnectionFactoryImpl;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;

public class ListenerResource {
    private static L10N L = new L10N(ListenerResource._resin_compat_class_0());
    protected static Logger log = Log.open(ListenerResource._resin_compat_class_0());
    private ConnectionFactory _connFactory;
    private Connection _conn;
    private Destination _destination;
    private int _listenerMax = 5;
    private ListenerConfig _listenerConfig;
    private static Class _resin_compat_class_0;

    public void setConnectionFactory(ConnectionFactory factory) {
        this._connFactory = factory;
    }

    public void setDestination(Destination destination) {
        this._destination = destination;
    }

    public void setListener(ListenerConfig config) {
        this._listenerConfig = config;
    }

    public void init() throws ConfigException, JMSException {
        if (this._destination == null) {
            throw new ConfigException(L.l("'destination' is required for ListenerResource."));
        }
        if (this._listenerConfig == null) {
            throw new ConfigException(L.l("'listener' is required for ListenerResource."));
        }
        if (this._connFactory == null && this._destination instanceof AbstractDestination) {
            this._connFactory = new ConnectionFactoryImpl();
        }
        if (this._connFactory == null) {
            throw new ConfigException(L.l("connection-factory is required for ListenerResource."));
        }
        this._conn = this._connFactory.createConnection();
    }

    public void start() throws Throwable {
        for (int i = 0; i < this._listenerMax; ++i) {
            MessageListener listener = this._listenerConfig.newInstance();
            Session session = this._conn.createSession(false, 1);
            MessageConsumer consumer = session.createConsumer(this._destination);
            consumer.setMessageListener(listener);
        }
        this._conn.start();
        log.fine(new CharBuffer().append("ListenerResource[").append(this._destination).append("] started").toString());
    }

    public void stop() throws JMSException {
        this._conn.stop();
        log.fine(new CharBuffer().append("ListenerResource[").append(this._destination).append("] stopped").toString());
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jms.resource.ListenerResource");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static class ListenerConfig {
        private Class _type;
        private InitProgram _init;
        private static Class _resin_compat_class_0;

        public void setType(Class type) throws ConfigException {
            Config.validate(type, ListenerConfig._resin_compat_class_0());
            this._type = type;
        }

        public void setInit(InitProgram init) {
            this._init = init;
        }

        public void init() throws ConfigException {
            if (this._type == null) {
                throw new ConfigException(L.l("'type' is required for listener."));
            }
        }

        public MessageListener newInstance() throws Throwable, InstantiationException {
            MessageListener listener = (MessageListener)this._type.newInstance();
            if (this._init != null) {
                this._init.configure(listener);
            }
            return listener;
        }

        private static Class _resin_compat_class_0() {
            try {
                Class<?> clazz = _resin_compat_class_0;
                if (clazz == null) {
                    clazz = _resin_compat_class_0 = Class.forName("javax.jms.MessageListener");
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
    }
}

