/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.jdbc;

import com.caucho.config.ConfigException;
import com.caucho.config.types.Period;
import com.caucho.jdbc.JdbcMetaData;
import com.caucho.jms.jdbc.JdbcMessage;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class JdbcManager {
    static final Logger log = Log.open(JdbcManager._resin_compat_class_0());
    static final L10N L = new L10N(JdbcManager._resin_compat_class_0());
    private DataSource _dataSource;
    private String _messageTable = "resin_jms_message";
    private String _destinationTable = "resin_jms_destination";
    private String _destinationSequence;
    private String _consumerTable = "resin_jms_consumer";
    private String _consumerSequence;
    private String _blob;
    private String _longType;
    private long _purgeInterval = 60000L;
    private JdbcMessage _jdbcMessage;
    private volatile boolean _isInit;
    private static Class _resin_compat_class_0;

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this._dataSource;
    }

    public String getMessageTable() {
        return this._messageTable;
    }

    public void setMessageTable(String tableName) {
        this._messageTable = tableName;
    }

    public String getDestinationTable() {
        return this._destinationTable;
    }

    public void setDestinationTable(String tableName) {
        this._destinationTable = tableName;
    }

    public String getDestinationSequence() {
        return this._destinationSequence;
    }

    public String getConsumerTable() {
        return this._consumerTable;
    }

    public void setConsumerTable(String tableName) {
        this._consumerTable = tableName;
    }

    public String getConsumerSequence() {
        return this._consumerSequence;
    }

    public JdbcMetaData getMetaData() {
        return JdbcMetaData.create(this._dataSource);
    }

    public String getBlob() {
        if (this._blob == null) {
            this._blob = this.getMetaData().getBlobType();
        }
        return this._blob;
    }

    public String getLongType() {
        if (this._longType == null) {
            this._longType = this.getMetaData().getLongType();
        }
        return this._longType;
    }

    public void setPurgeInterval(Period period) {
        this._purgeInterval = period.getPeriod();
    }

    public long getPurgeInterval() {
        return this._purgeInterval;
    }

    public JdbcMessage getJdbcMessage() {
        return this._jdbcMessage;
    }

    public void init() throws ConfigException, SQLException {
        if (this._isInit) {
            return;
        }
        this._isInit = true;
        if (this._dataSource == null) {
            throw new ConfigException(L.l("JdbcManager requires a <data-source> element."));
        }
        this._jdbcMessage = new JdbcMessage(this);
        this._jdbcMessage.init();
        this.initDestinationTable();
        this.initConsumerTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initDestinationTable() throws SQLException {
        Connection conn = this._dataSource.getConnection();
        if (!this.getMetaData().supportsIdentity()) {
            this._destinationSequence = new CharBuffer().append(this._destinationTable).append("_cseq").toString();
        }
        try {
            Statement stmt = conn.createStatement();
            String sql = new CharBuffer().append("SELECT 1 FROM ").append(this._destinationTable).append(" WHERE 1=0").toString();
            try {
                ResultSet rs = stmt.executeQuery(sql);
                rs.next();
                rs.close();
                stmt.close();
                return;
            }
            catch (SQLException e) {
                block8: {
                    log.finest(e.toString());
                    log.info(L.l("creating JMS destination table {0}", this._destinationTable));
                    String identity = "";
                    if (this.getMetaData().supportsIdentity()) {
                        identity = " auto_increment";
                    }
                    String longType = this.getLongType();
                    sql = new CharBuffer().append("CREATE TABLE ").append(this._destinationTable).append(" (").append("  id ").append(longType).append(" PRIMARY KEY ").append(identity).append(",").append("  name VARCHAR(255),").append("  is_topic INTEGER").append(")").toString();
                    stmt.executeUpdate(sql);
                    if (this.getMetaData().supportsIdentity()) break block8;
                    this._destinationSequence = new CharBuffer().append(this._destinationTable).append("_cseq").toString();
                    stmt.executeUpdate(this.getMetaData().createSequenceSQL(this._destinationSequence, 1));
                }
                conn.close();
            }
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initConsumerTable() throws SQLException {
        if (!this.getMetaData().supportsIdentity()) {
            this._consumerSequence = new CharBuffer().append(this._consumerTable).append("_cseq").toString();
        }
        Connection conn = this._dataSource.getConnection();
        try {
            Statement stmt = conn.createStatement();
            String sql = new CharBuffer().append("SELECT 1 FROM ").append(this._consumerTable).append(" WHERE 1=0").toString();
            try {
                ResultSet rs = stmt.executeQuery(sql);
                rs.next();
                rs.close();
                stmt.close();
                return;
            }
            catch (SQLException e) {
                block8: {
                    log.finest(e.toString());
                    log.info(L.l("creating JMS subscriber table {0}", this._consumerTable));
                    String longType = this.getLongType();
                    String identity = "";
                    if (this.getMetaData().supportsIdentity()) {
                        identity = " auto_increment";
                    }
                    sql = new CharBuffer().append("CREATE TABLE ").append(this._consumerTable).append(" (").append("  s_id ").append(longType).append(" PRIMARY KEY ").append(identity).append(",").append("  queue ").append(longType).append(",").append("  client VARCHAR(255),").append("  name VARCHAR(255),").append("  expire ").append(longType).append(",").append("  read_id ").append(longType).append(",").append("  ack_id ").append(longType).append(")").toString();
                    stmt.executeUpdate(sql);
                    if (this._consumerSequence == null) break block8;
                    stmt.executeUpdate(this.getMetaData().createSequenceSQL(this._consumerSequence, 1));
                }
                conn.close();
            }
        }
        finally {
            conn.close();
        }
    }

    public int hashCode() {
        if (this._dataSource == null) {
            return 0;
        }
        return this._dataSource.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JdbcManager)) {
            return false;
        }
        JdbcManager manager = (JdbcManager)o;
        return this._dataSource != null && this._dataSource.equals(manager._dataSource);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jms.jdbc.JdbcManager");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

