/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.jdbc;

import com.caucho.config.ConfigException;
import com.caucho.jdbc.JdbcMetaData;
import com.caucho.jms.AbstractDestination;
import com.caucho.jms.jdbc.JdbcManager;
import com.caucho.jms.jdbc.JdbcMessage;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class JdbcDestination
extends AbstractDestination {
    static final Logger log = Log.open(JdbcDestination._resin_compat_class_0());
    static final L10N L = new L10N(JdbcDestination._resin_compat_class_0());
    protected JdbcManager _jdbcManager = new JdbcManager();
    private DataSource _dataSource;
    private String _name;
    private long _lastPurgeTime;
    private static Class _resin_compat_class_0;

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public boolean isTopic() {
        return false;
    }

    public void setJdbcManager(JdbcManager jdbcManager) {
        this._jdbcManager = jdbcManager;
    }

    public JdbcManager getJdbcManager() {
        return this._jdbcManager;
    }

    public void setDataSource(DataSource dataSource) {
        this._jdbcManager.setDataSource(dataSource);
    }

    public void init() throws ConfigException, SQLException {
        this._jdbcManager.init();
        this._dataSource = this._jdbcManager.getDataSource();
    }

    protected int createDestination(String name, boolean isTopic) throws SQLException {
        Connection conn = this._jdbcManager.getDataSource().getConnection();
        String destinationTable = this._jdbcManager.getDestinationTable();
        String destinationSequence = this._jdbcManager.getDestinationSequence();
        try {
            String sql = new CharBuffer().append("SELECT id FROM ").append(destinationTable).append(" WHERE name=? AND is_topic=?").toString();
            PreparedStatement pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, name);
            pstmt.setInt(2, isTopic ? 1 : 0);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
            rs.close();
            if (destinationSequence != null) {
                JdbcMetaData metaData = this._jdbcManager.getMetaData();
                sql = metaData.selectSequenceSQL(destinationSequence);
                int id = 0;
                pstmt = conn.prepareStatement(sql);
                rs = pstmt.executeQuery();
                if (!rs.next()) {
                    throw new RuntimeException("can't create sequence");
                }
                id = rs.getInt(1);
                sql = new CharBuffer().append("INSERT INTO ").append(destinationTable).append(" (id,name,is_topic) VALUES(?,?,?)").toString();
                pstmt = conn.prepareStatement(sql);
                pstmt.setInt(1, id);
                pstmt.setString(2, name);
                pstmt.setInt(3, isTopic ? 1 : 0);
                pstmt.executeUpdate();
                if (isTopic) {
                    log.fine(new CharBuffer().append("JMSTopic[").append(name).append(",").append(id).append("] created").toString());
                } else {
                    log.fine(new CharBuffer().append("JMSQueue[").append(name).append(",").append(id).append("] created").toString());
                }
                int n = id;
                return n;
            }
            sql = new CharBuffer().append("INSERT INTO ").append(destinationTable).append(" (name,is_topic) VALUES(?,?)").toString();
            pstmt = conn.prepareStatement(sql, 1);
            pstmt.setString(1, name);
            pstmt.setInt(2, isTopic ? 1 : 0);
            pstmt.executeUpdate();
            rs = pstmt.getGeneratedKeys();
            if (rs.next()) {
                int id = rs.getInt(1);
                if (isTopic) {
                    log.fine(new CharBuffer().append("JMSTopic[").append(name).append(",").append(id).append("] created").toString());
                } else {
                    log.fine(new CharBuffer().append("JMSQueue[").append(name).append(",").append(id).append("] created").toString());
                }
                int n = id;
                return n;
            }
            throw new SQLException(L.l("can't generate destination for {0}", name));
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void purgeExpiredMessages() {
        long purgeInterval = this._jdbcManager.getPurgeInterval();
        long now = Alarm.getCurrentTime();
        if (now < this._lastPurgeTime + purgeInterval) {
            return;
        }
        this._lastPurgeTime = now;
        try {
            DataSource dataSource = this._jdbcManager.getDataSource();
            String messageTable = this._jdbcManager.getMessageTable();
            JdbcMessage jdbcMessage = this._jdbcManager.getJdbcMessage();
            Connection conn = dataSource.getConnection();
            try {
                String sql = new CharBuffer().append("DELETE FROM ").append(messageTable).append(" WHERE expire < ? AND consumer IS NULL").toString();
                PreparedStatement pstmt = conn.prepareStatement(sql);
                pstmt.setLong(1, Alarm.getCurrentTime());
                int count = pstmt.executeUpdate();
                if (count > 0) {
                    log.fine(new CharBuffer().append("JMSQueue[").append(this.getName()).append("] purged ").append(count).append(" expired mesages").toString());
                }
                pstmt.close();
            }
            finally {
                conn.close();
            }
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jms.jdbc.JdbcDestination");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

