/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.burlap;

import com.caucho.ejb.burlap.BurlapReader;
import com.caucho.ejb.burlap.BurlapWriter;
import com.caucho.jms.AbstractQueue;
import com.caucho.jms.session.MessageAvailableListener;
import com.caucho.log.Log;
import com.caucho.services.message.MessageSender;
import com.caucho.services.message.MessageServiceException;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;

public class BurlapQueue
extends AbstractQueue
implements MessageSender {
    static final Logger log = Log.open(BurlapQueue._resin_compat_class_0());
    static final L10N L = new L10N(BurlapQueue._resin_compat_class_0());
    private String _queueName;
    private String _url;
    private Path _path;
    private static Class _resin_compat_class_0;

    public String getQueueName() {
        return this._queueName;
    }

    public void setQueueName(String name) {
        this._queueName = name;
    }

    public void setURL(String url) {
        this._url = url;
    }

    public String getURL() {
        return this._url;
    }

    public void setPath(Path path) {
        this._path = path;
    }

    public Path getPath() {
        if (this._path == null) {
            this._path = Vfs.lookup(this._url);
        }
        return this._path;
    }

    public void addListener(MessageAvailableListener listener) {
        throw new UnsupportedOperationException();
    }

    public void send(Message message) throws JMSException {
        try {
            HashMap<String, Object> headers = new HashMap<String, Object>();
            Enumeration names = message.getPropertyNames();
            while (names != null && names.hasMoreElements()) {
                String name = (String)names.nextElement();
                Object value = message.getObjectProperty(name);
                headers.put(name, value);
            }
            if (message instanceof TextMessage) {
                this.send(headers, ((TextMessage)message).getText());
            } else if (message instanceof ObjectMessage) {
                this.send(headers, ((ObjectMessage)message).getObject());
            } else {
                this.send(headers, message);
            }
        }
        catch (Exception e) {
            throw new JMSException(String.valueOf(e));
        }
    }

    public void send(HashMap headers, Object data) throws MessageServiceException {
        ReadStream is = null;
        WriteStream os = null;
        try {
            ReadWritePair pair = this.getPath().openReadWrite();
            is = pair.getReadStream();
            os = pair.getWriteStream();
            BurlapWriter out = new BurlapWriter(os);
            BurlapReader in = new BurlapReader(is);
            out.startCall("send");
            out.writeObject(headers);
            out.writeObject(data);
            out.completeCall();
            os.flush();
            String status = (String)is.getAttribute("status");
            if (!"200".equals(status)) {
                int ch;
                CharBuffer errorMsg = new CharBuffer();
                while ((ch = is.readChar()) >= 0) {
                    errorMsg.append((char)ch);
                }
                throw new MessageServiceException(errorMsg.toString());
            }
            Object result = in.readReply(null);
        }
        catch (Throwable e) {
            throw new MessageServiceException(e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public String toString() {
        return new CharBuffer().append("BurlapQueue[").append(this._queueName).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jms.burlap.BurlapQueue");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

