/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca;

import com.caucho.jca.WorkThread;
import com.caucho.log.Log;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import com.caucho.util.ThreadPool;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;

public class WorkManagerImpl
implements WorkManager {
    private static final L10N L = new L10N(WorkManagerImpl._resin_compat_class_0());
    private static final Logger log = Log.open(WorkManagerImpl._resin_compat_class_0());
    private ArrayList<Work> _activeTasks = new ArrayList();
    private volatile boolean _isClosed;
    private static Class _resin_compat_class_0;

    WorkManagerImpl() {
    }

    public void doWork(Work work) throws WorkException {
        this.doWork(work, Long.MAX_VALUE, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork(Work work, long startTimeout, ExecutionContext context, WorkListener listener) throws WorkException {
        boolean isStart = false;
        try {
            WorkException exn = null;
            WorkManagerImpl workManagerImpl = this;
            synchronized (workManagerImpl) {
                if (this._isClosed) {
                    exn = new WorkException(L.l("Work task can't be started from closed context."));
                } else if (this._activeTasks.contains(work)) {
                    exn = new WorkException(L.l("Reentrant Work tasks are not allowed."));
                } else {
                    isStart = true;
                    this._activeTasks.add(work);
                }
            }
            if (listener != null) {
                if (isStart) {
                    listener.workAccepted(new WorkEvent((Object)this, 1, work, null, 0L));
                } else {
                    listener.workRejected(new WorkEvent((Object)this, 2, work, exn, 0L));
                }
            }
            if (exn != null) {
                throw exn;
            }
            if (listener != null) {
                listener.workStarted(new WorkEvent((Object)this, 3, work, null, 0L));
            }
            work.run();
            if (listener != null) {
                listener.workCompleted(new WorkEvent((Object)this, 4, work, null, 0L));
            }
        }
        finally {
            WorkManagerImpl workManagerImpl = this;
            synchronized (workManagerImpl) {
                this._activeTasks.remove(work);
            }
        }
    }

    public long startWork(Work work) throws WorkException {
        return this.startWork(work, Long.MAX_VALUE, null, null);
    }

    public long startWork(Work work, long startTimeout, ExecutionContext context, WorkListener listener) throws WorkException {
        long start = Alarm.getCurrentTime();
        this.startWork(work, startTimeout, context, listener, true);
        return Alarm.getCurrentTime() - start;
    }

    public void scheduleWork(Work work) throws WorkException {
        this.scheduleWork(work, Long.MAX_VALUE, null, null);
    }

    public void scheduleWork(Work work, long startTimeout, ExecutionContext context, WorkListener listener) throws WorkException {
        this.startWork(work, startTimeout, context, listener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long startWork(Work work, long startTimeout, ExecutionContext context, WorkListener listener, boolean waitForStart) throws WorkException {
        WorkManagerImpl workManagerImpl;
        boolean isStart = false;
        WorkException exn = null;
        try {
            workManagerImpl = this;
            synchronized (workManagerImpl) {
                if (this._isClosed) {
                    exn = new WorkException(L.l("Work task can't be started from closed context."));
                } else if (this._activeTasks.contains(work)) {
                    exn = new WorkException(L.l("Reentrant Work tasks are not allowed."));
                } else {
                    this._activeTasks.add(work);
                }
            }
            if (exn != null) {
                if (listener != null) {
                    listener.workRejected(new WorkEvent((Object)this, 2, work, exn, 0L));
                }
                throw exn;
            }
            if (listener != null) {
                listener.workAccepted(new WorkEvent((Object)this, 1, work, null, 0L));
            }
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            WorkThread workThread = new WorkThread(this, work, loader, listener);
            if (listener != null) {
                listener.workStarted(new WorkEvent((Object)this, 3, work, null, 0L));
            }
            isStart = waitForStart ? ThreadPool.start(workThread, startTimeout) : ThreadPool.schedule(workThread, startTimeout);
        }
        finally {
            workManagerImpl = this;
            synchronized (workManagerImpl) {
                if (!isStart) {
                    this._activeTasks.remove(work);
                }
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completeWork(Work work) {
        WorkManagerImpl workManagerImpl = this;
        synchronized (workManagerImpl) {
            this._activeTasks.remove(work);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        WorkManagerImpl workManagerImpl = this;
        synchronized (workManagerImpl) {
            if (this._isClosed) {
                return;
            }
            this._isClosed = true;
        }
        ArrayList<Work> activeTasks = new ArrayList<Work>();
        WorkManagerImpl workManagerImpl2 = this;
        synchronized (workManagerImpl2) {
            activeTasks.addAll(this._activeTasks);
        }
        for (int i = 0; i < activeTasks.size(); ++i) {
            ((Work)activeTasks.get(i)).release();
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jca.WorkManagerImpl");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

