/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca;

import com.caucho.jca.ConnectionPool;
import com.caucho.jca.PoolItem;
import com.caucho.jca.UserTransactionImpl;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.RollbackException;

class UserPoolItem {
    private static final L10N L;
    private static final Logger log;
    private ConnectionPool _cm;
    private String _id;
    private PoolItem _ownPoolItem;
    private ManagedConnectionFactory _mcf;
    private Subject _subject;
    private ConnectionRequestInfo _info;
    private UserTransactionImpl _transaction;
    private PoolItem _sharePoolItem;
    private UserPoolItem _shareNext;
    private UserPoolItem _sharePrev;
    private Object _userConn;
    private boolean _hasConnectionError;
    private IllegalStateException _allocationStackTrace;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static Class _resin_compat_class_0;

    public UserPoolItem(ConnectionPool cm) {
        this._cm = cm;
        this._id = this._cm.generateId();
        this._transaction = this._cm.getTransaction();
        if (cm.getSaveAllocationStackTrace()) {
            this._allocationStackTrace = new IllegalStateException(L.l(new CharBuffer().append("unclosed connection: ").append(this).append(" was allocated at").toString()));
            this._allocationStackTrace.fillInStackTrace();
        }
    }

    public UserPoolItem(ConnectionPool cm, PoolItem poolItem) {
        this(cm);
        this._ownPoolItem = poolItem;
        this._sharePoolItem = poolItem;
    }

    public void setManagedConnectionFactory(ManagedConnectionFactory mcf) {
        this._mcf = mcf;
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this._mcf;
    }

    public void setSubject(Subject subject) {
        this._subject = subject;
    }

    public Subject getSubject() {
        return this._subject;
    }

    public void setInfo(ConnectionRequestInfo info) {
        this._info = info;
    }

    public ConnectionRequestInfo getInfo() {
        return this._info;
    }

    public boolean isActive() {
        return this._userConn != null;
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        this._hasConnectionError = true;
    }

    public boolean isConnectionError() {
        return this._hasConnectionError;
    }

    public IllegalStateException getAllocationStackTrace() {
        return this._allocationStackTrace;
    }

    public void setSaveAllocationStackTrace(boolean enable) {
        this._cm.setSaveAllocationStackTrace(enable);
    }

    public PoolItem getOwnPoolItem() {
        return this._ownPoolItem;
    }

    public PoolItem getXAPoolItem() {
        return this._sharePoolItem;
    }

    public Object getUserConnection() {
        return this._userConn;
    }

    Object allocateUserConnection() throws ResourceException {
        if (this._userConn == null) {
            this._userConn = this._sharePoolItem.allocateConnection();
        }
        return this._userConn;
    }

    public void setUserConnection(Object userConn) {
        this._userConn = userConn;
    }

    UserPoolItem getShareNext() {
        return this._shareNext;
    }

    void associatePoolItem(PoolItem poolItem) {
        if (this._ownPoolItem != null) {
            throw new IllegalStateException(L.l("associating with old pool item."));
        }
        this._ownPoolItem = poolItem;
        if (this._sharePoolItem != null) {
            this.removeFromShareList();
        }
        this.addToShareList(poolItem);
    }

    void associate(PoolItem poolItem, ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo info) {
        if (this._sharePoolItem != null) {
            this.removeFromShareList();
        }
        this._mcf = mcf;
        this._subject = subject;
        this._info = info;
        this.addToShareList(poolItem);
        if (this._transaction != null) {
            try {
                this._transaction.enlistResource(this);
            }
            catch (RollbackException e) {
                this.removeFromShareList();
                poolItem.toIdle();
                throw new RuntimeException(e);
            }
            catch (Throwable e) {
                this.removeFromShareList();
                poolItem.setConnectionError();
                poolItem.toIdle();
                throw new RuntimeException(e);
            }
        }
    }

    void reassociatePoolItem() throws ResourceException {
        if (this._ownPoolItem == null) {
            UserPoolItem item = this._cm.allocatePool(this._mcf, this._subject, this._info, this);
            if (!$assertionsDisabled && item != this) {
                throw new AssertionError();
            }
            this._ownPoolItem = item.getOwnPoolItem();
        }
        if (this._sharePoolItem != null) {
            this.removeFromShareList();
        }
        this.addToShareList(this._ownPoolItem);
    }

    void abortConnection() throws ResourceException {
        PoolItem poolItem = this._ownPoolItem;
        this._ownPoolItem = null;
        this.removeFromShareList();
        if (poolItem != null) {
            poolItem.abortConnection();
        }
    }

    void close() {
        PoolItem ownPoolItem = this._ownPoolItem;
        this._ownPoolItem = null;
        this._userConn = null;
        if (this._transaction != null) {
            this._transaction.delistResource(this);
        }
        this.removeFromShareList();
        if (ownPoolItem != null) {
            ownPoolItem.toIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromShareList() {
        PoolItem poolItem = this._sharePoolItem;
        this._sharePoolItem = null;
        if (poolItem == null) {
            return;
        }
        Object object = poolItem._shareLock;
        synchronized (object) {
            UserPoolItem prev = this._sharePrev;
            UserPoolItem next = this._shareNext;
            this._sharePrev = null;
            this._shareNext = null;
            if (prev != null) {
                prev._shareNext = next;
            } else {
                poolItem._shareHead = next;
            }
            if (next != null) {
                next._sharePrev = prev;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToShareList(PoolItem poolItem) {
        if (this._sharePoolItem != null) {
            throw new IllegalStateException();
        }
        Object object = poolItem._shareLock;
        synchronized (object) {
            this._sharePoolItem = poolItem;
            this._sharePrev = null;
            this._shareNext = poolItem._shareHead;
            if (poolItem._shareHead != null) {
                poolItem._shareHead._sharePrev = this;
            }
            poolItem._shareHead = this;
        }
    }

    boolean isClosed() {
        return this._sharePoolItem == null;
    }

    public String toString() {
        return new CharBuffer().append("UserPoolItem[").append(this._cm.getName()).append(",").append(this._id).append("]").toString();
    }

    static {
        $assertionsDisabled = !UserPoolItem._resin_compat_class_0().desiredAssertionStatus();
        L = new L10N(UserPoolItem._resin_compat_class_0());
        log = Log.open(UserPoolItem._resin_compat_class_0());
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jca.UserPoolItem");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

