/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca;

import com.caucho.config.ConfigException;
import com.caucho.jca.ResourceArchive;
import com.caucho.jca.ResourceArchiveManager;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDeploy {
    private static final L10N L = new L10N(ResourceDeploy._resin_compat_class_0());
    private Path _rarDir;
    private Path _rarExpandDir;
    private String _expandPrefix = "";
    private HashSet<String> _rarNames = new HashSet();
    private volatile boolean _isInit;
    private static Class _resin_compat_class_0;

    public ResourceDeploy() {
        this.setExpandPrefix("_rar_");
    }

    public Path getPath() {
        return this._rarDir;
    }

    public void setPath(Path path) {
        this._rarDir = path;
    }

    public void setExpandPath(Path path) {
        this._rarExpandDir = path;
    }

    public Path getExpandPath() {
        if (this._rarExpandDir != null) {
            return this._rarExpandDir;
        }
        return this._rarDir;
    }

    public String getExpandPrefix() {
        return this._expandPrefix;
    }

    public void setExpandPrefix(String prefix) {
        this._expandPrefix = prefix;
    }

    public boolean isModified() {
        try {
            return !this._rarNames.equals(this.getRarNames());
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ConfigException {
        ResourceDeploy resourceDeploy = this;
        synchronized (resourceDeploy) {
            if (this._isInit) {
                return;
            }
            this._isInit = true;
        }
        if (this.getPath() == null) {
            throw new ConfigException(L.l("resource-deploy requires a path attribute"));
        }
        try {
            this._rarNames = this.getRarNames();
            for (String name : this._rarNames) {
                ResourceArchive rar = new ResourceArchive();
                rar.setRarPath(this.getPath().lookup(new CharBuffer().append(name).append(".rar").toString()));
                rar.setRootDirectory(this.getExpandPath().lookup(new CharBuffer().append(this.getExpandPrefix()).append(name).toString()));
                rar.init();
                ResourceArchiveManager.addResourceArchive(rar);
            }
        }
        catch (IOException e) {
            throw new ConfigException(e);
        }
    }

    private HashSet<String> getRarNames() throws IOException {
        HashSet<String> rarNames = new HashSet<String>();
        Path rarDir = this.getPath();
        Path rarExpandDir = this.getExpandPath();
        if (rarDir == null || rarExpandDir == null) {
            return rarNames;
        }
        String[] rarDirList = rarDir.list();
        for (int i = 0; i < rarDirList.length; ++i) {
            Path path;
            String rarName = rarDirList[i];
            if (!rarName.endsWith(".rar") || !(path = rarDir.lookup(rarName)).canRead()) continue;
            String appName = rarName.substring(0, rarName.length() - 4);
            if (CauchoSystem.isCaseInsensitive()) {
                appName = appName.toLowerCase();
            }
            rarNames.add(appName);
        }
        String[] rarExpandList = rarExpandDir.list();
        ArrayList<String> newNames = new ArrayList<String>();
        for (int i = 0; i < rarExpandList.length; ++i) {
            Path path;
            String rarDirName = rarExpandList[i];
            if (!rarDirName.startsWith(this.getExpandPrefix())) continue;
            if (CauchoSystem.isCaseInsensitive()) {
                rarDirName = rarDirName.toLowerCase();
            }
            if (!(path = rarExpandDir.lookup(rarDirName)).isDirectory() || !rarDirName.startsWith(this.getExpandPrefix())) continue;
            String appName = rarDirName.substring(this.getExpandPrefix().length());
            if (!newNames.contains(appName)) {
                newNames.add(appName);
            }
            rarNames.add(appName);
        }
        return rarNames;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jca.ResourceDeploy");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

