/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca;

import com.caucho.config.BuilderProgram;
import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.types.InitProgram;
import com.caucho.jca.ConnectionPool;
import com.caucho.jca.ResourceManagerImpl;
import com.caucho.jmx.AbstractMBeanServer;
import com.caucho.jmx.IntrospectionMBean;
import com.caucho.jmx.Jmx;
import com.caucho.loader.ClassLoaderListener;
import com.caucho.loader.CloseListener;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentListener;
import com.caucho.loader.StartListener;
import com.caucho.naming.Jndi;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.NotificationFilter;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;

public class Resource {
    private static L10N L = new L10N(Resource._resin_compat_class_1());
    private Class _type;
    private String _var;
    private String _jndiName;
    private String _mbeanName;
    private Class _mbeanInterface;
    private ArrayList<Object> _args = new ArrayList();
    private boolean _isPreInit;
    private boolean _localTransactionOptimization = true;
    private boolean _shareable = true;
    private Object _object;
    private MBeanInfo _mbeanInfo;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    public void setVar(String var) {
        this._var = var;
    }

    public void setJndiName(String name) {
        this._jndiName = name;
    }

    public String getJndiName() {
        return this._jndiName;
    }

    public void setMbeanName(String name) {
        this._mbeanName = name;
    }

    public String getMbeanName() {
        return this._mbeanName;
    }

    public void setType(Class resourceClass) {
        this._type = resourceClass.getName().equals("javax.mail.Session") ? Resource._resin_compat_class_0() : resourceClass;
    }

    public Class getType() {
        return this._type;
    }

    public void setMBeanInterface(Class cl) {
        this._mbeanInterface = cl;
    }

    public void addArg(Object arg) {
        this._args.add(arg);
    }

    public void setLocalTransactionOptimization(boolean enable) {
        this._localTransactionOptimization = enable;
    }

    public void setShareable(boolean shareable) {
        this._shareable = shareable;
    }

    public void addInit(InitProgram init) throws Throwable {
        this.preInit();
        init.configure(this._object);
    }

    public Object createListener() throws Throwable {
        return this.createMbeanListener();
    }

    public Object createMbeanListener() throws Throwable {
        this.preInit();
        if (this._mbeanName != null) {
            return new MBeanListener();
        }
        throw new ConfigException(L.l("<listener> needs a <resource> with an mbean-name."));
    }

    ObjectName getObjectName() throws Throwable {
        this.preInit();
        if (this._mbeanName != null) {
            return Jmx.getObjectName(this._mbeanName);
        }
        return null;
    }

    MBeanInfo getMBeanInfo() throws Throwable {
        this.preInit();
        return this._mbeanInfo;
    }

    private void preInit() throws Throwable {
        if (this._isPreInit) {
            return;
        }
        this._isPreInit = true;
        Object oldObject = null;
        if (this._jndiName != null) {
            try {
                String jndiName = Jndi.getFullName(this._jndiName);
                InitialContext ic = new InitialContext();
                oldObject = ic.lookup(this._jndiName);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        AbstractMBeanServer mbeanServer = Jmx.getMBeanServer();
        ObjectName mbeanName = null;
        if (this._mbeanName != null) {
            mbeanName = Jmx.getObjectName(this._mbeanName);
        }
        if (this._type == null) {
            if (oldObject != null) {
                this._object = oldObject;
                return;
            }
            if (mbeanName != null && mbeanServer.getMBeanInfo(mbeanName) != null) {
                return;
            }
            throw new ConfigException(L.l("<resource> configuration needs a <type>.  The <type> is the class name of the resource bean."));
        }
        Constructor constructor = this.getConstructor(this._args.size());
        Class<?>[] params = constructor.getParameterTypes();
        Object[] args = new Object[this._args.size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this._args.get(i);
        }
        this._object = constructor.newInstance(args);
        if (mbeanName != null) {
            Object mbean = this._object;
            if (this._mbeanInterface != null) {
                mbean = new IntrospectionMBean(mbean, this._mbeanInterface);
            }
            Jmx.register(mbean, mbeanName);
            this._mbeanInfo = mbeanServer.getMBeanInfo(mbeanName);
        }
    }

    private Constructor getConstructor(int len) throws Exception {
        Constructor<?>[] constructors = this._type.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            if (constructors[i].getParameterTypes().length != len) continue;
            return constructors[i];
        }
        throw new ConfigException(L.l("`{0}' has no matching constructors.", this._type.getName()));
    }

    public void init() throws Throwable {
        Object listener;
        this.preInit();
        if (this._type == null || this._object == null) {
            return;
        }
        Config.init(this._object);
        this._object = Config.replaceObject(this._object);
        if (this._object instanceof ClassLoaderListener) {
            listener = (ClassLoaderListener)this._object;
            Environment.addClassLoaderListener((ClassLoaderListener)listener);
        }
        if (this._object instanceof EnvironmentListener) {
            listener = (EnvironmentListener)this._object;
            Environment.addEnvironmentListener((EnvironmentListener)listener);
        }
        Object jndiObject = this._object;
        boolean isStart = false;
        if (this._object instanceof ResourceAdapter) {
            ResourceManagerImpl.addResource((ResourceAdapter)this._object);
            isStart = true;
        }
        if (this._object instanceof ManagedConnectionFactory) {
            ResourceManagerImpl rm = ResourceManagerImpl.createLocalManager();
            ManagedConnectionFactory mcf = (ManagedConnectionFactory)this._object;
            ConnectionPool cm = rm.createConnectionPool();
            cm.setShareable(this._shareable);
            cm.setLocalTransactionOptimization(this._localTransactionOptimization);
            Object connectionFactory = cm.init(mcf);
            cm.start();
            jndiObject = connectionFactory;
            isStart = true;
        }
        Method start = null;
        try {
            start = this._object.getClass().getMethod("start", new Class[0]);
        }
        catch (Throwable e) {
            // empty catch block
        }
        Method stop = null;
        try {
            stop = this._object.getClass().getMethod("stop", new Class[0]);
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (this._jndiName != null) {
            Jndi.bindDeepShort(this._jndiName, jndiObject);
        }
        if (this._var != null) {
            Config.setCurrentVar(this._var, jndiObject);
        }
        if (!isStart) {
            if (start != null || stop != null) {
                Environment.addEnvironmentListener(new StartListener(this._object));
            } else if (CloseListener.getDestroyMethod(this._object.getClass()) != null) {
                Environment.addClassLoaderListener(new CloseListener(this._object));
            }
        }
    }

    public String toString() {
        if (this._mbeanName != null) {
            return new CharBuffer().append("Resource[").append(this._mbeanName).append("]").toString();
        }
        return new CharBuffer().append("Resource[").append(this._jndiName).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.jca.cfg.JavaMailConfig");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.jca.Resource");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public class MBeanListener {
        private String _mbeanName;
        private Object _handback;
        private NotificationFilter _filter;

        public void setMBeanName(String name) {
            this._mbeanName = name;
        }

        public String getMBeanName() {
            return this._mbeanName;
        }

        public void setHandback(Object handback) {
            this._handback = handback;
        }

        public Object getHandback() {
            return this._handback;
        }

        public void init() throws Throwable {
            if (this._mbeanName == null) {
                throw new ConfigException(L.l("mbean name is required"));
            }
            ObjectName mbeanName = Jmx.getObjectName(this._mbeanName);
            ObjectName listenerName = Resource.this.getObjectName();
            AbstractMBeanServer server = Jmx.getMBeanServer();
            server.addNotificationListener(mbeanName, listenerName, this._filter, this._handback);
        }
    }

    public class MBeanInit {
        public void setProperty(String attrName, BuilderProgram program) throws Throwable {
            MBeanAttributeInfo attr = this.getAttribute(attrName);
            if (attr == null) {
                throw new ConfigException(L.l("`{0}' is an unknown attribute for {1}", (Object)attrName, Resource.this._mbeanName));
            }
            String typeName = attr.getType();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> type = Class.forName(typeName, false, loader);
            Object value = program.configure(type);
            AbstractMBeanServer server = Jmx.getMBeanServer();
            server.setAttribute(Resource.this.getObjectName(), new Attribute(attr.getName(), value));
        }

        private MBeanAttributeInfo getAttribute(String key) throws Throwable {
            int i;
            MBeanInfo info = Resource.this.getMBeanInfo();
            MBeanAttributeInfo[] attrs = info.getAttributes();
            if (attrs == null) {
                return null;
            }
            for (i = 0; i < attrs.length; ++i) {
                if (!attrs[i].getName().equals(key)) continue;
                return attrs[i];
            }
            for (i = 0; i < attrs.length; ++i) {
                if (!this.convertName(attrs[i].getName()).equals(key)) continue;
                return attrs[i];
            }
            return null;
        }

        private String convertName(String key) {
            CharBuffer cb = CharBuffer.allocate();
            for (int i = 0; i < key.length(); ++i) {
                char ch = key.charAt(i);
                if (!Character.isUpperCase(ch)) {
                    cb.append(ch);
                    continue;
                }
                if (i == 0) {
                    cb.append(Character.toLowerCase(ch));
                    continue;
                }
                if (Character.isLowerCase(key.charAt(i - 1))) {
                    cb.append('-');
                    cb.append(Character.toLowerCase(ch));
                    continue;
                }
                if (i + 1 != key.length() && Character.isLowerCase(key.charAt(i + 1))) {
                    cb.append('-');
                    cb.append(Character.toLowerCase(ch));
                    continue;
                }
                cb.append(Character.toLowerCase(ch));
            }
            return cb.close();
        }
    }
}

